
package com.openexchange.usm.datatypes.mail;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * POJO for defining vacation objects. Vacation objects are not synchronized!
 * 
 * @author <a href="mailto:ljupka.grabsh@microdoc.com">Ljupka Grabsch</a>
 */
public class Vacation {

    public static final String SUBJECT = "subject";

    public static final String ID = "id";

    public static final String ADDRESSES = "addresses";

    public static final String TEXT = "text";

    public static final String DAYS = "days";

    public static final String ACTIVE = "active";

    public static final String RULE_ID = "vacation";

    public static final String RULENAME = "Abwesenheit";

    private boolean active;

    private int days;

    private String text;

    private String subject;

    private int id;

    private List<String> addresses;

    private long startTime = 0;

    public Vacation(boolean active, int days, String text, List<String> addresses, int id, String subject) {
        this.active = active;
        this.days = days;
        this.text = text;
        this.addresses = addresses;
        this.id = id;
        this.subject = subject;
    }

    public Vacation() {
        this.active = false;
        this.days = 0;
        this.text = "";
        this.addresses = new ArrayList<String>();
        this.id = 0;
        this.subject = "";
    }

    public Vacation(JSONObject jObj) {
        // {"active":true,"id":0,"test":{"id":"true"},"rulename":"Abwesenheit","position":0,"actioncmds":[{"id":"vacation","days":"7","text":"This is a test Out Of Office email.","addresses":["user5@ox-p5.microdoc.com","user5@ox.
        active = jObj.has(ACTIVE) ? jObj.optBoolean(ACTIVE) : false;
        id = jObj.has(ID) ? jObj.optInt(ID) : 0;
        JSONArray actionCmds = jObj.optJSONArray("actioncmds");
        if (actionCmds != null && actionCmds.length() > 0) {
            JSONObject rule = actionCmds.optJSONObject(0);
            days = rule.has(DAYS) ? rule.optInt(DAYS) : 0;
            text = rule.has(TEXT) ? rule.optString(TEXT) : "";
            subject = rule.has(SUBJECT) ? rule.optString(SUBJECT) : "";
            JSONArray addressesJSON = rule.has(ADDRESSES) ? rule.optJSONArray(ADDRESSES) : new JSONArray();
            addresses = new ArrayList<String>();
            for (int i = 0; i < addressesJSON.length(); i++) {
                addresses.add(addressesJSON.optString(i));
            }
        } else {
            // set all default values
            days = jObj.has(DAYS) ? jObj.optInt(DAYS) : 0;
            text = jObj.has(TEXT) ? jObj.optString(TEXT) : "";
            subject = jObj.has(SUBJECT) ? jObj.optString(SUBJECT) : "";
            JSONArray addressesJSON = jObj.has(ADDRESSES) ? jObj.optJSONArray(ADDRESSES) : new JSONArray();
            addresses = new ArrayList<String>();
            for (int i = 0; i < addressesJSON.length(); i++) {
                addresses.add(addressesJSON.optString(i));
            }
        }

    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jObj = new JSONObject();
        jObj.put(ACTIVE, this.active);
        jObj.put(DAYS, this.days);
        jObj.put(TEXT, this.text);
        jObj.put(ID, this.id);
        jObj.put(SUBJECT, this.subject);
        jObj.put(ADDRESSES, new JSONArray(addresses));
        return jObj;
    }

    public JSONObject toActionCmdObject() throws JSONException {
        JSONObject actionCmd = new JSONObject();
        actionCmd.put(Vacation.ID, Vacation.RULE_ID);
        actionCmd.put(Vacation.DAYS, this.days);
        actionCmd.put(Vacation.ADDRESSES, new JSONArray(this.addresses));
        actionCmd.put(Vacation.TEXT, this.text);
        actionCmd.put(Vacation.SUBJECT, this.subject);
        return actionCmd;
    }

    public boolean isActive() {
        return active;
    }

    public int getDays() {
        return days;
    }

    public String getText() {
        return text;
    }

    public List<String> getAddresses() {
        return addresses;
    }

    public String getSubject() {
        return subject;
    }

    public int getId() {
        return id;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public long getStartTime() {
        return startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public String toString() {
        return "Vacation [active=" + active + ", days=" + days + ", text=" + text + ", subject=" + subject + ", id=" + id + ", addresses=" + addresses + "]";
    }

}
