/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.equinox.internal.util.pool.ObjectCreator;
import org.eclipse.equinox.internal.util.pool.ObjectPool;

public final class SCRUtil
implements ObjectCreator {
    private static ObjectPool objectArrayPool;
    private static Method setAccessibleMethod;
    private static Object[] args;
    private static boolean failed;

    static {
        SCRUtil u = new SCRUtil();
        objectArrayPool = new ObjectPool((ObjectCreator)u, 10, 2);
        setAccessibleMethod = null;
        args = null;
        failed = false;
    }

    private SCRUtil() {
    }

    public static Object[] getObjectArray() {
        return (Object[])objectArrayPool.getObject();
    }

    public static void release(Object[] objectArray) {
        int j = 0;
        while (j < objectArray.length) {
            objectArray[j] = null;
            ++j;
        }
        objectArrayPool.releaseObject((Object)objectArray);
    }

    public Object getInstance() throws Exception {
        return new Object[1];
    }

    public static void copyTo(Dictionary dst, Dictionary src) {
        if (src == null || dst == null) {
            return;
        }
        Enumeration e = src.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            dst.put(key, src.get(key));
        }
    }

    public static final void setAccessible(Method method) {
        try {
            if (setAccessibleMethod == null && !failed) {
                setAccessibleMethod = Class.forName("java.lang.reflect.AccessibleObject").getMethod("setAccessible", Boolean.TYPE);
                args = new Object[]{Boolean.TRUE};
            }
            if (setAccessibleMethod != null) {
                setAccessibleMethod.invoke((Object)method, args);
            }
        }
        catch (Exception exception) {
            failed = true;
        }
    }
}

