/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.util.Dictionary;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.model.ComponentReference;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;

public final class Reference {
    public ComponentReference reference;
    ServiceComponentProp scp;
    String interfaceName;
    String target;
    int policy;
    int cardinalityHigh;
    int cardinalityLow;
    Vector boundServiceReferences = new Vector(1);

    Reference(ComponentReference reference, ServiceComponentProp scp, Dictionary properties) {
        this.reference = reference;
        this.scp = scp;
        this.interfaceName = reference.interfaceName;
        this.target = reference.target;
        if (properties != null) {
            this.target = (String)properties.get(String.valueOf(reference.name) + ".target");
        }
        if (this.target == null) {
            this.target = "(objectClass=" + this.interfaceName + ")";
        }
        this.policy = reference.policy;
        switch (reference.cardinality) {
            case 0: {
                this.cardinalityLow = 0;
                this.cardinalityHigh = 1;
                break;
            }
            case 1: {
                this.cardinalityLow = 0;
                this.cardinalityHigh = 999999999;
                break;
            }
            case 2: {
                this.cardinalityLow = 1;
                this.cardinalityHigh = 1;
                break;
            }
            case 3: {
                this.cardinalityLow = 1;
                this.cardinalityHigh = 999999999;
            }
        }
    }

    final boolean hasProviders() {
        if (System.getSecurityManager() != null && !this.scp.bc.getBundle().hasPermission((Object)new ServicePermission(this.interfaceName, "get"))) {
            return false;
        }
        try {
            ServiceReference[] serviceReferences = null;
            serviceReferences = this.scp.bc.getServiceReferences(this.interfaceName, this.target);
            if (serviceReferences != null) {
                return true;
            }
        }
        catch (InvalidSyntaxException e) {
            Activator.log.warning("Reference.hasLegacyProviders(): invalid target filter " + this.target, (Throwable)e);
        }
        return false;
    }

    final boolean isRequiredFor(ServiceComponent cd) {
        return this.cardinalityLow == 1;
    }

    public boolean isRequired() {
        return this.cardinalityLow == 1;
    }

    public boolean isUnary() {
        return this.cardinalityHigh == 1;
    }

    final boolean bindNewReference(ServiceReference reference, boolean dynamicBind) {
        if (dynamicBind ? this.policy == 0 : this.policy == 1) {
            return false;
        }
        String[] serviceNames = (String[])reference.getProperty("objectClass");
        boolean hasName = false;
        int i = 0;
        while (i < serviceNames.length) {
            if (serviceNames[i].equals(this.interfaceName)) {
                hasName = true;
                break;
            }
            ++i;
        }
        if (!hasName) {
            return false;
        }
        try {
            Filter filter = FrameworkUtil.createFilter((String)this.target);
            if (!filter.match(reference)) {
                return false;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
        return this.reference.bind != null ? this.reference.serviceReferences.size() < this.cardinalityHigh : !dynamicBind && this.boundServiceReferences.size() < this.cardinalityHigh;
    }

    final boolean dynamicUnbindReference(ServiceReference changedReference) {
        if (this.policy == 0) {
            return false;
        }
        return this.reference.serviceReferences.containsKey(changedReference);
    }

    final boolean staticUnbindReference(ServiceReference changedReference) {
        if (this.policy == 1) {
            return false;
        }
        if (this.reference.serviceReferences.containsKey(changedReference)) {
            return true;
        }
        if (this.boundServiceReferences.size() > 0) {
            return this.cardinalityHigh == 1 ? this.boundServiceReferences.elementAt(0) == changedReference : this.boundServiceReferences.contains(changedReference);
        }
        return false;
    }

    public void setBoundServiceReferences(ServiceReference[] references) {
        if (this.policy == 1) {
            return;
        }
        this.boundServiceReferences.removeAllElements();
        if (this.cardinalityHigh == 1) {
            this.boundServiceReferences.addElement(references[0]);
        } else {
            int i = 0;
            while (i < references.length) {
                this.boundServiceReferences.addElement(references[i]);
                ++i;
            }
        }
    }

    public ServiceComponentProp[] selectProviders(Vector scps) {
        Filter filter;
        try {
            filter = FrameworkUtil.createFilter((String)this.target);
        }
        catch (InvalidSyntaxException e) {
            Activator.log.warning("Reference.findProviderSCP(): invalid target filter " + this.target, (Throwable)e);
            return null;
        }
        Vector<ServiceComponentProp> result = new Vector<ServiceComponentProp>(2);
        int i = 0;
        while (i < scps.size()) {
            ServiceComponentProp providerSCP = (ServiceComponentProp)scps.elementAt(i);
            if (providerSCP.serviceComponent.serviceInterfaces != null && providerSCP.serviceComponent.serviceInterfaces.contains(this.interfaceName) && filter.match((Dictionary)providerSCP.getProperties())) {
                result.addElement(providerSCP);
            }
            ++i;
        }
        Object[] res = new ServiceComponentProp[result.size()];
        result.copyInto(res);
        return res;
    }

    public Vector getBoundServiceReferences() {
        return this.boundServiceReferences;
    }
}

