/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.api.session;

import java.util.Map;

import com.openexchange.usm.api.exceptions.USMException;

/**
 * Service that provides access to a Session. A Session is uniquely
 * identified by the user and the device.
 * 
 * @author afe
 *
 */
public interface SessionManager {
	/**
	 * Request a specific Session. When the Session is returned, it
	 * is guaranteed that the Session either is correctly authenticated
	 * on the OX server or still in the Cache from a previous access
	 * (and was therefore previously authenticated).<br>
	 * The Session will be initialized so that all currently available
	 * ContentTypes with all of their fields are synchronized.
	 * 
	 * @param user user name / login
	 * @param password password for the user
	 * @param protocol the name of the Sync protocol (ex. EAS)
	 * @param device unique device ID
	 * @return unique Session (regarding user and device)
	 * @throws USMException if session can not be retrieved (e.g. login fails or a communication error occurred)
	 */
    @Deprecated
	Session getSession(String user, String password, String protocol, String device) throws USMException;

	/**
	 * Request a specific Session. When the Session is returned, it
	 * is guaranteed that the Session either is correctly authenticated
	 * on the OX server or still in the Cache from a previous access
	 * (and was therefore previously authenticated). A SessionInitializer
	 * is called after it is determined that the session has been created
	 * for the first time (i.e. no persistent information was found in the
	 * database). This SessionInitializer is called before the Session is
	 * returned and can be used to configure the Session, e.g. to set used
	 * ContentTypes and their relevant fields.<br>
	 * If a SessionInitializer is provided, a new Session will be initialized
	 * with no ContentType set (i.e. all ContentTypes are completely filtered
	 * out) and the SessionInitializer has to provide the correct
	 * initialization.<br>
	 * If no SessionInitializer is provided (<code>null</code>), the Session
	 * will be initialized so that all currently available ContentTypes with
	 * all of their fields are synchronized.
	 * 
	 * @param user
	 * @param password
	 * @param protocol 
	 * @param device
	 * @param initializer
	 * @param clientIP
	 * @param xHeaders
	 * @return
	 * @throws USMException
	 */
	Session getSession(String user, String password, String protocol, String device, SessionInitializer initializer,
			String clientIP, Map<String, String> xHeaders) throws USMException;

	boolean existsSessionInDB(String user, String protocol, String device) throws USMException;
}
