-- SQL definition for database tables used by the USM to store long ids and map them to short ones 
-- Note that this needs adjustments if Hsql is not used

create cached table usmIdMapping (cid integer NOT NULL, usmSessionId integer NOT NULL, LongID varchar(256) NOT NULL, ShortID integer not null);
create sequence shortIds AS INTEGER START WITH 1;
create unique index usmIdMappingUIDX on usmIdMapping (cid, usmSessionId, shortId);

-- only required to allow usage of sequence
create cached table sequence_usmIdMapping (cid integer not null, id integer not null);
insert into sequence_usmIdMapping values(1,0);

create cached table easUIDMapping (cid integer NOT NULL, usmSessionId integer NOT NULL, FolderID varchar(64) NOT NULL, LongID varchar(64) NOT NULL, ShortID integer not null);
create unique index easUIDMappingUIDX on easUIDMapping (cid, usmSessionId, FolderID, ShortID);