/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.database.ox;

import java.util.*;

import org.apache.commons.logging.Log;
import org.osgi.service.component.ComponentContext;

import com.openexchange.database.DatabaseService;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskProviderService;
import com.openexchange.usm.api.database.DatabaseAccess;
import com.openexchange.usm.database.ox.update.*;
import com.openexchange.usm.journal.Journal;

public class USMUpdateTaskProvider implements UpdateTaskProviderService {

	private DatabaseService _service;
	private Log _journal;

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void activate(ComponentContext context) {
		Journal journal = (Journal) context.locateService(Journal.class.getName());
		_journal = journal.getLog(DatabaseAccess.class);
		_service = (DatabaseService) context.locateService(DatabaseService.class.getName());
		_journal.info("UpdateTaskProviderService 'USMUpdateTaskProvider' activated");
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void deactivate(ComponentContext context) {
		_service = null;
		_journal.info("UpdateTaskProviderService 'USMUpdateTaskProvider' deactivated");
		_journal = null;
	}

	public Collection<UpdateTask> getUpdateTasks() {
		List<UpdateTask> updateTasks = new ArrayList<UpdateTask>();
		updateTasks.add(new USMTablesUpdateTask(this));
		updateTasks.add(new USMClearTablesUpdateTask(this));
		updateTasks.add(new USMUUIDTablesUpdateTask(this));
		updateTasks.add(new USMClearTablesUpdateTask93(this));
		updateTasks.add(new USMTablesUpdateTaskV2(this));
		updateTasks.add(new USMUUIDTablesUpdateTaskV2(this));
		//		updateTasks.add(new USMClearTablesUpdateTaskV2(this)); // Do not provide this to prevent unnecessary deletion of database content which would cause slow syncs
		updateTasks.add(new ChangeCollationUpdateTask(this));
		// TODO The next UpdateTask should include code to remove all stored procedures for sequences used throughout USM
		return updateTasks;
	}

	public DatabaseService getDatabaseService() {
		return _service;
	}

	public Log getJournal() {
		return _journal;
	}
}
