/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.datatypes.tasks.calendar;

import java.io.Serializable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Defines Participant Identifier in the Tasks Module. 
 *  
 * @author ldo
 *
 */
public final class ParticipantIdentifier implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	static final String TYPE = "type";
	static final String ID = "id";
	static final String DISPLAY_NAME = "display_name";
	static final String MAIL = "mail";
	/** User ID. */
	private final int _id;
	/** Type of participant:
	 * 1 	user
	 * 2 	user group
	 * 3 	resource
	 * 4 	resource group
	 * 5 	external user 
	*/
	private final int _type;

	private final String _displayName;

	private final String _mail;

	public ParticipantIdentifier(int id, int type, String displayName, String mail) {
		_id = id;
		_type = type;
		_displayName = displayName == null ? "" : displayName;
		_mail = mail == null ? "" : mail;
	}

	public ParticipantIdentifier(JSONObject jObject) throws JSONException {
		_type = jObject.getInt(TYPE);
		switch (_type) {
			case 1:
			case 2:
			case 3:
			case 4:
				_id = jObject.getInt(ID);
				_displayName = "";
				_mail = "";
				break;
			case 5:
				_id = 0;
				_displayName = jObject.has(DISPLAY_NAME) ? (jObject.isNull(DISPLAY_NAME) ? "" : jObject.getString(DISPLAY_NAME)) : "";
				_mail = jObject.has(MAIL) ?(jObject.isNull(MAIL) ? "" : jObject.getString(MAIL)) : "";
				break;
			default:
				throw new JSONException("Invalid ParticipantIdentifier type " + _type);
		}
	}

	public ParticipantIdentifier() {
		_id = 0;
		_type = 0;
		_displayName = "";
		_mail = "";
	}

	public int getId() {
		return _id;
	}

	public int getType() {
		return _type;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + _id;
		result = prime * result + _type;
		result = prime * result + _displayName.hashCode();
		result = prime * result + _mail.hashCode();
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ParticipantIdentifier other = (ParticipantIdentifier) obj;
		if (_id != other.getId())
			return false;
		if (_type != other.getType())
			return false;
		if (!_displayName.equals(other.getDisplay_name()))
			return false;
		if (!_mail.equals(other.getMail()))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return '{' + ID + ':' + String.valueOf(_id) + ';' + TYPE + ':' + String.valueOf(_type) + ';' + DISPLAY_NAME
				+ ':' + _displayName + ';' + MAIL + ':' + _mail + '}';
	}

	public JSONObject toJSONObject() throws JSONException {
		JSONObject result = new JSONObject();
		result.put(ID, _id);
		result.put(TYPE, _type);
		if (_type == 5) {
			result.put(DISPLAY_NAME, _displayName);
			result.put(MAIL, _mail);
		}
		return result;
	}

	public String getDisplay_name() {
		return _displayName;
	}

	public String getMail() {
		return _mail;
	}
}
