/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.cache.ox_adapter;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import com.openexchange.exception.OXException;
import com.openexchange.usm.cache.Cache;

/**
 * Adapter for the Cache interface to the OX Caching Interface.
 *
 * @author ldo
 *
 * @param <K> Type of keys for Cache
 * @param <V> Type of values for Cache
 */
public class CacheAdapter<K extends Serializable, V extends Serializable> implements Cache<K, V> {

	private final com.openexchange.caching.Cache _cacheImpl;
	private final Log _journal;

	public CacheAdapter(com.openexchange.caching.Cache cacheImpl, Log log) {
		_cacheImpl = cacheImpl;
		_journal = log;
	}

	@SuppressWarnings("unchecked")
	public V get(K name) {
		return (V) _cacheImpl.get(name);
	}

	public void put(K name, V obj, boolean invalidate) {
		try {
			_cacheImpl.put(name, obj, invalidate);
		} catch (OXException e) {
			_journal.error("Cache: put failed.", e);
		}
	}

	public void putSafe(K name, V obj) {
		try {
			_cacheImpl.putSafe(name, obj);
		} catch (OXException e) {
			_journal.error("Cache: put safe failed.", e);
		}
	}

	public void remove(K name) {
		try {
			_cacheImpl.remove(name);
		} catch (OXException e) {
			_journal.error("Cache: remove failed.", e);
		}
	}

	public void dispose() {
		_cacheImpl.dispose();
	}
}
