/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.uuid.impl;

/**
 * Contains constants for creating the UUID Cache configuration.
 *
 * @author ldo
 *
 */
public interface UUIDCacheConfiguration {


	/*

     * Cache configuration constants

     */

    final int maxObjects = 1000000; // The max. number of objects allowed to be held in cache

    final int maxLifeSeconds = 300; // The max. life seconds; if exceeded the element is forced to be removed

    final int idleTimeSeconds = 1800; // The max. time in seconds an element may reside idle in cache

    final int shrinkerIntervalSeconds = 60; // How often to look for (and clean) exceeded or timed-out elements

    /*

     * Compose cache configuration

     */
    static final String USMOX_OBJECT_ID_TO_UUID_CACHE = "USMOXObjectIDToUUIDCache"; //regionName

    static final String USMUUID_TO_OX_OBJECT_ID_CACHE = "USMUUIDToOXObjectIDCache"; //regionName


    static final byte[] oxObjectToUIDCache = ("jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + "=LTCP\n" + // Use lateral TCP cache!

    "jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + ".cacheattributes=org.apache.jcs.engine.CompositeCacheAttributes\n" +

    "jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + ".cacheattributes.MaxObjects=" + maxObjects + "\n" +

    "jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + ".cacheattributes.MemoryCacheName=org.apache.jcs.engine.memory.lru.LRUMemoryCache\n" +

    "jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + ".cacheattributes.UseMemoryShrinker=true\n" +

    "jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + ".cacheattributes.MaxMemoryIdleTimeSeconds=" + idleTimeSeconds + "\n" +

    "jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + ".cacheattributes.ShrinkerIntervalSeconds=" + shrinkerIntervalSeconds + "\n" +

    "jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + ".elementattributes=org.apache.jcs.engine.ElementAttributes\n" +

    "jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + ".elementattributes.IsEternal=false\n" +

    "jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + ".elementattributes.MaxLifeSeconds=" + maxLifeSeconds + "\n" +

    "jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + ".elementattributes.IdleTime=" + idleTimeSeconds + "\n" +

    "jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + ".elementattributes.IsSpool=false\n" +

    "jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + ".elementattributes.IsRemote=false\n" +

    "jcs.region." + USMOX_OBJECT_ID_TO_UUID_CACHE + ".elementattributes.IsLateral=false\n").getBytes();


    static final byte[] uuidToOxObjectCache = ("jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + "=LTCP\n" + // Use lateral TCP cache!

    "jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + ".cacheattributes=org.apache.jcs.engine.CompositeCacheAttributes\n" +

    "jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + ".cacheattributes.MaxObjects=" + maxObjects + "\n" +

    "jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + ".cacheattributes.MemoryCacheName=org.apache.jcs.engine.memory.lru.LRUMemoryCache\n" +

    "jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + ".cacheattributes.UseMemoryShrinker=true\n" +

    "jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + ".cacheattributes.MaxMemoryIdleTimeSeconds=" + idleTimeSeconds + "\n" +

    "jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + ".cacheattributes.ShrinkerIntervalSeconds=" + shrinkerIntervalSeconds + "\n" +

    "jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + ".elementattributes=org.apache.jcs.engine.ElementAttributes\n" +

    "jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + ".elementattributes.IsEternal=false\n" +

    "jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + ".elementattributes.MaxLifeSeconds=" + maxLifeSeconds + "\n" +

    "jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + ".elementattributes.IdleTime=" + idleTimeSeconds + "\n" +

    "jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + ".elementattributes.IsSpool=false\n" +

    "jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + ".elementattributes.IsRemote=false\n" +

    "jcs.region." + USMUUID_TO_OX_OBJECT_ID_CACHE + ".elementattributes.IsLateral=false\n").getBytes();

}
