/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.ant.tasks;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * Will prepare the set of bundles for an osgi start
 *
 * @author <a href="mailto:felix.marx@open-xchange.com">Felix Marx</a>
 */
public class PrepareOsgiTestProperties extends Task {

    private HashSet<String> classPath;
    private String property;
    private String frameworkProperty;
    private String frameworkContains;
    private String delimiter;
    private String bundlesDir;
    public PrepareOsgiTestProperties() {
        super();
    }

    public final void setProperty(String property) {
        this.property = property;
    }

    public final void setFrameworkProperty(String frameworkProperty) {
        this.frameworkProperty = frameworkProperty;
    }

    public final void setFrameworkContains(String frameworkContains) {
        this.frameworkContains = frameworkContains;
    }


    public final void setClassPath(String classPath) {
        if (classPath.length() != 0){
             this.classPath = new HashSet<String>(Arrays.asList(classPath.split(",", 0)));

        }
    }

    public final void setDelimiter(String delimiter) {
        if (delimiter.length() != 0) {
            this.delimiter = delimiter;
        }
    }

    public final void setBundlesDir(String bundlesDir) {
        this.bundlesDir = bundlesDir;
    }

    @Override
    public final void execute() throws BuildException {
        if (property == null) {
            throw new BuildException("Please define property.");
        }
        if (delimiter == null) {
            throw new BuildException("Please define delimiter.");
        }
        if (bundlesDir == null) {
            throw new BuildException("Please define bundlesDir.");
        }

        HashSet<String> tmpClassPath = new HashSet<String>();
        for (String s : classPath) {
            if (s.contains(frameworkContains)){
                getProject().log(frameworkProperty+": "+ s, getProject().MSG_DEBUG);
                getProject().setInheritedProperty(frameworkProperty, s);
            } else if (s.startsWith(bundlesDir)){
                s = s.substring(bundlesDir.length() + 1);
                if (s.contains("/")){
                    s = s.substring(0, s.indexOf("/"));
                }
                tmpClassPath.add(s);
            } else {
                tmpClassPath.add(s);
            }
        }
        classPath = tmpClassPath;

        String tmpString = "";
        for (String s:classPath){
             if (s.contains("com.openexchange.system.extension")) {
                tmpString = tmpString + s + delimiter;
            } else if (s.equals("com.openexchange.test.osgi")) {
                tmpString = tmpString + s + "@5:start" + delimiter;
            } else {
                tmpString = tmpString + s + "@start" + delimiter;
            }

        }
        if (tmpString.endsWith(delimiter)){
            tmpString = tmpString.substring(0, tmpString.length()-1);
        }
        getProject().log(property+": "+ tmpString, getProject().MSG_DEBUG);
        getProject().setInheritedProperty(property, tmpString);
    }
}
