/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.util;

import java.sql.*;

import com.openexchange.usm.api.database.EncapsulatedConnection;

public class SQLToolkit {

	public static final String SQL_SEQUENCE_STATEMENT_PART1 = "CREATE TABLE ";
	public static final String SQL_SEQUENCE_STATEMENT_PART2 = " (cid INT4 UNSIGNED NOT NULL, id INT4 UNSIGNED NOT NULL, PRIMARY KEY (cid)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin";

	public static final String INITIALIZE_SQL_SEQUENCE_STATEMENT_PART1 = "INSERT INTO ";
	public static final String INITIALIZE_SQL_SEQUENCE_STATEMENT_PART2 = " VALUES( ";
	public static final String INITIALIZE_SQL_SEQUENCE_STATEMENT_PART3 = ", 0)";

	public static final String INITIALIZE_SQL_SEQUENCE_STATEMENT_PART3_INIT1 = ", 1)";

	public static String createSequenceStatement(String tableName) {
		return SQL_SEQUENCE_STATEMENT_PART1 + tableName + SQL_SEQUENCE_STATEMENT_PART2;
	}

	public static String createInitilizeSequenceStatement(String tableName, int contextID) {
		return INITIALIZE_SQL_SEQUENCE_STATEMENT_PART1 + tableName + INITIALIZE_SQL_SEQUENCE_STATEMENT_PART2
				+ contextID + INITIALIZE_SQL_SEQUENCE_STATEMENT_PART3;
	}

	public static String createInsertFirstValueSequenceStatement(String tableName, int contextID) {
		return INITIALIZE_SQL_SEQUENCE_STATEMENT_PART1 + tableName + INITIALIZE_SQL_SEQUENCE_STATEMENT_PART2
				+ contextID + INITIALIZE_SQL_SEQUENCE_STATEMENT_PART3_INIT1;
	}

	public static String createSequenceProcedure(String tableName) {
		StringBuilder result = new StringBuilder(500);
		result.append("CREATE PROCEDURE ");
		result.append("get_");
		result.append(tableName);
		result.append("_id(IN context INT4 UNSIGNED)");
		result.append(" NOT DETERMINISTIC MODIFIES SQL DATA BEGIN UPDATE ");
		result.append(tableName);
		result.append(" SET id=id+1 WHERE cid=context;  SELECT id FROM ");
		result.append(tableName);
		result.append(" WHERE cid=context; END");
		return result.toString();
	}

	public static String createGetNextCall(String tableName, int contextID) {
		return "CALL get_" + tableName + "_id(" + contextID + ")";
	}

	public static String dropSequenceProcedure(String sequenceName) {
		return "DROP PROCEDURE IF EXISTS get_" + sequenceName + "_id";
	}

	public static int getNextIdFromSequence(EncapsulatedConnection con, String sequenceName, int contextID)
			throws SQLException {
		PreparedStatement stmt = null;
		ResultSet result = null;
		try {
			con.setAutoCommit(false);
			stmt = con.prepareStatement("UPDATE " + sequenceName + " SET id=id+1 WHERE cid = ?");
			stmt.setInt(1, contextID);
			stmt.execute();
			stmt.close();
			stmt = con.prepareStatement("SELECT id FROM " + sequenceName + " WHERE cid = ?");
			stmt.setInt(1, contextID);
			result = stmt.executeQuery();
			if (result.next()) {
				int rv = result.getInt(1);
				stmt.close();
				con.commit();
				return rv;
			}
			stmt.close();
			stmt = con.prepareStatement("INSERT INTO " + sequenceName + " VALUES(?, 1)");
			stmt.setInt(1, contextID);
			stmt.execute();
			stmt.close();
			con.commit();
			return 1;
		} catch (SQLException e) {
			con.rollback();
			throw e;
		} finally {
			try {
				con.setAutoCommit(true);
			} finally {
				Toolkit.close(result);
				Toolkit.close(stmt);
			}
		}
	}
}
