/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.json;

import java.io.Serializable;

public class USMSessionID implements Comparable<USMSessionID>, Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final String _user;

	private final String _device;
	
	private final String _password;
	
	public USMSessionID(String user, String device, String password) {
		_user = user;
		_device = device;
		_password = password;
	}

	public String getUser() {
		return _user;
	}

	public String getDevice() {
		return _device;
	}

	public String getPassword() {
		return _password;
	}
	
	public int compareTo(USMSessionID o) {
		int result = _user.compareTo(o._user);
		if (result == 0) {
			result = _password.compareTo(o._password);
			if (result == 0)
				result = _device.compareTo(o._device);
		}
		return result;
	}

	@Override
	public String toString() {
		return _user + ':' + ':' + _device;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((_device == null) ? 0 : _device.hashCode());
		result = prime * result + ((_password == null) ? 0 : _password.hashCode());
		result = prime * result + ((_user == null) ? 0 : _user.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof USMSessionID))
			return false;
		USMSessionID other = (USMSessionID) obj;
		if (_device == null) {
			if (other._device != null)
				return false;
		} else if (!_device.equals(other._device))
			return false;
		if (_password == null) {
			if (other._password != null)
				return false;
		} else if (!_password.equals(other._password))
			return false;
		if (_user == null) {
			if (other._user != null)
				return false;
		} else if (!_user.equals(other._user))
			return false;
		return true;
	}

	
}
