/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.api.session;

import com.openexchange.usm.api.contenttypes.ContentType;
import com.openexchange.usm.api.contenttypes.FolderContentType;

/**
 * Extension to the DataObject for the ContentType "folder" that provides
 * easy access methods for special fields.
 *
 *
 * @author afe
 *
 */
public interface Folder extends DataObject {

	FolderContentType getContentType();

	/**
	 * This method will retrieve the ID of the ContentType, or if none is set yet,
	 * it will return the value of the appropriate field that contains the id
	 * (i.e. normally "module" for OX).
	 *
	 * @return ID of the ContentType of the elements in this Folder
	 */
	String getElementsContentTypeID();

	/**
	 *
	 * @return ContentType of the elements in this Folder
	 */
	ContentType getElementsContentType();

	/**
	 * This method is used by the sync system to set the ContentType of elements of the Folder.
	 * It can be called only once after creation, later calls throw an IllegalStateException.
	 *
	 *
	 * @param type
	 * @throws IllegalStateException if the ContentType has already been set
	 */
	void setElementsContentType(ContentType type);

	/**
	 * @return original timestamp for last content synchronization
	 */
	long getOriginalContentSyncTimestamp();

	/**
	 * @return currently set timestamp for current content synchronization
	 */
	long getContentSyncTimestamp();

	/**
	 * Sets the timestamp for the current content synchronization. All elements
	 * that are changed will have their timestamps set to this value, too.
	 *
	 * @param timestamp milliseconds since midnight, January 1, 1970 UTC.
	 */
	void setContentSyncTimestamp(long timestamp);

	/**
	 * Create an exact copy of the current state of this Folder.
	 *
	 * @param linkUUIDs if true, modifications to a UUID will be performed in both the original and the copy
	 * @return
	 */
	Folder createCopy(boolean linkUUIDs);

	/**
	 *
	 * @return true if Folder has sub-folders or if it can not be determined if it has, false if it has no sub folders. This method always operates on the current content of the Folder (original is ignored)
	 */
	boolean hasSubFolders();

	int getOwnerID();
}
