/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.ant.tasks;

import java.awt.List;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

/**
 * Reads properties from a 3rdPartyLibs.properties file and can also empty a give set of properties prior to reading the new ones.
 *
 * @author <a href="mailto:felix.marx@open-xchange.com">Felix Marx</a>
 */
public class Create3rdPartyWebpage extends Task {

    Path libs;

    Path propertiesFile;

    Path docs;

    String name;

    String property;
    
    String failProperty;
    
    String delimiter;
    
    StringBuilder sbfailed = new StringBuilder();

    public Create3rdPartyWebpage() {
        super();
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setProperty(String property) {
        this.property = property;
    }
    
    public final void setFailProperty(String failProperty){
        this.failProperty = failProperty;
    }
    
    public final void setDelimiter(String delimiter){
        this.delimiter = delimiter;
    }
    

    public final Path createPropertiesFile() {
        propertiesFile = new Path(getProject());
        return propertiesFile;
    }

    public final Path createLibs() {
        libs = new Path(getProject());
        return libs;
    }

    public final Path createDocs() {
        docs = new Path(getProject());
        return docs;
    }

    @Override
    public final void execute() throws BuildException {
        // checks
        if (libs == null) {
            throw new BuildException("Please define libs.");
        }
        if (docs == null) {
            throw new BuildException("Please define docs.");
        }
        if (propertiesFile == null) {
            throw new BuildException("Please define propertiesFile.");
        }

        // Fill the map for he properties file
        // Additionaly fill another Set which refers to all codesegments
        Map<String, String> propFile = new HashMap<String, String>();
        Map<String, String> libIdentifiers = new HashMap<String, String>();
        
        Set<String> outPutSet = new TreeSet<String>();
        for (final String filename : propertiesFile.list()) {
            log("Reading " + filename + " for " + name, Project.MSG_DEBUG);
            final Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(filename));
            } catch (IOException e) {
                throw new BuildException("Can not read file \"" + filename + "\".", e);
            }

            for (Object entryKey : properties.keySet()) {
                final String key = (String) entryKey;
                final String value = properties.getProperty(key);
                propFile.put(key, value);
                if(value.contains("codeSegment")){
                    libIdentifiers.put(key,"");
                }
            }
        }

        // Prepare Docs to be a HashMap
        Map<String, String> docsMap = new HashMap<String, String>();
        for (final String filePathName : docs.list()) {
            int index = filePathName.lastIndexOf(File.separatorChar);
            String fileName = filePathName.substring(index + 1);
            docsMap.put(fileName, filePathName);
        }

        
        
        //prepare the LibList
        for (final String filePathName : libs.list()) {
            int index = filePathName.lastIndexOf(File.separatorChar);
            String fileName = filePathName.substring(index + 1);
            prepareFile(propFile, libIdentifiers, fileName);
        }
        //Work on all codesegments
        for (final Iterator<Entry<String, String>> iter = libIdentifiers.entrySet().iterator(); iter.hasNext();) {
            Entry<String, String> e = iter.next();
            String identifierName = e.getKey();
            String possibleFileName = e.getValue();
            
            final StringBuilder sb = new StringBuilder();
            prepareInformation(propFile, docsMap, sb, identifierName, possibleFileName);
            outPutSet.add(sb.toString());
        }

        ArrayList<String> outputList = new ArrayList<String>(outPutSet);
        
        Collections.sort(outputList, new Comparator<String>() {
            public int compare(String o1, String o2) {              
                return o1.compareToIgnoreCase(o2);
            }
        });

        
        final StringBuilder sb = new StringBuilder();
        if (!outputList.isEmpty()) {
            sb.append("<h3><a name=\""+name+"\"></a>"+name+ "</h3>").append("\n");
            sb.append("<ul>").append("\n");
            
            for (String s : outputList){
                sb.append(s);
            }

            sb.append("</ul>").append("\n");
        }
        
        getProject().setInheritedProperty(property, sb.toString());
        log(property + ' ' + sb.toString(), Project.MSG_DEBUG);
        
        if (sbfailed.length() > 0){
            getProject().setInheritedProperty(failProperty, sbfailed.toString());
        }
    }

    private void prepareFile(Map<String, String> propFile, Map<String, String> libIdentifiers, String fileName) {
        String identifierName = propFile.get(fileName);
        
        if (identifierName != null) {
            if (identifierName.equalsIgnoreCase("ignore")) {
                log(name + ": No information nedded for file: " + fileName, Project.MSG_DEBUG);
            } else {
                String identifierNameAlreadyTaken = libIdentifiers.get(identifierName);
                if (identifierNameAlreadyTaken != null) {
                    libIdentifiers.put(identifierName, identifierNameAlreadyTaken + ", " + fileName);
                } else {
                    libIdentifiers.put(identifierName,fileName);
                }
            }
        } else {
//            log(name + ": No identifier set for file: \"" + fileName + "\".", Project.MSG_ERR);
            sbfailed.append(name + ": No identifier set for file: \"" + fileName + "\".").append(delimiter);
        }
    }
    
    private void prepareInformation(Map<String, String> propFile, Map<String, String> docsMap, final StringBuilder sb, String identifierName, String possibleFileName) {
        sb.append("<p />").append("\n");
        getTitle(propFile, identifierName, possibleFileName, sb);
        sb.append("<ul>").append("\n");
        getCreator(propFile, identifierName, sb);
        getWebsite(propFile, identifierName, sb);
        getLicenseTyp(propFile, identifierName, sb);
        getAdditionalInformation(propFile, identifierName, sb);
        findDoc(propFile, docsMap, identifierName,possibleFileName,sb);
        sb.append("</ul>").append("\n");
    }
    
    private void findDoc(Map<String, String> propFile, Map<String, String> docsMap, String identifierName, String possibleFileName, StringBuilder sb) {
        String docsIdentifier = propFile.get(identifierName + ".doc");
        if (null != docsIdentifier) {
            if (!docsIdentifier.equalsIgnoreCase("noDocNeeded")){
                HashSet<String> multipleDocs = new HashSet<String>(Arrays.asList(docsIdentifier.split(",", 0)));
                for (final Iterator<String> iter = multipleDocs.iterator(); iter.hasNext();) {
                    String docFileName = iter.next();
                    log("The Doc for " + identifierName + " is named " + docFileName + ".", Project.MSG_DEBUG);
                    String docPathName = docsMap.get(docFileName);
                    if (null != docPathName) {
                        log("The Path to the Doc for " + identifierName + " is " + docPathName + ".", Project.MSG_DEBUG);
                        sb.append("<li> License artefact used: " + docFileName + " </li>");
                    } else {
                        throw new BuildException("No Doc for file \"" + possibleFileName + "\".");
                    } 
                }
            } 
        } else {
            throw new BuildException(name + ": No Doc information for file: \"" + possibleFileName + "\".");
        }
        sb.append("\n");
    }
    
    private void getTitle(Map<String, String> propFile,String identifierName, String possibleFileName, StringBuilder sb) {
        String title = propFile.get(identifierName + ".specificName");
        if (null != title){
            sb.append(title + " (" + possibleFileName + ")");
        } else {
            sb.append(possibleFileName);
        }
    }
    
    private void getWebsite(Map<String, String> propFile,String identifierName, StringBuilder sb) {
        String url = propFile.get(identifierName + ".url");
        if (null != url){
            sb.append("<li> <a href=\"" + url + "\" target=\"_top\">" + url + "</a> </li>").append("\n");
        }
    }
    
    private void getCreator(Map<String, String> propFile,String identifierName, StringBuilder sb) {
        String creator = propFile.get(identifierName + ".creator");
        if (null != creator){
            sb.append("<li> " + creator + "</li>").append("\n");
        }
    }
    
    private void getLicenseTyp(Map<String, String> propFile,String identifierName, StringBuilder sb) {
        String licence = propFile.get(identifierName + ".license");
        if (null != licence){
            sb.append("<li> " + licence + " </li>").append("\n");
        }
    }
    
    private void getAdditionalInformation(Map<String, String> propFile,String identifierName, StringBuilder sb) {
        String information = propFile.get(identifierName + ".additionalInformation");
        if (null != information){
            sb.append("<li> " + information + " </li>").append("\n");
        }
    }
}
