/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.uuid.impl;

import java.util.UUID;

import org.osgi.service.component.ComponentContext;

import com.openexchange.usm.api.database.DatabaseAccess;
import com.openexchange.usm.api.database.DatabaseAccessException;
import com.openexchange.usm.api.exceptions.USMSQLException;
import com.openexchange.usm.cache.CacheManager;
import com.openexchange.usm.journal.Journal;
import com.openexchange.usm.uuid.OXObjectID;
import com.openexchange.usm.uuid.UUIDMappingService;
import com.openexchange.usm.uuid.exceptions.OXObjectAlreadyMappedException;
import com.openexchange.usm.uuid.exceptions.UUIDAlreadyMappedException;

/**
 * Implementation of the UUID Mapping Service.
 * @author ldo
 *
 */
public class UUIDMappingServiceImpl implements UUIDMappingService {

	private final UUIDMappingImpl _delegate = new UUIDMappingImpl();

	public void activate(ComponentContext context) {
		Journal journal = (Journal) context.locateService(Journal.class.getName());
		DatabaseAccess dbAccess = (DatabaseAccess) context.locateService(DatabaseAccess.class.getName());
		CacheManager cacheManager = (CacheManager) context.locateService(CacheManager.class.getName());
		_delegate.activate(journal.getLog(UUIDMappingService.class), dbAccess, cacheManager);
	}

	public void deactivate(ComponentContext context) {
		_delegate.deactivate();
	}

	public OXObjectID getMappedObject(int cid, UUID uuid) throws DatabaseAccessException, USMSQLException {
		return _delegate.getMappedObject(cid, uuid);
	}

	public UUID getUUID(int cid, int contentType, int objectId) throws DatabaseAccessException, USMSQLException {
		return _delegate.getUUID(cid, contentType, objectId);
	}

	public void storeMapping(UUID uuid, OXObjectID oxObjectId) throws DatabaseAccessException, USMSQLException,
			UUIDAlreadyMappedException, OXObjectAlreadyMappedException {
		_delegate.storeMapping(uuid, oxObjectId);
	}

	public void removeMapping(int contextId, OXObjectID oxObjectId) throws DatabaseAccessException, USMSQLException {
		_delegate.removeMapping(contextId, oxObjectId);
	}

	public UUID getContextUUID(int cid) throws DatabaseAccessException, USMSQLException {
		return _delegate.getContextUUID(cid);
	}
}
