/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.realtime.impl;

import java.lang.ref.WeakReference;
import com.openexchange.realtime.packet.ID;
import com.openexchange.session.Session;


/**
 * A PrepareLosingEditRightsTimeoutRunnable provides a time-out mechanism which is needed while switching edit rights from one client to
 * another client.
 *
 * @author Carsten Driesner
 */
public class PrepareLosingEditRightsTimeoutRunnable implements Runnable {

    // - Members ----------------------------------------------------------------
    static protected final org.apache.commons.logging.Log LOG = com.openexchange.log.LogFactory.getLog(PrepareLosingEditRightsTimeoutRunnable.class);
    private final WeakReference<DocumentConnection> m_connection;
    private final Session m_session;
    private final ID m_fromId;

    /**
     * Initializes a new instance of a PrepareLosingEditRightsTimeoutRunnable.
     *
     * @param connection The reference to the Connection instance that needs the time-out mechanism.
     * @param session The session of the client that has to release the edit rights.
     * @param fromId The ID of the client that has to release the edit rights.
     */
    public PrepareLosingEditRightsTimeoutRunnable(final DocumentConnection connection, Session session, ID fromId) {
        super();
        m_connection = new WeakReference<DocumentConnection>(connection);
        m_session = session;
        m_fromId = fromId;
    }

    /**
     * The method that gets called by the timer service. It calls an internal method
     * of the Connection instance to handle a timeout case.
     */
    @Override
    public void run() {
        LOG.debug("RT connection: RT handling waiting for answer [canloseeditrights]. (Extended) timeout reached, no answer from client or still busy: " + m_fromId.toString());

        // call the canLoseEditRights method setting the timeout parameter to true
        DocumentConnection connection = m_connection.get();
        if ((null != connection) && (!connection.isDisposed())) {
            connection.canLoseEditRights(m_session, m_fromId, 0, Timeout.TM_SWITCH_EDITRIGHTS);
        }
    }
}
