/*
 *
1 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.monitoring.osgi;

import java.util.List;

import javax.management.ObjectName;

import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;

import com.openexchange.exception.OXException;
import com.openexchange.management.ManagementService;
import com.openexchange.office.monitoring.OfficeMonitoring;
import com.openexchange.office.tools.logging.LogFactory;
import com.openexchange.office.tools.monitoring.Statistics;
import com.openexchange.office.tools.osgi.ActivatorBase;
import com.openexchange.osgi.SimpleRegistryListener;

//=============================================================================
public class MonitoringActivator extends ActivatorBase
{
	//-------------------------------------------------------------------------   
    private static final String SERVICE_NAME = "com.openexchange.office.monitoring";

	//-------------------------------------------------------------------------   
    private static final Logger LOG = LogFactory.getSlfLog(MonitoringActivator.class);

	//-------------------------------------------------------------------------   
    public MonitoringActivator ()
        throws Exception
    {
    	super (SERVICE_NAME);
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void listMandatoryServiceImports(final List< Class< ? >> lServices)
    	throws Exception
    {
    	lServices.add (ManagementService.class);
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void listOptionalServiceImports(final List< Class< ? >> lServices)
    	throws Exception
    {
    	// no optional services
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void activate()
    	throws Exception
    {
        final Statistics statistics = new Statistics();

        final String className = OfficeMonitoring.class.getName();
        final int pos = className.lastIndexOf('.');
        final String objectName = (-1 == pos) ? className : className.substring(pos + 1);

        m_officeMonitoringMBeanObjectName = new ObjectName(OfficeMonitoring.DOMAIN, "name",  objectName);
        m_officeMonitoringMBean = new OfficeMonitoring(statistics);

        ManagementService managementService = getService (ManagementService.class);
        managementService.registerMBean(m_officeMonitoringMBeanObjectName, m_officeMonitoringMBean);
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void deactivate()
    	throws Exception
    {
        ManagementService managementService = getService (ManagementService.class);
        managementService.unregisterMBean(m_officeMonitoringMBeanObjectName);
    }

    //-------------------------------------------------------------------------   
    protected OfficeMonitoring m_officeMonitoringMBean = null;

    //-------------------------------------------------------------------------   
    protected ObjectName m_officeMonitoringMBeanObjectName = null;
}
