package com.openexchange.office.htmldoc;

import java.util.List;

public class Cell
        extends NodeHolder
{

    private final static Paragraph EXPLICITPARA = new Paragraph();
    static
    {
    	EXPLICITPARA.setInTable(true);
    }

    public Cell()
            throws Exception
    {
        this(false);
    }

    public Cell(boolean insertExplicitParagraph)
        throws Exception
    {
        super();
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {

        document.append("<td");
        GenDocHelper.appendAttributes(getAttribute(), document);
        document.append(" role='gridcell' colspan='1' style='border: 1px solid rgb(0, 0, 0); padding: 2px 7px; background-color: transparent;'>");
        document.append("<div class='cell' contenteditable='false'>");
        document.append("<div class='resize bottom'></div>");
        document.append("<div class='resize right'></div>");
        document.append("<div class='cellcontent' contenteditable='true' data-focus-role='cell'>");

        List<INode> children = getChildren();
        int childCount = children.size();

        if (childCount > 0)
        {
            // There must be a implicit paragraph at the end, if the content of
            // the table cell doesn't have any paragraph. So we have to check
            // our children. See #35498
        	boolean hasParagraph = false;

        	for (int i = 0; i < childCount; i++) {
        	    final INode child = children.get(i);

                if (child instanceof Paragraph) {
                    hasParagraph = true;
                }
            }
            super.appendContent(document);

            // if needed, create implicit paragraph
            if (!hasParagraph)
            {
            	EXPLICITPARA.appendContent(document);
            }
        }
        else
        {
        	EXPLICITPARA.appendContent(document);
        }

        document.append("</div>");
        document.append("</div>");
        document.append("</td>");
        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return false;
    }
}