/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.drawingml;

import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.GraphicData;
import org.docx4j.dml.chart.CTChartSpace;
import org.docx4j.dml.chart.CTRelId;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.DrawingML.Chart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart.AddPartBehaviour;
import org.docx4j.relationships.Relationship;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.office.filter.ooxml.OperationDocument;

final public class DMLGraphic {

    /**
     * @param part where the graphic is placed in
     * @param graphic
     * @return map may contain following properties:
     *
     * "type"        the drawingType as it is used within the insertDrawing operation
     * "chartObject" org.docx4j.dml.chart.CTChartSpace (Chart)
     *
     * @throws JSONException
     */
    public static void getGraphicProperties(OperationDocument operationDocument, Part part, Graphic graphic, HashMap<String, Object> map) {

        if(graphic!=null) {
            final GraphicData graphicData = graphic.getGraphicData();
            if(graphicData!=null) {
                if (graphicData.getUri().equals("http://schemas.openxmlformats.org/drawingml/2006/chart")/* || graphicData.getUri().equals("http://schemas.microsoft.com/office/drawing/2014/chartex") */) {
                    final List<Object> data = graphicData.getAny();
                    if(!data.isEmpty()) {
                        final Object o = data.get(0);
                        if(o instanceof JAXBElement<?>&&((JAXBElement<?>) o).getDeclaredType().getName().equals("org.docx4j.dml.chart.CTRelId")) {
                            final Object value = ((JAXBElement<?>)o ).getValue();
                            if(value instanceof CTRelId) {
                                final String relId = ((CTRelId) value).getId();
                                if(relId!=null&&!relId.isEmpty()) {
                                    final RelationshipsPart relationshipsPart = part.getRelationshipsPart();
                                    if(relationshipsPart!=null) {
                                        final Part relPart = relationshipsPart.getPart(relId);
                                        if (relPart != null && relPart.getRelationshipType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/chart")) {
                                            final ChartWrapper chart = new ChartWrapper((Chart) relPart, operationDocument);
                                            map.put("chartPart", chart);
                                            map.put("type", "chart");
                                            chart.getChartType(map);
                                        }
                                    }
                                }
                            }
                        } /*
                           * else if(o instanceof JAXBElement<?>&&((JAXBElement<?>) o).getDeclaredType().getName().equals("org.docx4j.dml.chartex2014.CTRelId")) {
                           * final Object value = ((JAXBElement<?>)o ).getValue();
                           * if(value instanceof org.docx4j.dml.chartex2014.CTRelId) {
                           * final String relId = ((org.docx4j.dml.chartex2014.CTRelId) value).getId();
                           * if(relId!=null&&!relId.isEmpty()) {
                           * final RelationshipsPart relationshipsPart = part.getRelationshipsPart();
                           * if(relationshipsPart!=null) {
                           * final Part relPart = relationshipsPart.getPart(relId);
                           * if (relPart != null && relPart.getRelationshipType().equals("http://schemas.microsoft.com/office/2014/relationships/chartEx")) {
                           * map.put("type", "undefined");
                           * final ChartWrapper chart = new ChartWrapper((ChartExPart) relPart, operationDocument);
                           * map.put("chartPart", chart);
                           * map.put("type", "chart");
                           * chart.getChartType(map);
                           * }
                           * }
                           * }
                           * }
                           * }
                           */
                    }
                }
            }
        }
    }

    // baseUrl depends to the current application... "/xl/charts/" for xlsx
    public static Graphic createDrawingMLChart(OperationDocument operationDocument, Part part, String baseUrl, JSONObject chartAttrs)
        throws Exception {

        final Graphic graphic = Context.getDmlObjectFactory().createGraphic();
        final GraphicData graphicData = Context.getDmlObjectFactory().createGraphicData();
        graphicData.setUri("http://schemas.openxmlformats.org/drawingml/2006/chart");
        final org.docx4j.dml.chart.ObjectFactory chartObjectFactory = new org.docx4j.dml.chart.ObjectFactory();
        final CTRelId CTRelId = chartObjectFactory.createCTRelId();
        final JAXBElement<?> chart = chartObjectFactory.createChart(CTRelId);
        graphicData.getAny().add(chart);
        final Chart chartPart = new Chart(new PartName(baseUrl + "chart1.xml"));
        final CTChartSpace chartSpace = DMLChartSpace.createChartSpace(chartAttrs);
        chartPart.setJaxbElement(chartSpace);
        final Relationship relationship = part.addTargetPart(chartPart, AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        CTRelId.setId(relationship.getId());
        graphic.setGraphicData(graphicData);
        return graphic;
    }
}
