/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.xlsx.components;

import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart.AddPartBehaviour;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.ContentAccessor;
import org.xlsx4j.jaxb.Context;
import org.xlsx4j.sml.CTDrawing;
import org.xlsx4j.sml.ISheetAccess;
import org.xlsx4j.sml.Sheet;
import com.openexchange.office.filter.api.FilterException;
import com.openexchange.office.filter.api.FilterException.ErrorCode;
import com.openexchange.office.filter.ooxml.xlsx.XlsxOperationDocument;

public class SheetWrapper implements ContentAccessor {

    final private IndexedNode<Object> sheetNode;
    final private JaxbXmlPart<ISheetAccess> worksheetPart;
    final XlsxOperationDocument operationDocument;
    private IndexedNodeList<Object> content;

    public SheetWrapper(IndexedNode<Object> sheetNode, XlsxOperationDocument operationDocument) {
        this.sheetNode = sheetNode;
        this.operationDocument = operationDocument;

        final Sheet sheet = (Sheet)sheetNode.getData();
        final RelationshipsPart relationshipPart = operationDocument.getPackage().getWorkbookPart().getRelationshipsPart();
        worksheetPart = (JaxbXmlPart<ISheetAccess>) relationshipPart.getPart(sheet.getId());
        final ISheetAccess worksheet = (ISheetAccess) worksheetPart.getJaxbElement();
        final CTDrawing drawing = worksheet.getDrawing();
        if(drawing!=null) {
            final String drawingId = drawing.getId();
            if(drawingId!=null&&!drawingId.isEmpty()) {
                final RelationshipsPart sourceRelationships = worksheetPart.getRelationshipsPart();
                if(sourceRelationships!=null) {
                    final Part drawingsPart = sourceRelationships.getPart(drawingId);
                    if(drawingsPart instanceof org.docx4j.openpackaging.parts.DrawingML.Drawing) {
                        final org.docx4j.dml.spreadsheetdrawing.CTDrawing drawings = ((org.docx4j.openpackaging.parts.DrawingML.Drawing)drawingsPart).getJaxbElement();
                        content = drawings.getContent();
                        operationDocument.setContextPart(drawingsPart);
                    }
                }
            }
        }
    }

    @Override
    public IndexedNodeList<Object> getContent() {
        return content;
    }

    public IndexedNodeList<Object> getContent(boolean forceCreate) {
        if(content==null&&forceCreate) {
            final ISheetAccess worksheet = (ISheetAccess) worksheetPart.getJaxbElement();
            CTDrawing drawing = worksheet.getDrawing();
            if(drawing==null) {
                drawing = Context.getsmlObjectFactory().createCTDrawing();
                worksheet.setDrawing(drawing);
            }
            final org.docx4j.openpackaging.parts.DrawingML.Drawing drawingsPart;
            try {
                drawingsPart = new org.docx4j.openpackaging.parts.DrawingML.Drawing();
                final org.docx4j.dml.spreadsheetdrawing.CTDrawing drawings = org.docx4j.jaxb.Context.getDmlSpreadsheetDrawingObjectFactory().createCTDrawing();
                drawingsPart.setJaxbElement(drawings);
                final Relationship relationship = worksheetPart.addTargetPart(drawingsPart, AddPartBehaviour.RENAME_IF_NAME_EXISTS);
                content = drawings.getContent();
                operationDocument.setContextPart(drawingsPart);
                drawing.setId(relationship.getId());
            } catch (InvalidFormatException e) {
                throw new FilterException("XLSX Export: could not create drawing part", ErrorCode.CRITICAL_ERROR, e);
            }
        }
        return content;
    }
}
