/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 *
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odp.dom.components;

import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;
import com.openexchange.office.filter.odf.DLList;
import com.openexchange.office.filter.odf.DLNode;
import com.openexchange.office.filter.odf.OdfOperationDoc;
import com.openexchange.office.filter.odf.OpAttrs;
import com.openexchange.office.filter.odf.components.Component;
import com.openexchange.office.filter.odf.components.ComponentContext;
import com.openexchange.office.filter.odf.table.Cell;
import com.openexchange.office.filter.odf.table.Row;

public class RowComponent extends Component {

	final Row row;

	public RowComponent(FrameComponent parentContext, DLNode<Object> rowNode, int componentNumber) {
		super(parentContext, rowNode, componentNumber);
		this.row = (Row)getObject();
	}

    @Override
    public String simpleName() {
        return "Row";
    }

    public Row getRow() {
		return row;
	}

	@Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {

        final int nextComponentNumber = previousChildComponent != null ? previousChildComponent.getNextComponentNumber() : 0;
        final int nextGridPosition =  previousChildComponent instanceof CellComponent ? ((CellComponent)previousChildComponent).getNextGridPosition() : 0;
        DLNode<Object> nextNode = previousChildContext != null ? previousChildContext.getNode().next : ((Row)getObject()).getContent().getFirstNode();
		while(nextNode!=null) {
			if(nextNode.getObject() instanceof Cell) {
				return new CellComponent(this, nextNode, nextComponentNumber, nextGridPosition);
			}
			nextNode = nextNode.next;
		}
		return null;
	}

	@Override
	public void applyAttrsFromJSON(OdfOperationDoc operationDocument, JSONObject attrs)
		throws JSONException {

		row.setStyleName(operationDocument.getDocument().getStyleManager().applyAttributes("table-row", row.getStyleName(), isContentAutoStyle(), attrs));
	}

	@Override
	public void createAttrs(OdfOperationDoc operationDocument, OpAttrs attrs) {

		if(row.getStyleName()!=null&&!row.getStyleName().isEmpty()) {
			final OpAttrs hardRowAttrs = new OpAttrs();
			operationDocument.getDocument().getStyleManager().
				createAutoStyleAttributes(hardRowAttrs, row.getStyleName(), "table-row", isContentAutoStyle());
			final Map<String, Object> rowAttrs = hardRowAttrs.getMap("row", false);
			if(rowAttrs!=null) {
				attrs.put("row", rowAttrs);
			}
		}
	}

	public void insertCells(OdfOperationDoc operationDocument, int cellPosition, int count, JSONObject attrs)
	    throws JSONException, SAXException {

    	Component c = getChildComponent(cellPosition);
    	final DLList<Object> rowContent = row.getContent();
        for (int i=0; i<count; i++) {
            final Cell cell = new Cell();
            rowContent.addNode(c!=null?c.getNode():null, new DLNode<Object>(cell), true);
        }
        if(attrs!=null) {
            c = getChildComponent(cellPosition);
            for(int i=0; i<count; i++) {
            	c.applyAttrsFromJSON(operationDocument, attrs);
            	c = c.getNextComponent();
            }
        }
	}
}
