/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.draw;

import java.io.IOException;
import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import com.google.common.collect.ImmutableMap;
import com.openexchange.office.filter.odf.ElementToBase64Handler;

public class EnhancedGeometry implements IElementWriter {

    private boolean modified;
    private String customShapeType;
    private String modifiers;
    private String b64ShapeData;
    private Boolean flipH;
    private Boolean flipV;

    public void EnhancedGeomentry() {
        modified = false;
        flipH = null;
        flipV = null;
    }

    public String getPredefinedShape() {
        if(customShapeType!=null) {
            if(customShapeType.startsWith("ooxml-")&&customShapeType.length() > 6) {
                return customShapeType.substring(6);
            }
            return OOShapeTypes.get(customShapeType);
        }
        return null;
    }

    public void setCustomShapeType(String customShapeType, boolean createHostData) {
        final String hostData = hostDataMap.get(customShapeType);
        if(createHostData) {
            b64ShapeData = hostData;
        }
        this.customShapeType = hostData!=null ? "ooxml-" + customShapeType : customShapeType;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public String getModifiers() {
        return modifiers;
    }

    public void setModifiers(String modifiers) {
        this.modifiers = modifiers;
        modified = true;
    }

    public void setFlipH(Boolean flipH) {
        this.flipH = flipH;
        modified = true;
    }

    public Boolean getFlipH() {
        return flipH;
    }

    public void setFlipV(Boolean flipV) {
        this.flipV = flipV;
        modified = true;
    }

    public Boolean getFlipV() {
        return flipV;
    }

    public String getShapeData() {
        return b64ShapeData;
    }

    public void setShapeData(String b64ShapeData) {
        this.b64ShapeData = b64ShapeData;
    }

    @Override
    public void writeObject(SerializationHandler output) {
        try {
            output.flushPending();
        } catch (SAXException e) {
            //
        }
        if(modified) {
            final Document doc = ElementToBase64Handler.getDOMFromBase64Data(b64ShapeData);
            if(doc!=null) {
                final Element enhancedGeometry = doc.getDocumentElement();
                if(flipH==null) {
                    enhancedGeometry.removeAttribute("draw:mirror-horizontal");
                }
                else {
                    enhancedGeometry.setAttribute("draw:mirror-horizontal", flipH.toString());
                }
                if(flipV==null) {
                    enhancedGeometry.removeAttribute("draw:mirror-vertical");
                }
                else {
                    enhancedGeometry.setAttribute("draw:mirror-vertical", flipV.toString());
                }
                try {
                    output.asDOMSerializer().serialize(doc);
                } catch (IOException e) {
                    //
                }
            }
        }
        else {
            // shape is not modified, we can write shape data directly
            ElementToBase64Handler.writeString(output, b64ShapeData);
        }
    }

    static final public ImmutableMap<String, String> OOShapeTypes = ImmutableMap.<String, String> builder()
        .put("rectangle",                   "rect")
        .put("round-rectangle",             "roundRect")
        .put("ellipse",                     "ellipse")
        .put("diamond",                     "diamond")
        .put("isosceles-triangle",          "rtTriangle")
        .put("right-triangle",              "triangle")
        .put("parallelogram",               "parallelogram")
        .put("trapezoid",                   "trapezoid")
        .put("hexagon",                     "hexagon")
        .put("octagon",                     "octagon")
        .put("cross",                       "plus")
        .put("star5",                       "star5")
        .put("right-arrow",                 "rightArrow")
        .put("pentagon-right",              "homePlate")
        .put("cube",                        "cube")
        .put("mso-spt17",                   "cloud")
        .put("mso-spt18",                   "star16")
        .put("mso-spt19",                   "arc")
        .put("mso-spt20",                   "line")
        .put("mso-spt21",                   "plaque")
        .put("can",                         "can")
        .put("ring",                        "donut")
        .put("mso-spt32",                   "straightConnector1")
        .put("mso-spt33",                   "bentConnector2")
        .put("mso-spt34",                   "bentConnector3")
        .put("mso-spt35",                   "bentConnector4")
        .put("mso-spt36",                   "bentConnector5")
        .put("mso-spt37",                   "curvedConnector2")
        .put("mso-spt38",                   "curvedConnector3")
        .put("mso-spt39",                   "CurvedConnector4")
        .put("mso-spt40",                   "curvedConnector5")
        .put("mso-spt41",                   "callout1")
        .put("mso-spt42",                   "callout2")
        .put("mso-spt43",                   "callout3")
        .put("mso-spt44",                   "accentCallout1")
        .put("mso-spt45",                   "accentCallput2")
        .put("mso-spt46",                   "accemtCallout3")
        .put("line-callout-1",              "borderCallout1")
        .put("line-callout-2",              "borderCallout2")
        .put("mso-spt50",                   "accentBoderCallout1")
        .put("mso-spt51",                   "accentBorderCallout2")
        .put("mso-spt52",                   "accenbBorderCalloue3")
        .put("mso-spt53",                   "ribbon")
        .put("mso-spt54",                   "ribbon2")
        .put("chevron",                     "chevron")
        .put("pentagon",                    "pentagon")
        .put("forbidden",                   "noSmoking")
        .put("star8",                       "star8")
        .put("mso-spt59",                   "star16")
        .put("mso-spt60",                   "star32")
        .put("rectangular-callout",         "wedgeRectCallout")
        .put("round-rectangular-callout",   "wedgeRoundRectCallout")
        .put("round-callout",               "wedgeEllipseCallout")
        .put("mso-spt64",                   "wave")
        .put("paper",                       "foldedCorner")
        .put("left-arrow",                  "leftArrow")
        .put("down-arrow",                  "downArrow")
        .put("up-arrow",                    "upArrow")
        .put("left-right-arrow",            "leftRightArrow")
        .put("up-down-arrow",               "upDownArrow")
        .put("mso-spt71",                   "irregularSeal1")
        .put("bang",                        "irregularSeal2")
        .put("lightning",                   "lightningBold")
        .put("heart",                       "heart")
        .put("mso-spt75",                   "rect")       // mso_sptPictureFrame },
        .put("quad-arrow",                  "quadArrow")
        .put("left-arrow-callout",          "leftArrowCallout")
        .put("right-arrow-callout",         "rightArrowCallout")
        .put("up-arrow-callout",            "upArrowCallout")
        .put("down-arrow-callout",          "downArrowCalllout")
        .put("left-right-arrow-callout",    "leftRightArrowCallout")
        .put("up-down-arrow-callout",       "upDdownArrowCallout")
        .put("quad-arrow-callout",          "quadArrowCallout")
        .put("quad-bevel",                  "bevel")
        .put("left-bracket",                "leftBracket")
        .put("right-bracket",               "rightBracket")
        .put("left-brace",                  "leftBrace")
        .put("right-brace",                 "rightBrace")
        .put("mso-spt89",                   "leftUpArrow")
        .put("mso-spt90",                   "bentUpArrow")
        .put("mso-spt91",                   "bentArrow")
        .put("star24",                      "star24")
        .put("striped-right-arrow",         "stripedRightArrow")
        .put("notched-right-arrow",         "notchedRightArrow")
        .put("block-arc",                   "blockArc")
        .put("smiley",                      "smileyFace")
        .put("vertical-scroll",             "verticalScroll")
        .put("horizontal-scroll",           "horizontalScroll")
        .put("circular-arrow",              "circularArrow")
        .put("mso-spt101",                  "uturnArrow")
        .put("mso-spt102",                  "curvedRightArrow")
        .put("mso-spt103",                  "curvedLeftArrow")
        .put("mso-spt104",                  "curvedUpArrow")
        .put("mso-spt105",                  "curvedDownArrow")
        .put("cloud-callout",               "cloudCallout")
        .put("mso-spt107",                  "ellipseRibbon")
        .put("mso-spt108",                  "ellipseRibbon2")
        .put("flowchart-process",           "flowChartProcess")
        .put("flowchart-decision",          "flowChartDecision")
        .put("flowchart-data",              "flowChartInputOutput")
        .put("flowchart-predefined-process","flowChartPredefinedProcess")
        .put("flowchart-internal-storage",  "flowChartInternalStorage")
        .put("flowchart-document",          "flowChartDocument")
        .put("flowchart-multidocument",     "flowChartMultidocument")
        .put("flowchart-terminator",        "flowChartTerminator")
        .put("flowchart-preparation",       "flowChartPreperation")
        .put("flowchart-manual-input",      "flowChartManualInput")
        .put("flowchart-manual-operation",  "flowChartManualOperation")
        .put("flowchart-connector",         "flowChartConnector")
        .put("flowchart-card",              "flowChartPunchedCard")
        .put("flowchart-punched-tape",      "flowChartPunchedTape")
        .put("flowchart-summing-junction",  "flowChartSummonJunction")
        .put("flowchart-or",                "flowChartOr")
        .put("flowchart-collate",           "flowChartCollate")
        .put("flowchart-sort",              "flowChartSort")
        .put("flowchart-extract",           "flowChartExtract")
        .put("flowchart-merge",             "flowChartMerge")
        .put("mso-spt129",                  "flowChartOfflineStorage")
        .put("flowchart-stored-data",       "flowChartOnlineStorage")
        .put("flowchart-sequential-access", "flowChartMagneticTape")
        .put("flowchart-magnetic-disk",     "flowChartMagneticDisk")
        .put("flowchart-direct-access-storage","flowChartMagneticDrum")
        .put("flowchart-display",           "flowChartDisplay")
        .put("flowchart-delay",             "flowChartDelay")
        .put("flowchart-alternate-process", "flowChartAlternateProcess")
        .put("flowchart-off-page-connector","flowChartOffpageConnector")
        .put("mso-spt182",                  "leftRightUpArrow")
        .put("sun",                         "sun")
        .put("moon",                        "moon")
        .put("bracket-pair",                "bracketPair")
        .put("brace-pair",                  "bracePair")
        .put("star4",                       "star4")
        .put("mso-spt188",                  "doubleWave")
        .put("mso-spt189",                  "actionButtonBlank")
        .put("mso-spt190",                  "actionButtonHome")
        .put("mso-spt191",                  "actionButtonHelp")
        .put("mso-spt192",                  "actionButtonInformation")
        .put("mso-spt193",                  "actionButtonForwardNext")
        .put("mso-spt194",                  "actionButtonPreviousNext")
        .put("mso-spt195",                  "actionButtonEnd")
        .put("mso-spt196",                  "actionButtonBeginning")
        .put("mso-spt197",                  "actionButtonReturn")
        .put("mso-spt198",                  "actionButtonDocument")
        .put("mso-spt199",                  "actionButtonSound")
        .put("mso-spt200",                  "actionButtonMovie")
        .put("teardrop",                    "teardrop")
        .put("mso-spt202",                  "rect")         // mso_sptTextBox },
        .put("star6",                       "star6")        // Gallery: star6
        .put("star12",                      "star12")       // Gallery: star12
        .build();

//      .put("non-primitive", null)
//      .put("mso-spt201", mso_sptHostControl },
//      .put("mso-spt178", mso_sptCallout90 },
//      .put("mso-spt179", mso_sptAccentCallout90 },
//      .put("mso-spt180", mso_sptBorderCallout90 },
//      .put("line-callout-3", mso_sptAccentBorderCallout90 },
//      .put("fontwork-stop", mso_sptTextStop },
//      .put("fontwork-triangle-up", mso_sptTextTriangle },
//      .put("fontwork-triangle-down", mso_sptTextTriangleInverted },
//      .put("fontwork-chevron-up", mso_sptTextChevron },
//      .put("fontwork-chevron-down", mso_sptTextChevronInverted },
//      .put("mso-spt142", mso_sptTextRingInside },
//      .put("mso-spt143", mso_sptTextRingOutside },
//      .put("fontwork-arch-up-curve", mso_sptTextArchUpCurve },
//      .put("fontwork-arch-down-curve", mso_sptTextArchDownCurve },
//      .put("fontwork-circle-curve", mso_sptTextCircleCurve },
//      .put("fontwork-open-circle-curve", mso_sptTextButtonCurve },
//      .put("fontwork-arch-up-pour", mso_sptTextArchUpPour },
//      .put("fontwork-arch-down-pour", mso_sptTextArchDownPour },
//      .put("fontwork-circle-pour", mso_sptTextCirclePour },
//      .put("fontwork-open-circle-pour", mso_sptTextButtonPour },
//      .put("fontwork-curve-up", mso_sptTextCurveUp },
//      .put("fontwork-curve-down", mso_sptTextCurveDown },
//      .put("fontwork-fade-up-and-right", mso_sptTextCascadeUp },
//      .put("fontwork-fade-up-and-left", mso_sptTextCascadeDown },
//      .put("fontwork-wave", mso_sptTextWave1 },
//      .put("mso-spt157", mso_sptTextWave2 },
//      .put("mso-spt158", mso_sptTextWave3 },
//      .put("mso-spt159", mso_sptTextWave4 },
//      .put("fontwork-inflate", mso_sptTextInflate },
//      .put("mso-spt161", mso_sptTextDeflate },
//      .put("mso-spt162", mso_sptTextInflateBottom },
//      .put("mso-spt163", mso_sptTextDeflateBottom },
//      .put("mso-spt164", mso_sptTextInflateTop },
//      .put("mso-spt165", mso_sptTextDeflateTop },
//      .put("mso-spt166", mso_sptTextDeflateInflate },
//      .put("mso-spt167", mso_sptTextDeflateInflateDeflate },
//      .put("fontwork-fade-right", mso_sptTextFadeRight },
//      .put("fontwork-fade-left", mso_sptTextFadeLeft },
//      .put("fontwork-fade-up", mso_sptTextFadeUp },
//      .put("fontwork-fade-down", mso_sptTextFadeDown },
//      .put("fontwork-slant-up", mso_sptTextSlantUp },
//      .put("fontwork-slant-down", mso_sptTextSlantDown },
//      .put("mso-spt174", mso_sptTextCanUp },
//      .put("mso-spt175", mso_sptTextCanDown },
//      .put("fontwork-plain-text", mso_sptTextPlainText },
//      .put("mso-spt14", mso_sptThickArrow },
//      .put("mso-spt24", mso_sptTextSimple },
//      .put("mso-spt25", mso_sptTextOctagon },
//      .put("mso-spt26", mso_sptTextHexagon },
//      .put("mso-spt27", mso_sptTextCurve },
//      .put("mso-spt28", mso_sptTextWave },
//      .put("mso-spt29", mso_sptTextRing },
//      .put("mso-spt30", mso_sptTextOnCurve },
//      .put("mso-spt31", mso_sptTextOnRing },
//      .put("mso-spt49", borderCallpi },
//      .put("mso-spt100", mso_sptNotchedCircularArrow },

/*
    // gallery: quadrat
    // gallery: round-quadrat
    // gallery: circle
    // gallery: circle-pie
    // gallery: frame
    // gallery: flower
    // gallery: cloud
    // gallery: puzzle
    // gallery: octagon-bevel
    // gallery: diamond-bevel
    // gallery: up-right-arrow
    // gallery: up-right-down-arrow
    // gallery: corner-right-arrow
    // gallery: split-arrow
    // gallery: up-right-arrow-callout
    // gallery: split-round-arrow
    // gallery: s-sharped-arrow
    // Gallery: concave-star6
    // Gallery: signet
    // Gallery: doorplate
    // gallery: fontwork-arch-left-curve
    // gallery: fontwork-arch-right-curve
    // gallery: fontwork-arch-left-pour
    // gallery: fontwork-arch-right-pour
  */  
    final static private String hd_straightConnector1 = "H4sIAAAAAAAAAG2OQQrCMBBFrxKyD8YKLkrThWvrHUI7NoEmEyZDaj29KEEquPmL93jwu4ns2kJ0No4wqRkwANMmPjh4IiTlkPwTI9vFyLtdMsgfXYDYjzuZy9wWD+sFH0ZqoUVzPOu6NeUtgZEho8qJT02l3xvJsjNyEO/4us/FTfbd4f/n/gW6CTL0zAAAAA==";
    final static private String hd_bentConnector3 = "H4sIAAAAAAAAAJWS7WrDIBSGb0VkvwaSz62jxAw22K9t9+CSk0SInsyYj+7qZ2tT2rIMqgjiec/zvopZacS0Bd0IXUDJakAF1uzI4VhJY9CwBo38QW1Fy2kl2h7oRXkEY2VxXbQwWyYMiJ7TkITkuYrdSijpx3o7SphecPYVN5eeXQecIs6qZV+g7StqDYVFkyyOWMpKgnHMh9CN4/Epfidsw+nHAfru7LzxfiVLAPJGPmme+b7vQViJ2lO0UM69WqAVGjW0gtMW60mWtrm/C0kQhQffPAsuCP8Boz+ADci6sUF8EyheS3YTJVmNs4Zxj1u2QM72rMNe7hWc+udd7ngsG6FrYDNTYpZqUJzGUbpJn5LHdLMilNoL2ZlyieO1p3DXfzX/BViEYrDEAgAA";
    final static private String hd_curvedConnector3 = "H4sIAAAAAAAAAJ2T7UrDMBSGbyUEf+gk9HOrjHWCA//pPYT2tA00OTNNu86rN/0ablqhJhxSct4+5z0h2aWan7agCq4SSFkOKMHoM+m3pdAaNStQi09UhpcxzXhZAb1KN6CNSG6TBlrDuAZexdQlLnnO1jY2lFRNvm0EnF6wHTJ2Tv+cjxBTxFaWLKl1A+kBlYLEoA6mmpiKTIC21LVrx7h9aeDITRHTtx57sAW9vnQX0biG4xrY8DtLkzXySt7pfjfwPmpuBKqBrri0vrKpWIZa1iWPaYn5SaSmWN25xPHc3s9+51wR/gJ6t8B797Ez9+D4izj+D87k7F+44Jc+CxB5YVaBEy5ChbOohZ7Wc2e/iLKZtbMIE813NXs89n6mJZBv3+yIlegUMR1vJr1Ka65yYC2TvBWyljH1vTAKn4JNGM0IhRqE7JtysjNoL+ZuH/z+C2qlF3sJBAAA";
    final static private String hd_ellipse = "H4sIAAAAAAAAAK2VXW+DIBSG/wrhynVxivWjbWqb7GZX2w/YHWlRSdTjkH7t1w80bdrhljGrAcmB8/geeYnLraCHBasLWm/Y1s0ZVEyKE+rCFRcChFuA4J9QS1qmOKNly/DN9J4JyTffJyU7SpcKRtsUr7MIrbOZarFqc4zafb7Yc3Z4hmOKfdTd57xTw1IMcKxKl5Ulby7Ei8iGyiLFryppnSXoHb31CwDgpzUvqtejQDXSddPrSKi76DqidZLkOqLVk3n3ttWy1/Oxo5JD3auraaV0Z+cyMhDVrqQpLiE/8K0svEDleTeJv3HId46WMtlA6zR84gSJr68Hj/izfmQFDwZEFoznhbRUOTVVBmjS8voeKsM7fcrIFBmiR99V+4msQPEgSGNc3wqU3Ov7z0xFSV/a1K60+SBIYyxLI0MHoK/NjmMcgPPu22EMqzsXM3qxfjxZ1mdY3onCMTzD5Q6JgzFAw+4jBRqud/5LMmw/Upnh/pE84xD8hecN/0BXX7yVBJdZBwAA";
    final static private String hd_triangle = "H4sIAAAAAAAAAJWTX2+CQAzAv8rlsoe5eRFQNDEiyZ63fYC9XaQHTe6PO07FffodoGwSMQFS0l7bX5vS22SWn9agC653kLEcjAJnz6Q5VmitsawwFn+MdlwmVHBZAr1xH8E63PWdDirHuAVeJjQVIUlF7GXhZUlJeczXR4TTm6kSGpDmvead95BQYyolmbPIdS67eiZDgWA9MQ78cznumt9zVyT0w8N8EfLuv1Gjrxr7i3zS7abN+D5wh0a3+ZorX1FcccJYdZA8oSieA/YUkGkw9WpYV2ztWlpzMvHI2Q3zUYmwX0Ka/ISZK15SEZBZ1DBHEaPHxHA8cT5EnEWjOIs+p16C11TMCRvXUHynoQIwL9zIjpaDoFGY1dCAhih+OzMJ5J/O9qbEOqKeStSt/sVp/c4Dq5jiFaqDSujlL94PQt0G/Q21jeia6V/t7S+hx+3Y8wMAAA==";
    final static private String hd_rtTriangle = "H4sIAAAAAAAAAJXTzWrDMAwA4FcxPg5CmqxroNQN7LzttNNuopFjg386xU3SPf2ylAw64oExOtiyPguBDw3BsEenwJ2wyVr0FgNd2XxsNZGnTHnSX94FMIJLMB3yu3SPFPTpbzLgGDIghE7wWlaslpspiilKzrq+3fcah2c/Cr5h81rqrmcU3PvRmozCO2lwrVnQ3z7PEJTgr+zH3LKXWajlbt59sDd+PNzuf14gaO9u1Q7sRMvlJenJXgwIbnyrULcqPFR5UU61+V3xf1axYg26CSqdKuNtFUUq9hjF8jRoG4WSmKfYnBLb2cWcJKWKdrM65nz9jxy/AdGOaoA8AwAA";
    final static private String hd_parallelogram = "H4sIAAAAAAAAAJ2WbW+qMBTHv0pD7gvnJLSIOpcxkvt62wfYu2a00IRSV1HZPv1tKeAdVZMziaWPv54e/ufAU67p6ZHVJa0/WB4WTEnW6C/UdUuhtdJhqbT4VnVDqzTgtNqz4MfwkelGfEwHG9Y2IdWM7tMg42SJTJHYYmWLdYD2x+LxKNjpr2rTAKPuGtZ+7VgaKNXKKtxRTauKVarQVA4bq1xwwbRBxyuMh2XjKXa0KdPg1RAzHsfoxdwS11h2t7Xrf0dvwfOTW/p5oI1QtQPVVJr9+cDlSstDRdNAinpmDDmJvCkXplIyUZTNnYFEPyi3oGQKJdj+5gM3yjhGIGI8JQo+w+EfjBZ4YarG26hr2b9t3MEMXk7x1sC5cSCK4s50EC25TiNw2mpKG7x4j8OML2F+XN+EJTDYxj/nGs1JFIMoDzdN2sBM2l6DAY0iXlxkfNs/Q6svGMyLh9VvSV4czMi9oRjBRwR4wguaJzE6xyiB4S6Ivse5DALl3ZY9AeqeXBK+M8zxgNInnvZ/K7RL8neGGY2QjRUJ1DYvCLpkaWgPfboct+g7XXlO9rDkGXuxMvHtFpjrvXA5iwjm3NgLl5EE43ixMjztaxjzks4rhv6rhzu1F3aGjYxk/AzoBzWtCxa2oaStkAfZRc+VGaJ2M85vETdjtGT6nfP8D5rj/acACQAA";
    final static private String hd_trapezoid = "H4sIAAAAAAAAAJ2V3W6DIBTHX4WQXbRdiWh1/Uitya63PcDuSAUlEXGUtrZPP9HqVp1NWIzIx+HHn8M5uI0VOW9onpJ8T2OUUCmoVhdQdwuulFQolYpfZa5JFkJGsgOFd8MnqjTf9wc1LTUiipJDCCO2AhFzsSlcU/gQHE7J5sTp+VWWIcSgftqpl4KGUMpSZEgrUtCr5HG7pow541RVVC/AuJ3SbaAgOg3hO6jX8sFb9fHrRtB0BU3/J/iAu20z9etINJd5A8qJqNZmLZdJJY4ZCaHg+SSTyZnHOp1XlZTyJNXTCuLcUR5B3T7UbADPWqwTMQysgF4fyNkEoycM5nheVaudgrplXtOY2uld9PFG4CxiHnA8oxxb0fxxmmtPC/q01ovPGJkjt4K9PIQt7GDLMZizsOKshv5a3vxlztKKtf5DUxPBlqLcQWJEbP1fVe4gIe78vrKkDbKhc7xnBxrE/Y+3LEmDmO9IdpzRaB/DVLdhnFHwq44KeeDGwhyZ3921t0FF8oSiEglScnEUxsYdseB5Y/GTr41Fp6T/L9l9A3ua0GJkBgAA";
    final static private String hd_diamond = "H4sIAAAAAAAAAJWTYWvCMBCG/0rIx0GptlVBjIV9nv6AfTvspQk0OU1jW/frV+scOJpBCBdyOd7n3hxkVznot2gV2BNWSY1k0Lsbm66Ndo5cosjpL7IeGsElNC3yl3KHzuvT36LHwSfgEFrBS7lmpdyMsRhjyVnb1dtOY/9Og+ALNq2n7nZGwYkG0ySVBkO2+qn8mjyDV4If2B2Ws49xz6bzasrvWSkL9smOfL97KC9X8Jrsg2PBjB3ks6EkZ64NCN5Q3evKq7c8LUZl+iL9j7ScISnUtfLRqCxkKs2iOHnQUiSoCIKiMKvQu6Io6+B04qa8CU9nDpTO/5H9N1HcNUg8AwAA";
    final static private String hd_pentagon = "H4sIAAAAAAAAAK2V3W6DIBiGb4WQHbQuRvC/TW2THW+7gJ2Rikqi4pD+7eoHbe3SSZrQVpMPA+HhQX11kQuym9O2Iu2a5m5JeUOlOIBjd8OE4MKtuGA/vJWkzmBB6p7Cq+EtFZKt/w9KupcuEZT0GVwV2AeqJLoEusQQ9NtyvmV098b3GUTgeA5zDx3NIOf7pnY7qhYueTusyXNWMCoUFaMIhzHAqo2S8/BlIx2RVQY/9FpYlwi860avoprw1HWxAYNhDL7AJ1wuTrDvDZGMtyd0SxolVQyOBRfNpiYZrHm5Y7msPF/N864m3uLg/5xVgYDzgoCHkT6sYL5BqqKsrKSlVTC28pUVvssqfJZVNLYK77aKxzAMnDXvJx1zJhilmjj1zhdoagVPbsPTIH6Eno7pAXB61j5DfXYb/qA6flpuDMFRsX5F7qqIgR1qFJs/VGKJMgRHozTItXs/8Sg2Ayq2RhmCE532l1ruz5CaM2lmSTJFJAKOvlOe/SMcReLyjTFwPPPPbvkL72B+zgUHAAA=";
    final static private String hd_hexagon = "H4sIAAAAAAAAAK2W326bMBTGX+UI9SJhWNj8SWhVGmnX2x5gd1YxYAlwZkhC9/SzTWALTiu5miIcg83P3+GcD/NcSHp5Yl1Nu1dWoIqJlg3yDczllkspJKqF5L9FN9Am90ra9My7GT4zOfDX9eDAxgFRyWife4eSPMKhjLBuiG4iD/pz9XTm7PJVjLmHwfzme9+OLPeEGNsG1WyklejmJUXBS86kgkYpxhgISZP9fN8SxpEOde59B71gBt9Um6pDa9hd/6PYDE0XCL7OUJ2f8MN7eZ5wv0504KKb4B1tlahyXqsUsj01NPda3m0aUV14MdSB6tSMV/WwVZDwhvIRlKyhOjbsz9jwUGJwAkZrIC83GD1gCHCguipSMGf60CdbN73xGr/EHUZOoGQNOpQx+A8EQqKfAHaCpTYMg69y/Sna7k6MJhtfMNLV4gTb29IS8HtVOkfub+KdkbdVMrOp5wTP/lc2Hm2VGZhw927hEsslhqQ5yC0LxLKGLlcfEcfQiOUIXRdKESHOkqzqnxwVQZAEkaPxLQMsrNiZZdX/wjJhBo5lRSwHbOZnlsI2NEw34B0XkJ12KEkgRMQNZlW9wsRGnXuRWYU/e11ryyCMEre3r1X+iyM/CbRccPMyUrurG84yw6LP8CLX3ebefmDkvYdR+3TRMPinj46i53qGTmS6fApcByXtKoZG1NKRt6fWJPudGbybZvwtgWnGomT9rfPyBy82HzIECQAA";
    final static private String hd_heptagon = "H4sIAAAAAAAAAK2WXWvDIBSG/4rIrjpC1XxamhZ2ve0H7E4akwhJ7Kz92q+fSZaNNm6gLAE5aM5zXuW8knWh2HnFu5p1O14EFZct1+oKhulWKCVVUEslPmSnWZPDkjUHDm+WT1xpsbtf1PyiA6Y4O+RwW+IImIH2Q2oGQiA4nKrVSfDzk7zkEIHhnXKve55DKS9tE9R8r1klu6mmLEQpuDJUjEicEoBRTPCU+b2RPdN1Dl/6gmFfEIFncCODmHpfasaJbPzMREkf4T6Kx+gNvMLNeizwfmRayG4s17HWCC2n6qVU7bFhOWxkdRaFrpfE5C1vEv/i4HvOtkRg8YDAEqP+cYIRi6iai6rWjqrCuSpiVGEvVdF/qYrnqiJvVckchsGCphENfXCpFZdmOPPCZVZcFIZZ5oOjc1wIFgkJI+qDw7PuH3iEkJh48SwuMDyKEE29eDYjeLnTYgRzjTyiYFsmwA01s8EPKnVEWYwwoTJHlM0GBtWDAsdDt1lgQKXOKFv7D6jEGWVp/Xg8Kup2VMTS9HGvCSNXUcTS7yMKO6N+v/OHTWLrLpf2X4DNJ0kUFDgbCAAA";
    final static private String hd_octagon = "H4sIAAAAAAAAAJ2UUW+CMBDHv0rT7EGdjQVFxYgke972AfbWSAtNaOtKVdynX2llm2yYMEjL9Xr87n8NxzbT5LyhsiByTzOUUyWo0Rfg3IJrrTQqlOYfShpSJpCRsqLwZvtEteH77qahtUFEU1IlMGUR8GNpxwqC6pRvTpyen1SdQAzc3b53OdAEKlWLEqm9IbmSbTqVccaptsAwDtfx1f2l/UBMkcAXy0pZCJ7d3NhzN6/d2j8Xzpuy+OqLXcQCvIFXuNt66vuRGK6kzyGJsKJYq5EpLY4lSSBnI4weMJjiqTUjbC+3bIZbjccWOLsh3ksQdBMILkelys88M8XUGgXleWGGQcMuNGUBmKQMg1nQaMSDaPMurZX3iFFzmoNgiz9gvsT/0KLfhYZgEszCQZTl3QKjYZJW9wscSFv3SRtEiXs19WFsg2UlBT9sdFAVbyL8IbeNcd3UROYU1UiQmoujSKDrhZ4YLn3M92foI760dP9Nu09h2KsutAQAAA==";
    final static private String hd_decagon = "H4sIAAAAAAAAAK2Va2+DIBSG/woh+9C6GMVbL6k12edtP2DfiKKSqHRIb/v1Qy1NO2kT1mpCToDznFcPr64yjvdL0pS4SUlmF4TVRPAj6Kdryjnjdsk4/WGNwFUMc1y1BF4t7wgXNP27KMhB2JgT3MYwySOQ5CiQw6ILQgjaXbHcUbJ/Y4cYuqC/VeZxQ2LI2KGu7IykuGCNKsgymlPCJRK5IQqi0/xZ/gaLMoYfEiareOAdXFSedYEvh7kKFmoJzYb9Sp7aFKm0SIFC8AU+4Xo1lP3eYkFZM4hocC1l5+opcsbrbYVjWLGiJLQohePJROcq8x4I/QUluQusFxc4yO0uI5inUbWnmSgNRfljUR6wUtZONtSaeCjqlE2lwnmvcWoED+7CA997BB4+6Q1EY5EheHXtJPeBEWh2ExSYgeZaUIexzQ7J4gbINwWhkQmkdYDV0uYZnUQaZ1zQHzyESGeV/xlYYxb5kelbjFyzHiONN84sZMgaWWFg9STTTmvscGK5xqyRI5RFNRhH/99a/wLrXIi70AYAAA==";
    final static private String hd_dodecagon = "H4sIAAAAAAAAAJ2UW2vDIBTHv4r4OAgxl+ZSagN73vYB9iaJRiHRztgk3adfZpqNjlqYyPHAufzOnyN4aDSZ9lRyImvaBC1VPTX6Amy4F1orHXClxaeShnQYMtINFN6kR6qNqP8mDZ1NQDQlA4YVQ6Bi6WLJYjkEw9juR0GnZzVjiIA9W9/lRDFUau67oFENrUmr5DX3I/NEDMfwFXxjd+AF/A6IbCy2d3KNFbZq9dkmwlZVrLQ9q0c2jmzVO3iDx8M69eNMjFBy1SBJv+hjm1ymdH/uCIadaifRGP4UF2UaxlGG0AIIbwiPgJETmJco8wDGTmCUZF4SEzexyL00pneInIqWG9817txEzz1mbqLvIvMHSM9NFq63+ReldAq7gwnvfx3HL916OzxTBAAA";
    final static private String hd_pie = "H4sIAAAAAAAAAKVWwY6bMBD9FQv1QLJhY5sAyWrZSL300vYDerOCCZYAs8Am2X59PYZkm9ja1gTEgGz85o1nnu3nrGXHJ14XrN7xLNhzWfG+fUe6uRJtK9ugkK34LeuelamXs7Lj3lX3gbe92N129vzUB6zlrEu9bU5DpMwKTAQm9lB32D8dBD9+lafUw0jf57HvDU89KU9VGTTi4k5mIhe87eB3ElMM19h3CaBhfZF6P5QPQsGs0Hd4ETAh+oV+DgOklJ+N+aZewDMBrhtlQmzgvDwPnl/fWC9kPfCoWaWY52dauWyrt5Klnsh9HHzBaIEX6pOSaAOXboHn3DCbKdjlFe5nbojdDTHcqBZ4Jrqht27UHKAHHGxzjJyAQhOIogdKYp3KADuBrSzBA95iNCFyizK6xSvl/iiyvlhSJ5zYDDJC807UfiPmPszZbEnwWofsxjCxMCy42Be9I8W1STFB853s7qa4sQbvAzTrWU0VeAzJWaOZa60bmtKkfZjYe6ENHU1MPbEpRUllm2+QY3UTQytTk00MoeglTJEi2JmVIZKb4iaTK4dYdHNVlHdAG8Ixq5JEUDskdi8eu5iu6nI6uEVPQ0GRxDV31CKgsQ7WzliGYvSMnpNFkyFLE/NFLTJKPqrsXnTLLkTG/YwStw2N2rSl86OQXOfUoi3Ij+ZFHXlZxDTkWiG58rJtO3p1dIMxdHJZ0NxwDEmMG5Y+RDy6xRYamlBgq3+DqYNjVnL013fQyE7AH3qqh2PkZfTwy3+OheMmxcbYkcftQf3lDwEQBXHBCwAA";
    final static private String hd_chord = "H4sIAAAAAAAAAK1X246bMBD9FQv1gVxobBMgWS0bqS99aj+gb1YwwRLgFNgk26+vbWC7we62kywRjmXsM2fGc8zwmDXs/MDrgtV7ngUHLiveNS/IDFeiaWQTFLIRv2TdsTL1cla23Lt6fOJNJ/bThx2/dAFrOGtTb5fTBKlmq5uNakLsofZ0eDgJfv4iL6mHkfmNa1+OPPWkvFRlsFfWs9GgzEQueKMgaYL1hUhMTWeY8erIkXVF6n1Ttkismw36gb73k6SU7837qv4idWvGIdENNWufHnsLP59ZJ2Td26tZpZjmo/lcNtVzyVJP5D4OPmG0xEvVpSTa6suM6HscmM0U7OoK9z0zxG2GWGbUiL5vNEOnZlRc0AIHuxwjEFBoA1G0oCQ2WxZgENja4bzGWw5NiGBeRlO8Uh7OIuuKFQXhxLaTEZq3ovaPYu7rmM1WBG+MyzCGiYNhwcWh6IAUNzbFBM33sr2b4tbpvK+hWcdqqsBjvTkbNIPmuqUpQ9rXgb0X2tLRZMvIzfEgDu1chfoOaIeaprEmREeEUHhILHXZ0b4d/KOkRhxaIxFa7PItAp4m5MPERRzqIokmRTCYlUNPvYMkhGJRh4AGXmswlqUY37wwNdhWZTQsYtQSiW/evAqNYjiaQxdrNCdQGIcCsKGkIj8qFoZopb0R7HgWDBXMrccBdWgh+XOI3YtuyaNPRF0E0AhWBVCXQExSKyRoIroEkgy8YmB18leBKCQgr9AlEJ3LptT5DARz6WP9bzBV0mYlR2/6wVG2Qs8wvvUF7uvqfsp/rjWlO7bWDjymnw9PvwHCSqmtVwwAAA==";
    final static private String hd_teardrop = "H4sIAAAAAAAAAK2WXY+jIBSG/woxe2E741ao1XYyTpO92avdZG/njlRUEhUHaevsr1+Q1mnF2Qy2bQTk4+FwOC/ynHB8fCJVjqsdSbyMsJII/g666pJyzriXM07/skrgInZSXDTEuWo+EC7obtgoSCs8zAluYmebwjXYpsiXCdyoEnRAc8ieDpQcf7A2dnzQ/c9j32sSO4y1ZeEJgnnCWX2ekyU0pYRLKvTV71Tfr6DGIo+dX6CbC4E/Kgv0G1TJUk2PVGnVlxB4Bb81iDH2KeunGiCfQOVdsvoq/2poqJLosqbzzqaz4uVZr+dtjwVllV5dhUvpkPS82JTxcl/g2KGp63vffPDoP8oi6hzSvatHv85mErm4Yv5vCjiconnjwkV2EDSEFCw70kTkC2TFWQ45ymVz6VCwgFagYMSgnNAsF5YWrUyLgkkWhSZoqUC+BOm4tqFFJm01nbY2aSGY71jj1nTuokjHlSSvdckKvjHhEZg3tLoHHBoKmRh50NCB3GMfPGzTNfDsvAnH1DAp+OCIHuTZ8uB723QD7FCGItzzAuUxNrM1zJCFqy3rzkNr2og20N3iD45oJbhfAI5oR7lVbREMLfdoRCqnLQptgxAZwvgIHRjZ2YXGtKE3O7K269NPhR3GUEavMTuOKYs+Dhahyr5brs9Uxiq4hWdow51KMnRwo2VG5N/IM6L/yzx5e0sKAi7KXs0aqnp0sQr7i+apleMqI17rlbil5b6MHXR5tRx2opXu9DG/7tFbM7xMv/wDXDnH2mULAAA=";
    final static private String hd_frame = "H4sIAAAAAAAAAJ2UUW+CMBDHv0rT7EE3GwvqNEYk2bPuA+ytkSs0oa0rVXGffoVat5GxhIUcvXLH7/5Hrmwywy5rUAVTB8hIDlqCNVfUPpbCGG1IoY340MqyMsGclRXgH+EzGCsO3aCF2hJmgFUJTnmMvM2czTGqzvn6LODyousEU9Re4b3rERKsdS1Lwg2T92I6E1yAcbgoXtCQfld+ZLZI8L5l7VyVlVube8qXrbdEb2iPgpLdzZsHTbc1dlmveLvx7PcTs0IrX0k5La7FUJhrI08lS7DgI0oeKJrQiXOdMuq3jbW78dgBpz+IfxWIugWkUKNS5xeR2WLinAJEXthh0LgLTXmEHlNO0TRqNNJBtFmXFuQ9UdJ8w0Gw+S8w3+J/aIs+adN4EOe5V9VA0LIXNAiz6uurj+KORVYC+uaTo65Ek+EPZBjkW9AwlQOpiWS1kCeZ4HZ2e3KE8jlfY+Mz7lq6/5PtJ5PwJXhoBAAA";
    final static private String hd_halfFrame = "H4sIAAAAAAAAAJ2W0XLiIBSGX4XJ7IVVmUBsrXaaZmYv9mp3H2DvmAYSZkJwETXu0y+QJmpIOsU4QQj4ncM55ye+5oqcXmhdkvqd5rCgUlCtzsA9FlwpqWApFf8na02qNGKk2tPoZvpIlebvw0lNGw2JomSfRgggkDG8NU2CIrA/Fi9HTk/fZdPOmU/3q/OOppGUjahgSSr2QxHRm5M5Z5wqA1zZC7j2Y7LfwY7oMo1+OerP1qozbpuNuVdX3zhxcwkCf8Dv6O21Jf09EM1l3XJrY99srPOPSSUOFUkjwetZJYsTz3W5NJ2S8qLUDwYS31A+g+IhFCN7zTtunDEEgojJkMjZDMFvGCzR0nTNjoEb2dsOHsIcXg3x1sG5CSCIW9eDaI9DWh/GuU1P3IUhCPo0CV0gmLHHsHiuJzKUsScQnp3n8eygPjtr4Eb2toPA7GwmsvN8V3a2Pm0DLqXZhzWs4j0ddUCXnW1YPLEnIFs38961+yoIeyK6LSGMA70cUY3xEsdJGMaTy8wdYIvL4RNK9LQyc+fkogtbMNCTi6uZ4J16OrlkNJDkSaKv30CQp4a7SisZK//PZWTeanlFwVUf7uSe2xX23Zn1qv+YVKQuKDxDQRouDsKmYD2xgtftisu50K74imVbwmiM21xbxhMrpi3H439H3v4DKMW0m6cIAAA=";
    final static private String hd_corner = "H4sIAAAAAAAAAJ2V0XKjIBSGX4VxepGmYQRTm20m1pm93t0H6B0TQZkRSAlJzD79AlaTaOws1ZGA5+Q7cDi/bApNTmsqKyK3tIAlVYIafQb+teBaKw0rpflfJQ2ps4iRek+jG/ORasO3Q6OhjYFEU7LPIgRyhrFrEtekEdgfy/WR09NP1Tizv7s/nnc0i5RqRA23Skuqu3Cq4IxTbYEpshfw7aexX8GOmCqLfnvkLxstBci3OVu52MvrDm6N9ucd/IneNi3p40AMV7LlSiLsbFgXhiktDjXJIsHlrFbliRemWthORXlZmUcLiW8oX0HxEIrdgtC8x8U5QyAImUwj/VTDicshkbMZgg8ILNDCdm32gB+5xw0ew3LwfB+Pe3wC/Mg9bhCIT4d4t/55zp5B3GYmiPYyQVt+i7Ya0vp9f0IwZy9h+/RjPLcUzHGcBFFeh5SZk8vTpcADeXgknK4S7Rp7ahhyJJu2DH39rWzdBIpwJJke1+vbpTKQOpJNBwvDjOTRCzlwH0ZC+GbyRxK4fKwmZ2S/zEVNwVUf7tSeO4/2bOiU8GnURJYUnqEgDRcH4UoZT3hw2XpclNd6/E9kfzbc4zbXkZMJj+nI8f0j9e0fHbH5qmsHAAA=";
    final static private String hd_diagStripe = "H4sIAAAAAAAAAJ2UUW+CMBDHv0rT7EGdjcWhm0Y02fO2l73trZEWLqGUlaq4T79ClU2UJR2kpO1df3d/uGMVa3ZY8jxl+ZbHJOFKcqOPqNmWoLXSJFUavlRuWBZhwbKS4wvznmsD267R8MoQpjkrI0wRRRvxYMcco3KfLPfAD8+qchZ7n88cCx5hpSqZkRhY8m40FG00FYMAri1vRu112m5TL5hJI/zahArRi30GzXyBXPiAog/0htcrd+xzxwyo3EFyJm1gcWYKpeUuYxEGMaDkjqIxHdtpUId163q45XBokZML5l8hgm6ITCUHiE062giKJo7pRZx2ibXwUTCZelEeupRBjbk/Zzf0xIU3ZKYcktT8W+fsWmfor3N+Q2fY6HTp+Qp97Puenpyn3hfmCVr0JeRXplet0ObTx7FtGGcc/ZqTQpVQe9R9vmlr4mTULE84ORLJKpA7GeFTTdx2gtw5/dSM82iT6f7B1t/wVebW2gQAAA==";
    final static private String hd_plus = "H4sIAAAAAAAAAJ2V3W6DIBTHX4WQXXRbSdHZz8yZ7HrbA+yOVFASEYfYuj39QItb7VxCYw4e4PDjj3DwMVXkuKNlTso9TVFGpaBafYKuWXClpEK5VPxLlpoUMWSkqCk86z5Qpfl+3KlpqxFRlNQxTNgKJGxjbG1sC0F9yHYHTo/Pso0hBt3jxn1WNIZStqJAVdHUbi6ZcsapMrRwibGLHoRXROcxfDWghIXgpSud2baHU9m3BWdOdOpx78ANHZyoGx2Bd/AGnx77mT8aorksex0lEUY1c7KYVKIpSAw5m2F0g8Ecz41rhfdVa13t9tYAF2fE/yYIxhMIXs4KmR15qvO5cXLKs1z7QcMx1Kwc3CUMg0VgNWIv2sOY5uTdY2S/phcs+gPWL/Ea2vIfaQPYi7j6Y8MTtrT7bdX57cN6CjZssD2ffszNFNPKm2M/2HYaFoFrT19wkTRuuYvQD3SRHIMiX9JFRlx3OoLJXJjCmNssLSj45aNK1txG2LQMh2vy1KlImVHUIkFaLhoRw+5SmYjhZR/zk899xKBl/Bd4+gazB5mPHgYAAA==";
    final static private String hd_plaque = "H4sIAAAAAAAAAKWW0XKjIBSGX4Vx9sJ0QwMmatqpzcze7M3uPkDvmIrKjEhKTGL79AsYbZQmU6IOCB74zn+Yc2KeUkmOj7QqSPVKU5hTwWkt34F5zZmUQsJCSPYhqpqUiZeRcke9gflAZc1ex8aaNjUkkpJd4m2yELQtUi32wO6QPx4YPf4STeIhYO5u3/uWJp4QDS/htiRv+96bSFnGqFQ8HEVRfHrdS9+Suki8vwq1yQLwR/VLNdZPjFW3MsNATxF4Af/a7UKIS4Tfp+Vmi+mWPXVgW+kuPPc0MOuQcXzufWBe6+7BKHp+aiN625OaiaqNryJcnUfWHU8mJN+XJPFY5iP4A4E5mqthiNRlprqZ2WymgIsB8ZoDPHbAWeWXIj+ytC7malBQlhe1GzQYQ1Ws4G6TIbDAWiNyoi3HtE7eTwT1aTrBVl/A2hBvoYV2oAG4i1GM8S2RRlcjDd20xdcjdaStL0lbBE6ch4uqHEHYKo2e5MaxKqCLzA1j5bwfrkwGzBaRfty7pQK2st6H04BW5vsYracAreSfqtBKfx9HwRSgVQJTFVpV4N9Ksurg+9LUZystKTgbw63YMb2i/QHqKuNklKTKKWwgJw3je5545jtxYQ2r2jWf3tsVvZbxX4bn/9isKPVLCAAA";
    final static private String hd_can = "H4sIAAAAAAAAAK2WS2+jMBCA/4qFeiBtvBjn0aQqjbSHXWnV9rK33qxgwBLgrENe/fX1QCEBl5UcqsiO7Rl/Mx7PCD+Gih0eeJ6wfM1DHHOZ8UKdULmcCaWkwolU4l3mBUsDJ2Lpljst8Z6rQqy7woIfC8wUZ9vAIWgVTXVb6jZz0HYfP+wFP/yUR5CVv3rXacMDR8pjluI1y2tDMhSR4Eqj6IyQWrnxesOKJHBeENiZoOfaEnpDf9Erqtff0Od0FflnzYsh9aGj6Bd6rSxIKfuM/D5v1QPY6NMLy21x2U077rRVZtDNW0v30C30rj+N38svdsIaJZdL9Tl63KFlN9XiagWO+/RYRfTfjhVC5lV8c5bpy4jqcEdSZbuUBU4mcjeV8UGERTLWg4SLOClGGuK1KP+D+l0o3Cu5bWjeKiLIiki7RBG5BN8QNCZjPdQBQOUMGkxGdg5Punhw8FYHEnkUXCdWtKlJm6A76LAdaNYFNRG8Ixh4VrT5F7Tymj1qxbnv9coStOgFWWGWfeeyy1mjEq4Mj29kv+uTRZlFI28Ofz/sssA3kt/FA4lGvrvXkoxcH3pYI+eHAo20Hwo08v/q4BkFMNQ1oxSudY0a1TDQNfrdVUHNqhgI/LaioAOKQr9HwpSjizHeyK0ADfiOwCOipn+KFctjjk84Y0eR7TLQ8ns0RF5pnK1XGo0v3Zfi0wdPITr9QgoAAA==";
    final static private String hd_cube = "H4sIAAAAAAAAAL1VXU+DMBT9K03jw76aFeamW8aW+GBi1L34trc6CjShdJayMX+9hQITtqmYKKSk5Z6ee05vKXNXkv2MRgGJNtRFPhWcKnkA+WvOpBQSBUKydxEpEjrQI2FMYS28o1KxTTOoaKoQkZTEDsRg6dm6TXSbQhDv/NmO0f2dSLNYfpezDlvqQCFSHqJN8lplEi7zGJWayx5jXKIr2VuiAgc+A5PoqUhVpczfT8EavIAVeK6iGc7CedDKHqMKvwYF9Eholzhczf8O1SAtRZyTmc+oKzOT7sHKmBVC/KXfh58Zfvwfx4u5qe9bQhQTkal2RLjeG15ZfE9InoTEgczrYHSFwQAPdNfC2ZWPs2aG3a6mHNY4v0phNVNwFnVC4e+Zq4KB7gSU+YFqR2o3SfUagN7Sw2BoRLZiGzXZKlV9jLIFbcV2faptBHrW0G7FMm6ydDIh/eN6teSbnPGYl+A3Fm9OLU7aW7y9aDEX1tbh9GIV2+3Xk2+iFHSJRp8jbkjBpz7aiphliOK4hrWgJJFP0QFxkjKecAcWW/Y8iEUGdNzSBlGJaf5uFh/U9bMnhwYAAA==";
    final static private String hd_funnel = "H4sIAAAAAAAAAK2X0Y6iMBRAf6XhCZlhobeIOBnHZF/2ZXc/YN+IFiEB6gDqzH79tkXIaDuzuagmtVo43N7eA/V526SnJ17nab3hW3/HRcW75p3on6uiaUTj56Ip/oq6S8uVk6Vly52L4SNvumJzPdjxt85PG562KyckIVlnbK6a2CHtcfd0LPjpu3jrx+R7OOt9z1eOEG9V6WeHuubleWCMcJ92+cr5JVEAqmHkp8LqCwD5Q9QIY7KJ5Jff/dlCiK8AP9SHPkOeulBNcgFV41QhqT5iqQ4NLy+lDlE9NcWIqgb05V+e++hfD2lXiLqfS51WcpLZMOdMNNWhTFdOVdRuKXanYtvlj7KT82KXdzMJCS4oX0HpNXSdhcSjAYQoDFxjhrgCQHGYGQ6Qh9CXuSQoUGQJqM9PEKFAczOiaFJEsW1q3ka07r7w3CgJ5WsW0FB3QtwqLmxBeq2sj9vZyTXbHThe2qU1uOtsQR7XWUxms2BfoNhLM+6EeBBQXA0bZgwR6nVKcOtEDSVGGvg4K6ihxYfAcGJQqxlSVFw1U8MLXSlojNWKsZilGyGZWm/ULspQzLexDVHa16ZTzDnxdPsg21j3Y2m5h+UbsujYVXICiVwgK9GiB03ulGYwpOnhd8kzGA5NfB6AYZBMKNWrtCRIG8GiUKRQEKJRFo3ohQDJ9NxZ3JK7iQ8LcwPbcOtc/xCpKoU+HdoF2eLrHywPIhW7zo40AGKcAWDzaXGnPFvsUux75JlZ5OrLFhJsrTGbS/1Wpt+GRLicMotSrI8NrRT7fL/GkFEZRo27DOx2gBkCDTcfHMZwZcw7jmM4MdxbYzW9b8iMm9sxSaNTaYYD57KfAouMolehwVSaUfbjvnMi0Kh71wca/5d4/n79j/flH2poxSMKDwAA";
    final static private String hd_bevel = "H4sIAAAAAAAAAM2VXU+DMBiF/0rTeDF1zTq26bKIS7wwfmzeeOddHS00oXSWjqG/3kIp21DMMDExpKHQw3NO37zAVaDIdkaTiCQrGqCQSkG1egflbcGVkgpFUvEPmWgS+5CROKXwYDmjSvNVc1HTXCOiKEl9OGcesGNkxhiCNAtnGafbG5n7EIPycM+9r6kPpcxFjF5pRmNnJgPOOFUGN/Qm2Mnr5GuiIx8ugfNaVG61azUfgxfwDJ7AsnQtVBNz3mnteAG1aM6mpcyrIA42KVf2hLiWebUcH4qs2aJ+ekcbNW33s1mxYx23x2air1vZjzOqNM5rURNvwZMttZTy76r9eHS574+q98PRBb/7lxW/vrLd/bYhmsvE9npChHk1mGt9JpXYxMSHnPUwOsGgj/tmat4NbC+LUV6dnhrg4ID4k8GwaSB40otluOWBjvpmElEeRrob1GtC52wIzuYMg8GwyIg70UZNmot3jlFR106w8Tcwu8Xf0CZt0TpRLlozDbxOoMu2OB0509ZAbRjzqQhiCvbmaC1TXijsL8E1crWoSBJSlCNBci42wodl77ZoeGI1u7axijpL8492/QmtgZBE6gYAAA==";
    final static private String hd_donut = "H4sIAAAAAAAAAK1X226jMBD9FQvtA8mGjTGQkKo00r7sU/cD9s0KJlgCnBpyab9+bbOkJJNW67iKMMN4OHNmmIPIYy7p8YE1JW02LA+2TNSsk6/IuGsupZBBKSR/E01Hq8wraNUy72L7wGTHN9ebHTt1AZWMtpm3LkKM1BLpJdRL7KH2sH04cHb8KU6Zh5H5Dfe+7ljmCXGqqyAXzb4bEoqcF5xJBUkSjIfwM/sd7crMe0YmGUF/0LMydNJE2b/7aCHEhzf8Ooery6Ve0rFnpRaCRx6iayFk7NEGif+lJu+wsToW2mWiFmOPTkTSsUcnivDIE+lEETFVPD32Rb/sacdF07egobXqWDF0pBCy3lc083jh4+AbRjM8U6buWX+pD3M1mSjA+QXiZwnC6wQ1b/xKbI8878qZMkrGt2VnB0quQVXX0HRdYDQPNUdshRZdow305sQKJ4asIvQdB/qxWgElNwj1bbJktICMkrsYLW+VNt2I1t/xqU+WpukT1fy0t6zA01ssp62aky8AX33Rww2BUtbFqu/l0q6XIZCEQdI4gd3ghkAH9w5KCDRg3kOmvNSyvBsy0FAayLa+j4VghwN0MAyBHQxQgX+eyflCn35Y1gcm309iFzww7H64IA6ABAy9G0ECRt+/FwmMviMzIABHPKACRzwgBcfZI0ATfuDGEKrDDQ+Kw5EgVMedSBGUhRu1COrCTbgRlMd/M1RfunnF0MgOdqLlOkK/y/tPVO9iX9Kc71t1arYsqOmJ1/s688zn4meBvOkD36n0YWdi138ynv4CKyGOon0MAAA=";
    final static private String hd_noSmoking = "H4sIAAAAAAAAALWYy3KbMBSGX0XDdIGJKUji5kwcz3TTVbrprjuNDbamBjmAE6dP3yMuviAlU0Fqj4UQ0q+fo/NZ2A+bkr3ep8WOFet0425Tkad1+Yaa5pyXpSjdnSj5H1HUbL+0MravUuvm8kta1nw9vFinp9plZcqqpbXKKEVQhLIIZBFZqHrZ3r/w9PWbOC0tHzXvfuzbIV1aQpzyvVuIn7n4zYttP6nY8IynJcjiJA77Iec7OLB6t7SeQG2VkRj9Qk9yPviEXT2QJ0EAZz/asUKId4d/Pw+G40IO9K9aAiwLct3SiV+1NEXUTU4iWSSNruwlT4NYFknfQ85C/dsesi30G8uPD+39Ph9ZzUXR3n3BcghY1gcjE2V+3LOlxTPbd7/4aO7PoRr68GpO5ac5m81A0LtR/GgCPJwg54W9F9tXvql3c6jsUr7d1WaiZCi6yjByVpmPPCw9+kZqdKjW2/OIkU6guqLozndhhZCRUKgx1IbJ0FGkOgpHOYqHQjb2kybSDqtZQeyzw3kfvNnMO3CjSRLVbYSctajsA3fsVRajmddPa5YvC1U5QE4FmThVGSsAVc9lDZKJzMcE3a2yhawtIOyOqbbCTmNbRsWDhPfNlhBroCHIwYYphRVahqkA1giaQ4mReQ5gDUSYIod42ExHYcjtbd4R1+z7ASsY/Y/sxwpjcOdRSytEwExLgxKOpVZv3ExOw88NmXg8QEQBaMDmFG0FoA5O3DAJJeBJfFmH0hxQokHqAijBZotGFLJAg3xWmDVcSfHPibNuwxqzgxLNhkXCZpUoMqSWKDyN3UWJhiZ40JOuAmNXGpRIvycbUk416JC40woMtTR7Db3kHonbtBiZIFQDSnhJvqnqOnC6mFJDCKmOkyYDQclwramCxWV9qOEDGNWR0eQgKJn6ep8MMx2Fix57MxkFifP2OvMiefhqdn+BwoUdBlP0FDZsHJEpggoOEw2qz2RjlZT0n+hMQWCinvooNk1P/WHT7YSj1BQgpFo4Vk3lAtSSkWqhCsW/eduxYrNP0VXdPYiKyx7tT4jVZavtrpdsw48VHIpt6ubsxPNjvrSafw8+6siLtuPFStvtbGz4l9PjX5PVfiWLEgAA";
    final static private String hd_blockArc = "H4sIAAAAAAAAAK2Z25LiNhCGX0XlygUz4IwOlgxby24lN7lJ9gFy54AB12JrYjyHzdNHJ2YD3bvZ1gyUZfDhV7fUX0uy32/H5uldOxyaYdNuy31r+3Yav7BwuO/G0Y7lwY7dP3aYmuO62DXHU1tcnH5sx6nbXJ+c2uepbMa2Oa2LjzvDmSuWrqgqV2hZsNPj/t1j1z79ap/XBWfhe773y327Lqx97o/lX0e7+fzLuDnXabfdrmtHpyr4kvuPu1Fqt09XvPhy30yHdfGHq074iiVnv7ud0r4w7E/2Kd5grf3ePb+5Xe22ld8bX9QXOv689L9lOOnvqldB/cP7aM/fD83U2SFaNzS9c213NnZnx/7h2KyLbjfj5U+cLfjC/ZRCr/wnHPHb+cDNjZO9u9D9XjUCr0aAatwRv2VWI/FqZKrGd07867fwj1iBuq7A9Q+b8/LjjjOSUAWFFJtLYUIklZwkphG3vd4iFRWjeWmu9XhwUdNcrK9Vjnb/1G2nw50k6SxhU9Xs9tQNs/vuduZb/ubujCDNzxVi4aHt9oeJaKIAGHlObzf29GobBUDnyn2RLw1wubL6FdIIKM7qmddupmaQTn3pQ1O4lqHmEoQdZ/bMN8mrtQFK0G4hgrikiwOuoOH54m+Fm0B4EzWbu1IxYmISb0aYRAgTq2BVRbVKIkglDzVZC2Eo2WXIWgCa3kXGuRsXL01HHBMRXKRit65kjm7/oemhiIQBQla0EUKiQORJgfAPs6E3yZMSIcJNst4kUUpAyLXd+UOHQpi5tPsV2ghD3u6LTClrn8zkkpzMFEKVt/wiVearI4MTtH0Vpk/0IURhvAHbs9UR+mLuUoKabxSCX8xdSpK1EP6SXeRRQ2EjULSLnOsV4Os8x86atSNE6Ziw1IooBQDqm+dZWO4twqKOFhcVICbKyTCfUDVVDg5FQa4KcpWkygEmwgqlcgvKl+HN/VVUWQCDrvL7FtAga56vBniIHuvQfrE0VHcRLlL0VTXRPIBFChcewoVqmQZcJDkZ5JZUuW+wUYWsqTlVDnss4NSW7OucyusKqi6A5DyW5kSMBowomR/NGn8moMPzgFRSHwtoZLxI8aeJzwY0wMNPdbOznwZkRLnM7KchHUFOhxmHpoazwR6yOR3jH0u5/YqqB/AQRmZHigF0qDo/ig1gIvhqQkekkjp6GGRGleLOKKJ5AIsUKHl5zwAiklxe3jPfoMKE8cKQrQNUxL6oYtwZKhYGYBGJnUfEiCv6GlAR+2EeG46qBpiI+M9jNqGqASZip85jjFDVkPUG9/GbZis0MQQG52aSIs6Oa4CD87NW3s+6ovsJaEhLzDDh/ploGmDBp8xcMUBCWrRniWEYmP8XOzTD9tiy//wu7+2p81eETozveV7ujpf82L3pHVBxccHYbLuHk9sN+7Z0E6iuf+jdDJl/fUOFXtgN8UJoSfLq+hXdh38BTulV+LsbAAA=";
    final static private String hd_foldedCorner = "H4sIAAAAAAAAALWV30+DMBDH/5UL8cEfa1bmxqYRl2hiYqK++OZbIy00ob3ZdRv611uoMAdOg1HIkdJeP/e9awsXiWGbc64zpp95QlKOilvzClW3ksagIRka+YbasjwOBMuXPNgZXnNj5XN70PLCEmY4W8YBBQpzEYbuEQWwXKfna8k3V1j4IXfXk14XPA4QC5UTgXnCk2s0mps6ICZSSG4cMoyiaPrR3ahfMJvFwX2FvPMRt4GdjZ3Nqq4ZPMEjPMB901v6T5xNtxOe4GefXWiT6KewN/DgdSLiP0q9/Sutlxe+qC8rZiVqX2LNlFsYUa+TQKNWOYsDKQ4pOaAwoAPXnFB3Va+lVW9HRw443CF+FyBsB1BSH+aYbmRis4FrZFymme0HHbWhLl84ngsKw7DUSHvRTru0ERyHw0kvyrhNqZM8oaQE9oJNupLGcDIXp0D65RZ9ocpX/Deypl1Z0a9kzfbK6oU521fz4ajfJu0cg0ZPX1Jnv9eS9mHc5yPJOXxqkwUuZenhl33eVOtj2DCdclIQxQqpVioOqnO5x0dq77NdH+/RqGn/KC7fAS/bqldBBgAA";
    final static private String hd_smileyFace = "H4sIAAAAAAAAAK2XUa+aMBTHv0pD9qDuMmkrRW4ul2QPd9nDXbLsbW+NFmkC1AF6dZ9+nKLkSmFZcRrwUOqv/3Pov9WnbcnfHkWR8mIjtu5OqFzU5Rnp5lyWpSrdVJXytypqnkVOwrNKODe3j6Ks5aZ/sxan2uWl4FXkxAkOUJwQrznhNUTYQdVx93iU4u2zOkWOh/T7+t3zXkSOUqc8c6tcZuL8wjfdqGorEynKhrtiPr20dhnseZ1GzivSY4XoJ/qBvqFXGLM5fB1RHV2acXOs0XeIGJzgeqXbXnSPjtNctmMppUaH+wIfMBIGBgEiCQwR0ItASEAK0RUJ30m7vU+BTTH6aqf4VgqFiNJLHs9PbdF+HXgtVdGWsOB5U/Xk+hASVeaHjEeOTGYuVNr94KEHHT00TV0LHHAxnzfY5Q33b8Pg/jCZ2r3JbZ0uViELlwSzMLQCklEgI9gHoOdZAekoEFNMpxBX40TGVt4Eoj9ATIXcpfUi8IMpRDZOxMyfVMhgHBknHlpiD15WyHUfGScMffTcOAmQFSgcBAHGtVOEDd/0svStk8SGR+IkBHHYs1Y36o4lsQMZrtCrzGKjqtleLmYk0A9z3jzUdRvZ4Ycs0lbRVqhhDb0SLipZ/BehQz6ZVFDDHXpd13MZU7vJjAdsgfV0bki2M8ZwxtQnQQxn6P2pzdC3y5AMWAK3nvBtMyTjOwbGZMpCR4a2jOviORE5bgg7ztBOoZO1wxjTftb5Z8ng45Nlfsb0n+kiTQcaHrhXoWGEOxVSww93KqSGKe5VaDjjXoWGMf5dYfNDe5sJ9C5296qS0OOyvsXdLn65X/JiJ9yzm/OTzA/5zR+FfhdZtF30D9tOQ9urU9T/e/T8Bzrj0yY3DQAA";
    final static private String hd_heart = "H4sIAAAAAAAAAJXU3WqDMBgG4FuRHLYEE/9aS62wHW8XsLNQowmo6WKqdle/+FeoM4MgiZD4PQkvH54zSboTrRmprzSDBRUVVfLhjMsVl1JIyITkP6JWpExATsqGgpftlkrFr+tNRXsFiaSkSUCax06aY2+Y0DBh4DRtcWo57d5EnwDkjM9S+rjRBAjRVyVklEg1rz9veSOKJeBDS97kvutXqMdRj2g5atzz9eQvK8H8yVz15XyCy3miv+9EcVFPB9Wk0hfIl/vkQlb3kiSgFEXHM8V2QewGR13rvhT/Z2GjhZGt5Zks17Ny/LUzJLNHMM2RYwUFRgjbQeEmNDAQWUGRAUK20GEja0Z5wZTrW0HHNYTGgA52AcXmNnIju4Y0d3doS2019xTSzrOMCW819xx4YCf9ae+ntOG42//Byy/XmZsDIAUAAA==";
    final static private String hd_lightningBolt = "H4sIAAAAAAAAAJ2V227DIAyGX8XiclJUIAdI1bTSrrc9wO5YSxKkJHSEHranH6TttE5h0kiEZWH5iw38ZLUz4rSUQyuGrdwljdS9tOYDpuleGaNN0mqjPvVgRVehWnSjRHfhozRWbX8FtdbL8fCWHJU8JaP6lBWipMAYJnsFWHm2iTBSjBXa1BQ2delG7gahCMZjs/Tpj/pcIQzTe0v82Dug1ue+SzrVtHZQQ/OoO3uNf/ezF7at0DPwjFGX/wSE8gJDgTkGQnDuXFYyIEXOnKUYO5uxwvvczfwoGQjGhLpoSXIXdQ+QtOQMcuzckuEcWIEp8JT7L6W8xPAKL2i9ulT0fhBW6eFS3yB6V399a6fWpj90okKdbk5qZ9sHD11clmq9WtwR/gKSINAvQASQhoEsZxHANAic1jeCmIWJfq8jiHmYmJYkpusiTPQnL4LIZoit9FJ48EcvgsjDRC+XCGIZJrIsjemazCnmivQSjEHOaeaKnC6EGOacbG7MjEZtOJlTzjfTXUoxzKB2/oeZE8yltBnOYv6Ps/4C1QwCYIoGAAA=";
    final static private String hd_sun = "H4sIAAAAAAAAAO2Y226bQBCGX2WFepET9Z44OApB6k1v2j5A7lAMNpJhU4wTp0/fPdiAvYvVnevKMhnD8O3s8P9L4GnVFR+PZbsp2tdyFa5L0ZR994n07qbuOtGFG9HVf0TbF9ssqIrtrgzODr+XXV+/Xh7sy0MfFl1Z7LIgr2iE8oqlckO5ipIA7d7Xj+91+fFNHLIAI/05nfv5VmaBEIdmG+727Wk4saqruuwkkEYYn5KH2t+KfpMFPyU+wnLDE/RDDaXjeIgoekEqh6pflJgcoo6oDaMqwsccnsqidAJTm6U6Y2miI4SOEJqaU2WUGJzKmVRCYzP+KYrPIMzk6FOjAcfHSuRmaXJUCZydypLRdEaGY+bBh7lFxxzGTT0v6JdpnxDifwchHfyuYq1qVUqkciKq+/r8ZHT5e1/0tWiNStuikZKuTqKtRNfst0UW1NUNUWoOv2D0oKMHuYvHaRLpXeqrf93eSvDijHxtIHI5kHIMvsdhXmHkRaKXpLwi6I5hmvAFo0mcetGYkyYnzjGAxm0aRfd6qiH2IkU2icFI8XznqV/nk3kS8yOlzq5TRhJI15fuuvIqRZ69IpYfximmflMkluLzKpY6XXA/jEPuCQDj0jlB9yyOqW+PHCInFIZyqFyhzArkybJ0TvBw7eRU/WCW1KcwT7ETS+1TGPeEWWKfwiLPpdSS+1asP+pVv7kjKWfxgpIY+10GasleIjdlvd70d4zEDIK0LDBUCSVabhiLBE/cssVQZV4t0cJcJj+kZY8JkmAY07LJlElgTMstUyaDMS3TTJkcxrS8M2VGICabt5BkxjCmy0MDM4Ex500kmSmM6bLRwIRpnl2zEUzy7KqNYEiXi44LCJjpctHABHbT5aKxTmA/XTYaobDZc5ePRihsEeFXbkbgVYS7nDRCYcsIv3JHAq8j3OWlEQpbSLjLTSMUtpLw636CiZ/PG2pB/UizNyNf0Lx1/J4OZ+86fhjLHzcEp7rTt4tY/fnq+dRqeeNG/yf1L8BN0a62JZrE4ZvY1SpDP/2a9xzBWUJXtOsyPIRNcaibfZMF+tXETE7dmhz9dDFUYbKGmi5fPD7/BdnjxLiRFAAA";
    final static private String hd_moon = "H4sIAAAAAAAAAKWXzXLaMBSFX0Xj6QIorvVjY5OJw0w3XbUP0J0myFgz2CLGENKnryRj0iBB5yowCP+IT4fLORf7cd3x1wfR1rx9Fut4I1Qj+u4N2cON7DrVxbXq5B/V9nxbRhXf7kX04fRRdL18vj7Zi1Mf807wfRmtKrJEq4ou9MDMRh6h/XHzcJTi9bs6lRFG9jl+9G0nykipU7ONG6XacTm1lpUUnQZmWD/Ohy/ad7yvy+inWSM3Q4F+o1/DJKXUvXk/zJtRSIy6FJuBGJ32WGp2qRmYJT49Duu+HHgvVTuoaHmjNVejqEp1zWHLy0hWExx/wWiO53qzyLVyu2tedm861cDkA/HeAuR6gUa2k63avMp1X8/1Ri3kpu5hUHoN1d8azVYVRgnBttQQGnNpFM1GjYlhg3ipT91XHBssCJR5hZlBi0phrMWNkpEAVu6yFmhGEwKiFC4lH8qUweQsXVARVG/ipGFVLT/jBOK430ibkYTCMD6/h1mKOGa/RBAqymdza0/dlAJK5Zg9WJjP6tlQLQJ0OvFY3bAsKYa1GeIxvK7XMlsWCaP5ooDRPK4nxWfMSj3uP5tMg2Eoj+/HbgNrEtRjfYptE8Rglq/RjzEC5og67t+/dP1EgxgC/pf5unwanCN6x/0U2FjpTfdrEtD91ON+ggddDCjLY30a0FaZx/DMfrslisccwYge3zPt1pgArcp8HZ+FgBzPTwgu7DXSjPe8pdqyjKK5HgmaTpOdhOGdGLh4rTsY78kGS41pKFkEXOh5ssHO2WBAEzInG2GOcWJx+duDcZxMBMlJnUhMstQWeprYgn+DVTx1AnHxRyDQCcbE/naBNDcdmrb4P03fma23Av2zHe/UXpoZQxdZvV/QnM93vN2I+BQ3/CSbQ1NG9m7qxhzZDnPeBQwzLnKu73+f/gINE3XRGA8AAA==";
    final static private String hd_cloud = "H4sIAAAAAAAAAJ2Y2W7bOhCGX0XwlU8BNZyFywRxCvSiuWofoHdqIscGbKvHdpb26TuU3XqhHCCDwIQkUz9/zvAjx7l5WDcv1+1q1qzu24f6se2W7Xb9q+ofL+frdbeuZ916/rtbbZvFZDRtFpt2dPL1c7vezu/Pvuy67nrz9KN+nrcv9Wb+u52MmNC5qmj3Ytv2dVs367bZTEafpq76NAX9oH5oVG2eH6+z0ufudTJyVf/3971fP1W7616Xi/p+0T097J//m9LPZjubjL5WJDoiMEVXfa++VV8rT0RVxBD1Wkfj3PjD80j9c8xWEPQ6RI+VYN9HH4Xc5HeZ2Fde2BfXwek1pLN3D9dfqm+HaL1l+C6/RJWA9IHpGziagN7mSAHlQfcGDlPi5GMVvPTPsm2IR5PU25Qb0TGiV2O7Ge+n7WPyVUz9GJjHQDqagN7mMVC7RH0DnGc6is0hAnrbN3IUIc1sHoRgnw8OQhUGiFHne9KtXwU5HUFUhjiJ9F0O6pRtUI4uBI4px072YftnlbIryhnDlNQdcfRw3qcXE+1DDOoWUTxrn+MwcHbNeUUwREkVeNr1OQopZ8ucLVMijZFnjcndSSY4W+4XCorrLauNsy7ZMfeOEXREzkG+O8kxZ8OcDQM7XS8eBM+Wi++bnV+dNuhc5LxLtqu3eUHe3uz4+f+p2c671Y6mVbNUyqZ/oZt26+XTopmMFt3jy/xhO/uAEuMVQlCeb2+uThTeEoQBwVk7f5xtPxAGNCjiRYsQXbJ4pMseIRJZJPmiyWCR85cd6rI2JSZczjT4ZElMfCOMSN6gmC4qXuG7hOTSZN+pAwUf4xqAUZDlvyudnnMf38lHAcg46laie4pRr8BjXKfAQY8Zo2BBx9iThAhs1CvQUIORk+7VRsECjrGXRJTAqFeQMa71cBA9d4yCBRjj6PT0c1a9AotxrQcH6vFkFCzwGAfPEMCYERygBGMMjqyCA5Ak9cfOqFdCQtE744LBkpCQWAtfq7uSENBSxkkw6pWABAFNhnG5YAkISWTvk1Gv5INzORWs+RjgQ+GV4NG6/kpAUnKsWbHp0dAxwslJBOOaoZIQAQ9AxhhSSYhHx/ox6pWMaJWhlYtVr2SEdccKaFyDNMBIUoqtciUiCX1ka5VAJSKJOQXjjkAlIZQiWDcYKvEQL2LdT3mADkaIeiQZBUs4GL2ev8Yai0s4IOnvrGTVG4AjBK8/cI16QyUWcghWvRKOpLuLdffjgQIriXcpRaNgSQc4AS2JjHoDB4jo7hy8ERAuAQEXAKwlqh8ixDlkMEbQDxRYpBWv1V8JiLAXNOuVgET92fU2H/v783983v4B+HOPqxEVAAA=";
    final static private String hd_arc = "H4sIAAAAAAAAAK1YTXObMBD9KxqmBzuJG31hIBPHMz20lzaX3nrT2GCYMcjFJHH666sPyMReNc3i2GPhAfT03q6eVnC7btXTTd6Uqlnl69km13Xetc/Ena6rttXtrNRt9Uc3ndouokJt93l0dPkxb7tqdXqxyw/dTLW52i+iZSHmZFlIbhouTSNoRPaPm5vHKn/6og+LiBL3Hfo+7/JFpPWh3hqI1TCcXldFlbcGkM05tZ+XHi8CdqorF9EPMwazQ7KUfLeH2DYJ+UV+knvy+upXcu8htNZvoXwzBwuSWB1OTPIf5KMeqW0yN9rdrWf8+0F1lW48/0bVRnExyCl0Wz9s1SKqigmdfaLkil6Zv5zFmf24M/Y3nJhODez1Ee5bw7DwMAwMY87Y38hh+OkwJi7kks6WBSUoIAGBOLnkbO4mwYyiwGRAvMW76htBcCrjU7yt3jxV66685iicORQZk4t91Ux21cXExmx6zWjqJOMYJgGGZV5tyg5JMYUUE3Kx0vuzKWZB8RMLrTrVcAM+t8lJyRQ714GnHOmJDey50MBHJyljo+PBAt45CvUZ0AE3ncaaMRsRxvEhAe6C0R4P/lFWYwGvmYX8cllkBLmasA8zFwu4yxQWQ4pRNKuAn7xAJrBYPGCgnpdEYwHHDIv4mLLAAyaRvsBwhoQCpqjVYeKKuZ2rGbIm8H8UGVNghilryw221HBggFiOjx4wAU/oeDTgA684dnXVt3Os3IAjhvwmSHrAEH1+U8eMIpmJ0EbN4KQuv97+Fhc7bwTwx7DGj9o2AX8IPn6+CGARp1m41bxvOVZvoFz0GRYCSQ94ozY1Z7SDBXCHVyvtHtkcYywe8MfwDDMqF8AZIjljngBzeK2Jy6lvU6ReGagaQ2YzHD0JTNFndpx3JXCFUyupz6xkWLzAfopapf3ajAMLGMI8M/VQ2CcdYAmrU9jSLaXZP+L2JxI4ot/xuwL+GUkN2MFSGwsG3HAOM2CG9zErVbPe5uTV/9lO7yt7h0uifyvw0tvf8s6+mX1vQkHfnsfpu5u7v1ftcYjUEQAA";
    final static private String hd_bracketPair = "H4sIAAAAAAAAAK2WXY+jIBSG/woxe2Fn6xRo1XYyTpO92L2ZTibZu71jW1QyKl1qv/bXL2B1qqxNrLYRgQMP74FzIs8bQY5PNItJtqYbJ6I8pbk4A92dMiG4cGIu2F+e5SQJrJAkO2rVzAcqcrZuGnN6yh0iKNkF1jJ0QfF48vEtsDtETwdGj9/4KbAg0P9y3nlLA4vzU5o4vwVZf9D8nTBRLsk3LGRUSCjyPM+/dFf6tySPA2slecsQg1dZTmVdvRGSxUxXsWpC8Av8BG9g9dnxepm2Mqd9B2/FUpzzttV+XEiapotppaBmm6nCvcbXzGqPkH+ttGaeq2Jhqr8ehLUiVHlUs+liWnlZsylpuFUaVtKwr3fj5bnY+T97kjOeFeeQkVQeXlieZchFuk9IYLHQhs4XCMZwLKsulD/dVI9ujUYSOKkRby2AmgukLLMTHh3ZJo/HshJTFsV5NyhuQuUegIdlCMEEKY2wE23apJXyvkJH7WYn2Ow/sMLFe2iu6SgGD3iB54t7PPVueup20+bf9rQjbd4mbYI7cRatqjqCkJEaFakbx8iA0rNuGCPmbQTnOgRGE0+9HrvFAjLC3nZnfXhG5NvIw32ARvD3FGhEv30vyQj9nsqM4O/JM5KgHw8bqdCTZ6RET97QuYEHzg08dG7ggXMDD5Yb+P7ckFe1TULBVd3Z8h1TI9TVc1l99i9GQbKIOmcnJSeW7tPA0veTljEsK8Z8rl6MqLQ079Uv/wAjeKPFcAsAAA==";
    final static private String hd_bracePair = "H4sIAAAAAAAAAK1Y0W6bMBT9FQvtgXZlMbaTkqq00h62l62atLe9eY0JlgLuCG3Tff24UFLIhU7GJAox9uXcc6/PEQnXm0I+X6k8lfm92gRbZTJVFi+kns50UZgiSE2h/5q8lLvYS+Rur7ze8pMqSn1/uliqQxnIQsl97N0mYUjaA4MD98j+aXv1pNXzZ3OIPUrqd3vty4OKPWMO2S74Xch79UPqok1qNjrRqqhgI8756+yxgAdZprH3vcrBIc+SfKu+IGV0HLH/jH6Rn+SOAARbAw6t1ziQ500cB2wu6hi+hMPqBElU1Xwhdw07Y8w7BL8eL6xOL+EQdUj3VoEOo50ZBqRYl3w3nkEGJo6EemtAmzW0YXjZXwUeLOrOdFoB8etefNuct9YNFNd2bbi4to+dGSDBo5HiOBAStE52WpwAOoKNFCeAhxDdGQgSq5HiBPAQUb2fN9eN3P48ylKbvBFfLrNKrkmr3sQU2eNOxp5OfBp8oOSCXlRDtqS0OYVPfXZ2VgEueojvJQhPE2Q693dm+6w3ZXpRDVKlt2lpB8pOQat9I+e3CSWLkMLLCo2Poy2twcQpWFvrRxqAwqzAlu+CMTuw1QBY0/wFswK6xP1akSmMokEggAnsmr4eLW0KrRCZAiDO2ZpF6yn6CpEHAK+qM6S2hYZI+T1FVDcrOzgk/X7jKoJ2eKPqt5RYOKT8hpgdzpDoa0J2MEjy/lLUQjhbrODrk+U2IuU74iED+BORGNK+HzhRY0j8bqUy5ABXgsgDfkgjF0BkAseKkRf8cMVcAJEpHAlidzh2ENvDcY+xP9xayOe2Ccc2mYqEDeLGDPvDDW9me3Bsj6lI2BeOmzrzbYPP7Qs+4Asn5wrsCyeCAtvCzbhiZneIue8eAtvDbY/F3LcPMbdNBLbJVKTpv6tSmW92inTGwYPZa4iAJz23x/+cr4uFzLcqeAkyedDZYxZ79Z/jkRidNzFv2ZuII5fTR1k3/wCrQ1wp4xIAAA==";
    final static private String hd_leftBracket = "H4sIAAAAAAAAAK2WTXOjIBjHvwrj7MG4sUGNeenUZqaH7mW3l73tjYmozIqkSN766Rcw2o2YzlI3GREBf/yfB/7qQ8rR8R5XBaq2OPVzzCgW/Ax0MyWcM+4XjJM3VglUJk6Gyho7V90HzAXZ9jsFPgkfcYzqxNlkS7DJVvIIoCzWDqgP+f2B4OMTOyUOBPrf3nje4cRh7ERLv8SZeOJo+xuLdk6WkoxgLqmrKIourZ3+HRJF4vxoZwpC8B2oSgR+gZ/gBQz1PIOXBsMY+4j0TZ0ifYuszFURd5DrzoUqlgNzXg/TGVkPM0LVFgZa3eNDE+XrHgnCqibmClGZp6xNW8Y43ZcocSip3JLlR5KKYiorBSZ5ISYSMruifAQN+tAYyp/X0WabDAIrYtgnksyF/hcIpnAqqzJwoK/UoS4mdoKjPl4J9GQCwSxQ0qEVbd6ndYF/hb5aHitaPEDTq+NtWe3uiOeGS61xIrWumprVBAsz+Ah4tdwH/wG+vKVepyK2S8VqSKkGLexA69srpFj2ixQYPmrjtMMYznn3TGhHMhzTkew4hjU+F5jhCTeeXzbWQp3u7CwWGK4YyTNM4Hb7/XNAY+OPFGjs/ZE8wwLjeKFhgJEJDA0r/LNA+QpOSwz+qvs7VhM1Qn0tbLrH/aWToyrH/tmn6ETonqrHSnBjBKmaEe9zNyM6Jf0vocc/oLIVFCIJAAA=";
    final static private String hd_rightBracket = "H4sIAAAAAAAAAK2W35OaMBDH/5UM0wfkTCUgqDfHOXMP7Ut7L/fWt4wEyBSIDfFX//omQbiDaKfR6gRDsn72u5td8Snl+PBI6gLXG5LCnLCKCH4CerminDMOC8bpb1YLXCZOhsuGOIPtPeGCbsabghwFxJzgJnF8sM6WcizkWDmg2eePe0oOL+yo9vS7+9ZpSxKHsWNVQk7zQrxwvPlJROeRpTSjhEvmMgzD82qvfotFkTjfNfGb9IWU4zn4Ad7AKzCWv4DXFsAYu8z4qoxDeVEDzdUl+kgY7sfqshh4GxqoFKDVVUCg1gKkdT0/tZH92mFBWd3GWeNKJifrcpUxXu1KnDgVrd2S5QeaimIqJwVRmZtIyGxA+RsUjaGRL19eT5utMx9YEYMxkWauDz/5YOpP5VQGDvSdGupmYic4HOOVQE8mEMyQku5b0eZjWh/4gw/V8VjRogs0fTrehjXulnpusNAaJ1Lrsp1ZOYjN4EPgNbIO/gN8MYb7D+ssAtAuo8tLEnUyY7tkrq4fjWLZnw4yGqg7HjuM0TK9MDuO0SjvTRfYkYyeuC0woxlcFAfnkorVx2e7UkBGP7jR/B6eUf7urSSj1u9UZlT9vakzqv8+gYFR+7emLjDK/5+VySdtWhLwYQ63rKHKQv1M6GdjV8rnfY7rnMATrPCRVrtKm12xoHVr8e6+tejFjP/rPP8BXDU5ogQJAAA=";
    final static private String hd_leftBrace = "H4sIAAAAAAAAAK2XTZOiMBCG/0qK2gODZgUCilPDWDWH3cvMXPa2t5QGSRUQF/Brf/0mRFFpnZ3IaNHk8+lOOm8ZnxYl3T6yIqXFnC3wkomc1eUeNc05L0tR4lSU/K8oaprFVkKzilkX3RtW1nze7azZrsa0ZLSKrVniESRNoMxEmdBC1Wb5uOFs+yJ2seWi5nucu1+x2BJil2c4Y0n9UtJ561QseMJZKbERIQSFrvwc+tplrGidxtZb6y5Cr+o1lmaqi640E/Qb/ULv6O3U8Hq1+AO9aw9CiI+c/DxNkYWpNL577vmi3/eU8S+a1C75wWnKpDMlVGZ8HvY1z35jotueVWTEPW8iKhji3/RMVGQkaHbi+Ulv9p81rbko9NYXNJcpS46ZSESZrzMaWzyxXfzNQ0N3KIueSpauq0dXHx4kcnTB/MiF13WhKQMXzxIXGaH8LirnhS1XjYYKZRYW6bLkPiPHG/lGlOBaRJlYbvmiToeykDK+TGuz0EIYGkFOCxvNksBs38bXs+wesjxLQtTU1KMqhhmewHgD5MySMRrpXBvRoi6tXbijsnwPcgoDjNBAKQWbgTygl2OuDc+NB1TRiNeZi8peccf2J1pqcrWRLpnhgVLUYp1KHs6voAPtHHehEbXnmZ1OD4hIBatRviEKSKc9PIOGhhXaDAnEc2/KgUyOIDPMbX2YcYAo7DA4HIuxen03k4YPpNGTBxRi30sCYrBxv9DA+e+5VCCAvgECGdit0u8DAhH0XDHQQk8eEEVPHhTHnSQCZdEvtwTqoh/vq9VBoDr6HT4C5fHZAOXNf5ExdFbGK1FxNaL5xW1uztZFf0mLJcN7nNMdz9e5GhbeGMELPeLkXo/4jHN1UY/+4/lw0zF1ftiJ7l/E538Ak7RSOw4AAA==";
    final static private String hd_rightBrace = "H4sIAAAAAAAAAK1XTXObMBT8KxqmB0JMjZABOxOHmRzaS5JLbr1pbGFrBpAr8Fd/fSWEIUa4jSD2IAtJ7Fu9fYvhcc3x8YHkW5yvyNrdEJaRkp9BNZxRzhl3t4zTPywvcbq0EpwWxLqaPhBe0lV3siSn0sWc4GJpeSBOYCCbmWxCCxSHzcOBkuMzO8np6nu58LwjS4uxU5a6nG625TPHqyYkW9OEEi5A5wghEHjiU881m9jhcru0XivUFxkwEs1CdaFoIvALvIM38NoOvPR2f4A3hc0Y64f/2S6OE1/u04cfY17P+7JBV0MyIX7QXgK7mKFsWsZ60LlsFjeDIkkKwashyUMk72ZQJFmhoNr/06NK7u89LinLVapznAmNkkvmE8azfYqXFk1sz/0GwcSbiC6U4qhzeajTuzsBOb3C/FcI2A2hUO49N048YATld6Eymtti12AiocxooS6W0AA4cOobocz6GKVsc6TrcjsRnS2RBjCjFujUEHAasGmczMzyFvar7NUqx0kAqjN5yBNDhSOd7ww4cRKCqdLaCG3eRWs27kiVh0AudIJzUBVgZJZIqPmlITcITvPGpXQMyxBqzqjuBc6KFfaOOrYfKeeK5M1Vzwy+xywRcApR61+BrpnIuxf0feCaqQx7fBMpmSEyFEZzTKtzhTZAa80lQ7XuM0gFZAajmaLZotk9WbOEDUO/LohQ/nw3k9HXTGEHszF4mjfspk6HAWpusN1xDDUDjE2h5oSxDDU/2EORNBuMVFdzw9jcab4YRxD1+GNU+SHdH+PERT0GGZVC9NUGQbpBhiLpzvgsM/HusE4J+NB3d6ygckX1dysfuy/FXc9znG+Ie3YzfKLZPpPLghsraK5WtOHVik8Gl68Q8/8Erx+cTOPXyei+Xz79BXt/kkB4DgAA";
    final static private String hd_squareTabs = "H4sIAAAAAAAAAJWTQW+DIBTHvwrhtNkY0eqlKW2y87rTTruxikKC0gJVu08/BHWtMUsMIfzz3uP3/o+Efa5Iu6M1I/WZ5mFJZUWNugMXrrhSUoVMKv4ja0MEhgURmsKndEOV4ed50tDOhERRojE8FjHwe2t3AoFuyl3DafsmOwwRcGu8d79QDKXsKhHq680SPsm3HpKTzwsxDMOTu/nu2AiMXbz6Ah/g5HQyVPTKn6mLp0NN78pTMhfPHrzGDzUjKRtImWP4jGPBw967tLYNl7X3XJPKDlSM8xVSVTdBMNRXZV6ELFueGxaMYmMFo7xkJpjUBgXo1cKjJ/p/zeJ5szg4FghECVqFSeYY9Gcv7B9nFW27SHNTr4elc9hkbBUmW8A4RwuUaPmrHH4Bi7vlLEMDAAA=";
    final static private String hd_cornerTabs = "H4sIAAAAAAAAAJWTQW+DIACF/wrhtNoY0eqlKTXZed1pp92YgpAotEjV7tdPQd1qzBJjiA9e3seDhFOuSXukkhOZ0dwvqKqo0Q9glyuhtdI+V1p8K2lIiSEjZU3hk91QbUS2NA3tjE80JTWGKQuBG4d+RBDUTXFsBG1fVYchAvabco8rxVCprir9TGlJ9Qf5qkdz7nklhmN4sck3yx7U8P8E7+BidTQ6KYvtPB69oYVLJXY9+ZNzs2h0h4zrbLPwfHItbndihJKukyRVX5hN/ZnS1b0kGNY3bV5KVbQiN9ybxL4XnIqCG29We+ShXQ8Pnuj/bRYuNwu9lCEQRGgTJlpi0G89f7iUTbTDKs2eejssXsLmYpswyQrGNlqhBOtP4fwDCW7hDiMDAAA=";
    final static private String hd_plaqueTabs = "H4sIAAAAAAAAAK2VS3OCMBDHv0omJ8WhJCD4GNGZXnppe+qpt6jhMQNEQ3z10zcEUQmOLaUwC5ndzW//2UkmszUnhynNIpKt6NoMKUup4Ceg3GnMOeNmxHj8xTJBEh8GJMkprIX3lIt4pQcFPQqTcEpyHy4CDEpzpNkQ5Ptwuo/p4ZkdfYiAeqt5pw31IWPHNDE3Cdnu6AdZ5ufgReeGiMiHb2rmq2Ij8AneQeGRFaSv+A/PvkXgnvNclVt5HZVT+VV2WYgx9rjWC7iuyZM2qlW/jY6lTX7Qc5uPi0Ssa6xl2MXH0XTPZ2WHtjsiYpaV/cpIKpsZVL0NGE93CfFhvuWil7DwEK9FZFSDgRxENA4jYVxGA2SgvoRbNfqjYlgvho1FgIBlo1YYW8egqzyzaEQrmnOXplbdHjbUYRdhrTDuHYxS1Iri6ZQe6lseks9Tu4aPGiB3WGD+iBs3cNizO/Am/ysPN85ER15j23fkNfZ/D6NxF2DjCPxGoHX/eph/A49RlHQ3BgAA";
    final static private String hd_pieWedge = "H4sIAAAAAAAAAK2UW2uDMBiG/0rIletwGu2Z2sJudrPtdrC7UD81oH4upq3dr1+sWOghHQGVTyWH533U6CqW/LCEMuPlFmI3BSxAySM5NRdCSpRuhlL8Yql4HtGE5zXQi+49SCW2150KGuVyCbyO6CYJyCYJdY11zSip9+lyL+Dwik1EfXLa+3nHCiKK2BS5Wwn4gjjtkWfLiqssoh96lqaR955LvslnNxQRTaPf9HGua6GLtU2MXRHWqy7tZ8eVwLLLLnmhtZLeMkFZ7HIe0RzTg4hVNtpi7VRi5LBw4rfbk8f8eXelid4F8lECu5OQgUgzNapFOUhEYLqJ503iE9e3goVGX01jtrSxSc2KMjE6eYEVaGrSseTMjEJWmPkgT2cxjAy7+Rac83L0pu3pxe7ds5ul70zG//K8+z+w9R/Fj6Rb2QQAAA==";
    final static private String hd_chartPlus = "H4sIAAAAAAAAAG2QOwvCMBCA/8qRPZiCXUrTwcHJFsHNLbbRBNpeSdLnrzcpVVE8jnt93INLKyPGRLZKtKWs6ENiI52ZYS032hg0VKHRC7ZO1JzcRW0l+cKDNE6XPxARE9vf6KDlSK1eJCcRg5cSsMMjCeyAEycMGOxZkM1tC9zc+T7EqalpqYRx57q3G3uf3AmnOMkh9kNO3voFuQ9jn0TBHaFYC4F+LgjK4AoXKEiW7v5/IXsCSQySXR4BAAA=";
    final static private String hd_chartX = "H4sIAAAAAAAAAG2QTQvCMAyG/0rovVjB01h38OBJd/Ei3upW18K2jLTu69drtVMUQyC8ecibkLQkNSS6NaotdMkrjY32NMGz3VgiJG6Q7IytV7VkV1U7zb5wr8nb4gciYuJuF95bPXBnZy3ZWsCSDFxfJYFtcZRMgICNCBFLXOCn7jGHODY1L4wif4rgfW+nvJHsAMFhH+2DWkcpYAc5LPxzwIud4Qg5y9LV/ydkd20BPLQdAQAA";
    final static private String hd_rect = "H4sIAAAAAAAAAJWRwQrCMAyGX6X0PqbzJlbBs/oA3sKWrYW20Sxu06d3bCooU5BSKPn5viR0VTC0S4wWYo5FUiEFFL6qoRwcM3Fiid2NooA3ugRfo36LG2Rx+Wco2EkCjFAbPVMztSkX/c20qptq2Thst9SNSX+ezPWERhN1wSeMuTzKr+lOINbo/cDsBuPLO7wydVQHvV6N1PkC4iiOjgihV5fPTiVxuHgw2lPVukJsmvVc+gb+8swnPBZdZeVPUfZV9Jdm8W2vCUs6/eXrO8ipjHsLAgAA";
    final static private String hd_roundRect = "H4sIAAAAAAAAAKWWUZOaMBCA/0om0we8Sk1QUG+Oc+Ze+tL2oY99y0iAzEDixahcf32TIFZIdRqBybJhN9/uZjbiSybJ6ZnykvAtzcKCipoq+QHs65pJKWRYCsl+C65IlcKcVHsKe+YjlYpth0ZFGxUSSck+hZs8Bu1I9FhCsD8Wz0dGT2+iSSEC9u7WfexoCoVo6iqU4sCzn3SruoAiYzmjUiNxkiTL8+tL9juiyhR+17RNHoFvWs61bp4Ya7GwamSmCPwCP9rlQohbhK9nd7vEivmF2rMtjIivI/XMpmq8vI7eM6+MWNuMXl/ait4PRDHB2/o4qfWW5N0O5ULWh4qkkOUBCj8hMEVTrcZIX3Zqhp1NJho46xHvBcDDADXjQSWKE8tUOdVKSVlRKj9oNITqWsHTJkdghk2OyIs2H9K69D6j0OymF2zxD1hb4iO02C00Ak/ROlqtH6k0uVtp7Jfb8n6lnrTVrdRmkRdnfTMrTxB2jsaF5MdxTkBXmR/G6fkAo5VtgcksMY8vfr2AnbYP4sUYntP5AU6iMUCn+Ucm6HR/8CjJaf2RmTnNP5LnHIL/5ulPVlZRcKWHO7FnxqP98elOxdkoCS9o2IQ1aVh9qFNovxE3fBhvff5Gbz0uuQz/Mbz+AQkM/2JKCAAA";
    final static private String hd_snip1Rect = "H4sIAAAAAAAAAJWU32+DIBDH/xVC9tBfpGhbO5vaJnve9rDHvZEKSiLgkLZ2f/1Aa7e6uQTNReCOz331OLepJucNlTmRB5qijCpBjb6AZllwrZVGudL8U0lDigQyUlQU3rlPVBt+6DsNrQ0impIqgRjs2dLayloMQXXKNidOz0+qdr7m7nZdSppApWpRoEryMnijB9OlUylnnGoLDKIoWl+Xb9pLYvIEvjS8Z5tpAVzeyFp4fcbNSgzewSvcbdvdH0diuJItSxJh07NODVNaHAuSQM5GGD1gMMMzO1xhezVTZ81sPLbA+R3xvwRBP4HgclSo7MxTk8/sIKc8y40fNOxD9ywAkz3DYB44jdiLtujTOnlTjNwX9YItf0sLwSSYh16UVZ8yckWedsLGnrho6A29KOs/KG31POU8Dsnx5MSDgoYwtn/SgoIfY1SqirsIV6nFrTuvTk1kRlGNBKm5OIoENi0wEMNlG/N9+tqIm5b+r2f3BQeuGWKTBAAA";
    final static private String hd_snip2SameRect = "H4sIAAAAAAAAALWVy27jIBiFXwWhWaStUbATO21V11LX01nM7GaHYrCRbEgxSdx5+nKp00nsVCVSE4G5+TsH/AMPpSL7eypqIta0RBWVLdXqFbjmlislFaql4v+k0KTJISNNR+FR944qzdennZr2GhFFSZfDgsUYmCyxWWyzBQTdrrrfcbp/kn0OMXD/4d3XDc2hlH3boE7wTfKHtPQ3XetBWJaccaoMOs6ybHV48TCPDdF1Dp+N1MJwf5rnEjgLqWt6L6xMymxlabLUF7Brx27YX/ALPj548suWaC6F1xHGj5nuIMukarcNySFnM4x+YBDhyBRTbH6uapOrXV0Z4PyI+JlAPC0QHwuYqk2XCCSnAi0Xs0ZWe17qOjKFmvKq1mHQxSm0YAm4LhgG89h6xEG05SltsHeDkf1IQbD0jLX4ImvZp9bSMGurCZhf/Utot+OJLsAloLuJECzYLYgsMLK4wJAebZqC3YHreJ6EYUZb42jtzXkThhttBDu9cFej0J/Z0+TmYyOFAqei36PCOKPAH5YrDDMV8d5O6MSmwt0ZOg8yZ3vZUPBfGW1kx+0I+72Wh2vgvVMRUVHUo5b0vN22OXQn5JkxXPgxHyeAH/E1bX95fIv8fPqGfnwDNn1WNboHAAA=";
    final static private String hd_snip2DiagRect = "H4sIAAAAAAAAALWVXW/bIBSG/wpCu2g7o4Dd2G1VN9K0y24Xu+wdisFGMpBhkrj79QW7XuvYjkakJeLLHD/vOeQc8lgYenxgqqJqywpUMi2ZNa+geyyFMdqgShvxRytL6xxyWjcMjrYPzFixPd20rLWIGkabHG44IWDoYt8lEDSH8uEg2PGbbnOIQfcd3n3dsRxq3coaNUrs4u+Clr/Y1g7CuhBcMNP4F0maptn7xt84dtRWOfzhpBLHfXZj5kYnfOu6dJisXfMjyYanvdVd1yfgBfyET489+feeWqFVr6OodA7ywV+ujdzXNIeCX2H0BYMIR266xu7TLX3rVtfXDrgaEc8JkHkBMhZwS98uEYhPBaRQV7Uuj6KwVeQmFRNlZcOgySl0w2Nws+EYrIj3EQfRbk9pg3tfMfI/UhBsPQPrQ7yEli4ESi4KNDsbaBrm2t35QANp99NAE3AJiMyVzIbfg8gTI88LrJBJibjjx+CGrOIwzqQSRqfvrq4w3KQGxucfzFusgjDMcv6Hntck9weHQkFzad+7tMRxd3xRM/Bpjna6Ed6iz8whyd43DVUlQy2StBVyL3PY3ZQLNkL1Nh+121v8m3b2n7RX83/TT2/aFnCdvwcAAA==";
    final static private String hd_snipRoundRect = "H4sIAAAAAAAAALWVQXOjIBTHvwrj7MG0YRUTTdKpzUwvvezuoce9MRGUGYEsksT20xchdjea7JR0qvN4IPj7v6cPvS8UPtwRUWGxIQUsieREqxdgL3OmlFSwkoq9SqFxnQcU1w0JTqb3RGm2GU5q0mqIFcFNHqxpBpwtjCEUgGZf3u0ZOTzKNg9iYM/+xpctyQMpW17DRrDts9yJ4plsdK8qC0YZUYaLsixbANseJ98T2WJd5cFPIzcz7B/Gp8av6dLY/OgRspeObgZ+g18OI6X8HOnJts5Q0jWO/nDvovyzw5pJ4WIWmJuEaZ8/lYrvapwHjIYx/BaDaTw13TQ2hx12ZkeTiQFGJ8T/CaDzAuhUwAw7u0YgGQpwJsJalgdW6GpqOhVhZaX9oLMhdE0TcLOmMYhQF2PsRZtfoKGraOmQ1id7G8OuOLxg2Ti0GbhJVslydU1siyEu7Ar3to9wEiVeuOWlVL0oqzMUVxSe4aDRbunj8QWNdsV7SH6cUfGHKF7a1zaJss5993t/aFT4YTr/GM98uIqagH/6cCsb1q1wVdU/vOOkwqIksIUct4zveB7YzX9hDRNuzV91t+Jj2ukXaUfnf2MPbzlHc9PfBgAA";
    final static private String hd_round1Rect = "H4sIAAAAAAAAAJ2US3OCMBDHv0qG6QFbUxNUREd0ppde2h567C0jATJDEhuCYj99w8tWfExTmEwSdve3/yWPZaTIfkFFSsSGRjChklOtDqD+zJlSUsFUKvYlhSZZ6MQky6lzYt5Rpdmmb9S01JAoSvLQQQCBdTw1LXBAvksWO0b3T7JsLObtYg5bGjpSljyDShYiwu90o7tsMmIxo8rwsO/7s/bzUfqW6DR0Xmvgi0k1bvt5lbYWEIAP8NaESSlvRz6b3msbroIxvkhbLRsVnwXRTIpGkyDc1BF3ZcVS8SIjocNiF8E7BIZoaIZTZJ56WrV6NhgY4OiEeCsB7ifgTLiZTPYs0unQDFLKklTbQb0+1NQO7tcxAiNcaURWtHGf1sl7QLD6u1awybk0D9x7cy+Y/0fb9Ka2iZ02/xps5FlxZhc4zTJagoKrICvM/Fpddjv17Cy42PfqJRuM/Kp7tFs7fLb33enkbzxz6qOMgl9juJU5qzyqHTU+XketURGRUFhCTkrGCx469VG94sNE4/OTvfE4aunftKtvcPfqUIIFAAA=";
    final static private String hd_round2SameRect = "H4sIAAAAAAAAALWWXZObIBSG/wrj9MJs4waImmRn3cz0Zm/aXrR3vWMiKjMqWWI+tr++fMQ0Bne76DQZEAI+5+VwDuExFeT4QOuC1BuaBjnlFW3EK9A/V0wILoKCC/ab1w0pEy8j5Y56neEDFQ3b3A429NQERFCyS7x1hhBYZytZEFbV3AO7Q/5wYPT4hZ8SDwL9bV993dLE4/xUlYHg+zrFP0lFf9BN0xrmKcsYFRKN4jheXN68rGNLmiLxvklbcwn+Kp/h+YkiWS10U7VQKJtQz/sFvhsM5/xfpGfdNwUtVbW6pj+f6apgRcfo2mJnWDkEzy8qrsk4VFWklT09mhW+7EnDeG3WW0u/SLe3y8+4qPYlSTyW+TD4BMEUTmUzgvKju6ro3mQigbMO8T0DqN8A6hqQXVWGGMC3BipW+yXPjyxtiqlsFJTlReMGnd9CpTPB3TqDYIaURuhEC29prbzPMFDb5QSL3pCGBkmL35UWuUlb9MCM94fQlvZC52AIaNUHusMrvFwNcRmyckYpGsHrS5F1tgRTde7JCkHgmHNWTnR2VZ6objgrG7r7KvW58frywfDcOFYqtMt0w/TlgJEzw26kvgTQglxBVuz7KMY6tCazWD3uHWPMygE/CkfwsJUD/lCSFf0jlVmxP5JnBf9InhX8PoLLMUArCz4sUN5T0pKCq3aw5TumZqhDLbxcjs6DgtQ5DU5BRU6s2leJp/+v35jDajPnr3Uz42O2zXXnv5if9d9bn/4A+kZt8dAKAAA=";
    final static private String hd_round2DiagRect = "H4sIAAAAAAAAALWWTY+bMBCG/4qFeiDbULAJBFbLRqoq7aXtocferGDAEuDUIQnbX1/bBBpisl0HNZG/YvuZd+wZwlPK8emR1AWutyR1csIq0vBXoH6uKOeMOwXj9DerG1wmVobLPbFG00fCG7q9nmxI2ziYE7xPrE0GIegrJCvfAvtj/nik5PSZtYnlAfXt977uSGIx1lalw9mhTtEXivMfZNv0lllKM0q4YMMwDNfDzsGRHW6KxPombPkC/FW04bmFK1GtVDeQw7XoemrdT/C9wzDG/kV6OW9XiEhW8SX9RS3vCpJ0BC8tXu5G8kCQP6gYbZU0FChlz0+dh78OuKGs7vytcSVOKuvdzxivDiVOLJrZnvPBA0tvKbqBJz5qKIsaLRYC6I6IbxmA0wbg2IAYynKPAXRtoKK1XbL8RNOmWIpOQWheNGZQ/xoqDhM8bDIPuFBq9Ixoq2vaoOqj58j7MqIFN7TBu7SFE9rU0SlpgZm09duOGtIi3VEfPKAYRfE9nsY6LpiBg1rqbLIIKD9jMz/hVI6I+xQZJ5FLCTRMOi0pRrcqHqdmOC0dxvdqzJtKCCXPDKNlwiDLRWakm1lgCrqdAWYcLfZtGCIVpAs3lM0nw2jVot8OVjN4SIt++16SFv0zlWmxP5OnBf9Mnhb8NvSiOUAtDd4tULyopCUBF31nx/ZUruietv0tnyc5rnPitE6FW1odqsRSf9g31tC6W/PXerfifbbD/2TbnX5tff4DMEHWns8KAAA=";
    final static private String hd_rightArrow = "H4sIAAAAAAAAAJ2V3U7CMBTHX6VpvFCk2TpAxDgXvVYfwLvGtVuTdcVSYPj09mND2YaxQtq0PeX3P+ds53CfK7K/o3VJ6neao4JKQbU6AHcsuFJSoVIq/ilrTaoUMlJtKDwx76jS/L1v1LTRiChKNimMQcZuzcCJmVYQbHbF3Y7T/ZNsrNF9u58d1jSFUjaiQooXpX40GvtOUOaccaoMchGbD3BzazzGsCa6TOEL8KrPZl60+gt3hudmWrbHeNYuVs62Am/gFT7ce+LHlmgua8+viTCesU6OSSW2FUmh4PVlJYs9z3U5NYuSWrevDCQ6ofwGxX0otoHFk44bZSwGQcSkT+TsMkYXMZjGU7P0fLe3w2+vwpyejUvgVsLkFridHXYTiJ/38TYHk4zNQOTdDaIt+rQutdcxytg8LLk3IzD/2I1/CYiScP+WZ5FREgS6HaZtCVyQN2FBrkZBFoPCQsODkvlvbHhQJ7auJ/b5mQrBgSWCBzViO4GJEOPgEAe1cAwxjDN46bvX9BzG9Ly8ouDHGq3lhtsbbd+FJ0ZF6oKiAxKk4WIruk5z5hKv/aXvbPgbfxF37XaM23yLZ8fO179xXjka/8d6+AKB3N48ygYAAA==";
    final static private String hd_leftArrow = "H4sIAAAAAAAAAJ2VUW/aMBDHv8rJ2kNLsWIHUtqqabQ9b/sAe7MaO7EUx8wYCPv0sx0CJYFqHsjG5o7fnc/5H6+lYfsX3tasfeclrrhW3JoDhK+VNEYbXGsj/+jWsiZHgjUbji7MO26sfB8bLe8sZoazTY4KQVMoxJMbdOGmZwSbXfWyk3z/TXc5IhDewy8Pa54jrTvV4IYL+9VF2Q8hdSmF5MZBM+JeEOaj8XSKNbN1jn44ZiFW8N3NWVhnH5M4Z3O0DJ90Cb/gJ3p77aG/t8xK3fYhWqZcbmKIKLRR24blSMn2rtHVXpa2nrtFzWVV23sHSS4on0HpGEr92chs4CaFIBBFTMdEKe4I/kJgTuZu2fPD3o9+ex+X9OJ6CHoM4aoJYeeH30Til2O8r8GsEAtI+nSjaNmYRh4KsQQcR3kcU0737RJLIUnjE1vdRCZpFOhpWq8VPBBciMe4R+f5KshjIqtFJ1r537PRiUC8iGf+Bp00aKQ26EQcXv2hVJRGoiYiGCQbh5k87KdK3eK4flc2HD6s8VpvpPcIXTf0OXRhN6ytOD5gxTqptmroMjecZNs7ne+89/i3+Blc5Xbn4MWp6409bkdOrv9lvf0FcXxSP8sGAAA=";
    final static private String hd_upArrow = "H4sIAAAAAAAAAJ2VUW/bIBDHv8oJ7aFNgwxO3LRVXat73vYB9oZqsJGMSQlJnH36AY7d1U6mMVtGh7n8/sfhuzyXhh2feFuz9o2XuOJacWtOEF4raYw2uNZG/tKtZU2OBGt2HH1aPnBj5dt00fLOYmY42+WoEA9QCJq64dEbKwS7Q/V0kPz4VXc5IhDu4ZenLc+R1p1q8H776jSOg6AupZDcOGRG3AVhPC+Oe9gyW+fouyMWIoNvbtwEm67Diz6GbIwFztENRgY/4Qd6ee6h73tmpW57iZYpF5kYFIU2at+wHCnZ3jS6OsrS1ktn1FxWtb11kOQT5W9QOoVSvzeyGHFJIQhEIdMpUoobgr8QWJKlM3uBMPdPP72Ni3p1WYKeJVxaIcz84yeR+PUU73OwKMQKkj7cKFo2pZG7QqwBx1Hup5Th5F1cKSRpfFyba8QkjeI8zLO1gTuCC3Ef9+E8XgR5TGSu6KxU/nNrdFYevlgX/vhcXdDIwqCzyvBlHzJFaSRqVgFjwcZxZp/6kKlrGNftyobDHzbe6p30HmPHHYI7rxvWVhx3WLFOqr0aeswVJ9n2Th9H3nv8i37ovZe4pw/xYux5U4/rysnlv6uX3ypaG9zHBgAA";
    final static private String hd_downArrow = "H4sIAAAAAAAAAJ2VUW/bIBDHvwpCe2izIIOTNG1V1+qet32AvaEabCQDGSGx008/wLHT2M40lojoMJff/+7CXV4KQ5tnpiqq3lmBSqYls+YEwmMpjNEGVdqID60srTPIab1n8Or4yIwV7+NDy1qLqGF0n8GcPwIMcv7kFkkh2B/L56NgzTfdZhCD8O6/dtqxDGrdyhoVulFvTqLp9XQhuGDGETfYvUD4PB8OKeyorTL4IwhuwHfgxb11CaIPxT8j67Ox9ZsV+AV+wteXjvj7QK3QquMrKl1gvJfj2shDTTMohbqrddmIwlZLZ1RMlJW9d5DkivI3KBlDiU8MLwZcknMMopDpGCn4HUZfMFjipTM7gbD3q9vex0W9mpcgZwlXThB2fvlNJH49xvsaLHK+AkkXbhRtM6YNtf2KUc7XcdV9mKGFG+DiS0GSxse3vUVM0ijO47RqWxBSfIhL8WkW5DEoLjMyaZn/TI1M2sS39ML/eK4/SGSDkEmH+DngEiQkOsNJJwyXK44zufJ9pW5h3MgragY+2Win98J7nKcuvDo0VJUMtUjSVsiD7AfNDSehOqdLNTqPfxEP03eOe7qI58PgG3vcVk7m/69e/wB/s2nXyAYAAA==";
    final static private String hd_leftRightArrow = "H4sIAAAAAAAAAJ2VW3OjIBSA/wrD7EOahlGMaZJOrdM+b/uwj/vGVFBmRFJCEtNfv1w0bdXsLKsDHuDkOxc45KFQ5HRPm4o0b7RAJZWCanUGblpwpaRClVT8Qzaa1BlkpN5T+G35SJXmb8NFTVuNiKJkn8Gc4QTkbGMaXppuC8H+WN4fOT09yzaDMXBv/8vzjmZQylbUqKZM/+JlpZ+MqVNvVxaccaoMeRWbB7i+W7yEsiO6yuCLAedsDX6aPnVy2nmyunztLE6dmp/Gq07Ydvr91yz8Bq/w8cGbej8QzWXjDTdEGLdZ7weTShxqkkHBm1ktyxMvdLUwQkVtPDcGEn2j/A2Kh1AX8bzHRjmLQRAwGQI5m8XoRwwW8cKI2OL92DY/vAnzeTltAncmTDKBG9lmB4H4dIi3OZjnbAki724QbTWk9am9jZHd+iDY3QTM77rxLwFREu7f+ioySoJAm3Ha1sAFeRcW5HYSZDEoLDQ8qpj/jQ2PysRW+Nzun6kQHFgieFQjFuRShXEgalQL9nq5daDQbI3OfX9SwzBTB94n/RrHXKtFTcEXGe3knlsNH09+OVzdsiJNSdEZCdJycRAZ7ApzWok3XukzH17j38ynYJLbfhrPL7foUOO65Wj63/HxD1lW/fg2BwAA";
    final static private String hd_upDownArrow = "H4sIAAAAAAAAAJ2V3W7bIBSAXwWhXbRpkI0TJ2lV1+q0y20PsDtUg41kICUkdvb0AxwnrX+msUTGHJ/j7/yYA8+FJs0TlRWRb7RAJVWCGn0G/rHgWiuNKqX5byUNqTPISH2g8JP6RLXhb0Oloa1BRFNyyGDOdiBnOLHDo5usIDicyqcTp81X1WYwBv7fv3ne0wwq1YoaHfffVCNfrZ+md6oKzjjVFpvG9gf8eFFe89gTU2Xwh6XmbA2+23Hr53jjH3Rx9Pe0V6TezgqpN3bi7sN9DX6Bn/DluXP1fiSGK9k5lkTYmFkfB1NaHGuSQcHlXa3KhhemWtpJRXlZmXsLiT5R/gbFQ6jPeHGlRTmLQRAxGRI5u4vRlxgs46WdYsfvZHd14n1Y0KtpF/jiwtYYeMldTgjEr4d4V4NFzlYg6sINoqVD2rW2DzFy3z2Itpmg+QVg40tAlITHt50jRkkQZzeu2hb4FDdhKT5OghwGhWWGRx3zn6nhUZe4nl24j2f7Awc2CB51iAP5SmEciBp1gttQHjwotFijVX/bAwKrNb/iwziza30OY/fnoqbgwxzt1YE7i/6c6GO7qDWRJUUtEqTl4igyeGnwaSMuO6NbZTuLf3HvD4sp7vnmPL9ux0OLec/R9Bn78gdC57YKfAcAAA==";
    final static private String hd_quadArrow = "H4sIAAAAAAAAALVW247bIBD9FWT1YTeNZcC5rtYbbZ/bfkDf0BrHSLZJiZM4+/XlEpw44KpEqiI7Awxn5gxnLF5zQU4vtClJ80HzeEt5TVtxBnq6ZkJwEZdcsE/etKTKooJUexoNlo9UtOzjfrGlXRsTQck+izYFxmBToLV84VS9YAT2x+3LkdHTN95lEQT6Z/eedzSLOO/qKv59IPm7jHOyQXnOCkaFhMV4DiG4eV9cejY70pZZ9EMiy+AL8F3+LZW5tIZKCKUDS8/Di7E2W5Gdn90aZs98aKlVPDPx7NzKWhjavTcWshG0pUs0tzmYxXRo2eR6Qwb4BX5Gb6+GvaxYy3hjatGQWpaysKUpuKgPFckiVjzB+AsCUziVpqwdNEP16NHzswRMBoh/C4DuA2wKCCY4QUEo2J8mvKQpqQI9Uo8aBCaZ3sMjxRR+hbECC4KauXxTMEEJDkKZ+/ninu8M6JF61CCQ7+IevmbNU8W3J5a35VQaJWXbsg0DXbrMF2CyKeYgMeUMQluNoMGH0Nb3aJZs4Lkgp19UZ2qdrMJ0gjyNIZEUThzGDTnNcSkVBgkOLxVymqGniHAgR08zaI4SKJSk0xH2BHVmy8DEnAboNR8qCI/q5Rf+IUV4JK+gHpGEo/drVqGHiD2SN2mFnyJ2RN/X/ZFjxB7ly6QmCigJrj92hD+QGA6tmyN+CxcG4xO+KdkYjrzk5BUFN3a843umPHSF9G0mGqwL0mxp3MU16Vh9qLXbiAdrjMf15I3HPwa/XubGQutbxn8Jru9fXubnW+azEY/x4In/svz2ByTry+pFCwAA";
    final static private String hd_leftRightUpArrow = "H4sIAAAAAAAAALVW246bMBD9FQv1YTcNwnYgl9WyUfvc9qFSX/pmLQYsAU4dkpB+fX0BEjBUdaQqgoxvZ+bMzEn8mghyeaFVTqp3mvgZ5SWtxRXo6ZIJwYWfc8F+86omReylpDhSb7B8pqJm7+PFmja1TwQlx9jbpxiBfYp28oWxekEPHM/Zy5nRy2fexB4E+tOdvR5o7HHelIVf0LT+zrK8/nH4JN1dOt88YSmjQqLjCEII7t7tlp7UgdR57H2VDmQMW/BFfm2UuekMFRdaDSw9D1tjZ46ibj68N8yZaGipVbwy/to5HPZWh3szQvATfPPeXk3gv06kZrwyNCpSymSkHauUi/JUkNhj6RP0PyCwhEtpKt5mqB49en6WgMEA8W8O0NjBPoVggQPkhIKnw4RtmDIDQI/UowaOQa7G8EgxhR+hr8CcoEKb7wosUICdUKJpvrjnGwI9Uo8aOPJdj+FLVj0VPLuwpM6X0sip0oYb6MZmvgaLfRqBwKTTCW07gwYfQtuN0TqyjnVBll6UjHWfbN36BE0IQyIpHN+NG7LE0aYKgwC7pwpZYugpIuzIcUIMmqMEciVpKaKroI5s4xiYJYBbd0XuGbM6v1eQSdvaMTqr94d4rp1mNb/+/3ioonii/xXWIyXFEwqQKAtVzcCZJbZUMGgQ7Pgzji0VdHBuMJYC+lLO4cjbRVJQcGf7B35kaofOkL5GeIN1QaqM+o1fkoaVp1Jvm9nBKrPjViqz4x+d3y5Tc66NfP6HczzL/HrPPJzZMe88mL6svv0BJTeF48UKAAA=";
    final static private String hd_bentArrow = "H4sIAAAAAAAAAKVXXbPaIBD9K0ymD/EjFTCJeud6M+1LX9r+gL7RKzHMJMHG+NVf3wWMXiWpouOAi5CzZ5c9AV8XFdu98DJj5TtfBEsuC15XB6R/LkRVySrIZCX+yrJm+dxLWb7m3sX0lle1eL+erPm+DljF2XruYYRRktJIdaGH1tvly1bw3Ve5N3PwaZ46rPjck3Jf5MFvXtZfwMOucScXIhW8AkAaYYzRxz4cT6IG5BTNitXZ3PthvIfouzEoGElKZtBNjXFiFzcTlJwsNUmmxlIPmijQL/TTuJNS3vb4TYFETUeVHzp5nIeGmzQd1b/Ortm9vZps/NmwWsjS5KZkBSQ4bVKVyqrY5GzuidTHwSeChngIpkqpGaqmR70eAI4uEP/ngFw7SFKM+nREnFBoO018pAnxIz1STQ0cSY7b4ellFmCo2iNZCK8dFKL0c7nciUWdDcHIuFhmtRtoZKc2RH3YdjQiiiN2Qos70PBDaBMbLUJ9MqJOKFMbJUYDHCTpBDkBzTqCGz8UHLFU02yl5jZz40YsiZzqQcNNHeEsrahaA1EYaYA23OAsbZiEQfIIFJrKoxueJQWjtfFZymOkh6rpkesbp0sXJHxst1uUAW9vvTeRY/CWLAq2VyHHEL1jlC3aAFL6JAgcA7TU8Uw5U0scqoQHip0jL9pydsCZN1B4rlCWKI6kiDsrSxANK/fMU0sMJ+m74Vgl3+ygG4xV6T7BU62Y3ihWX58d47Pq3Y/CZ/CsovdJTJ8BtErfD+5lCDe9Rc7RBztYybVQK4wYk/P+HucrVi55sA9A9aLYFPpN0rFClGbF2b1ZcZ9zc8VuxT6cveubTMea5/yrO+yN0DudPx08aPqW8+R8rt3v+1gF13+R3v4BdKiuEzsNAAA=";
    final static private String hd_uturnArrow = "H4sIAAAAAAAAALVY23KbMBD9FQ3TB2KbogsXk4njaV/60vYD+sbEYGvGoBTj2OnXVythbCycRDCxByGBfHaPds8K/LCq0sN9Vm7S8ilbeetMFFldvSJ1ueBVJSpvIyr+T5R1ul04ebrdZU7n9ktW1fzp+madHWsvrbJ0t3AwwmiZswAa5qDdy/r+hWeH7+Ko78nv6Vevz9nCEeJYbL19va/Kb9LE4WRPrHjOs0oi0hBjjC7bgMUhRjH0m+ktqee03iycX9oJhn6qDoWOHIN16JA5NPHJT9Wj0JAQeu1dmnR6NFK/lid5lWgkou38Qb+1J0KI9535oU9Nw8Aoi84uXt1Wfs5HOq4ww1PD4GqAO3S6MwIgFlCD5OODXu+/+7TmotSrX6aFjGR+CkYuqmK/TRcOz13sfSFohmeyq2KnhnCo0d2dBPQ7iG8ZINcGljlGE+oTKxTa7yZu3JR8kRrBAQNLJ9k1fMFLdyvWB76qNzPZ2WR8vantQAOTOUUTGRXkt4hWgOE1IMHwmWJPhh1ZQUWmbyGatG754KUVYNwfINoGKEJqBAcMLAM0N/2N0RQW1MNWQIkJNB8VFNKnoGWeSLoBUE0Q8NeRUpfg0ENbJfVIiYHvFPka0A7O0FQDh4fBGRpSRWhCfGqH0yMbQpFKcmKZlMRQTBtjyZMMJNqjHbVu8TA4QzlqZ9B8I0u+hkxONUzDWRYJ0iMWuZtZh5QaEoHyKrESVaxjZKcD2qMDKvcUvfj2pYve2FxYW7so7C5yCIcaWSqX9mhDK3eYdGnf1sKanCGW7A2NFOkROMsyhS1p9ihDujNVjyeWdZoasuimMrVk2bOByIewYVg9spCPcVMlMEuazJCGkpjyi1rmMevTRdJghZZYhibcNpYJurMsAMzI/2F7LTPy/pQUdjBGysv9ea63ZD+C01fLKBqJ74bBGDwj+V0S0TGARvqPdNCQgDsQKTAE4HqjXAsMFYxcu8CUwoc9lO+Uq22GLvres9hxmNEUx+VZHM2EKi3XmXf0ZBnmxb5Q827M4KWecbavZ3zMunr1fNc6vXhj/wT77eNPB/v1kn10Y8ZI6wzdonU2TT9n5fUfAeE7zJsHg7fJyxcMw4UmFa//M3r8DxIBBg5MEgAA";
    final static private String hd_leftUpArrow = "H4sIAAAAAAAAAKWW35OaMBDH/5VMpg/qyZBEObyb45z2ue1bX+4tcwbIDBAbUbF/ffNDVAi2F24cwq4sn/1uwgZeNpIen1mV0+qdbYKMiZLV8gTM3yWXUsggF5L/EVVNiwSmtNgx2Ll8YLLm7/2LNWvqgEpGdwlcp3gF1PCoB6yHGILdIXs+cHb8JpoEImB+7b2nLUugEE1ZBAVL61/bryrTsU0rNjzlTCowiRBC4GY8h1zq2dI6T+APxVZJCfiuTlrE0/lsFS07ljZW7XVs7iSk9aNbA8et1xoEgzfwE76+WBW/97TmorKaKlqqotJWYipkuS9oAnk6QcEXDOZorkxdhHX1YbzpVAHDDvFfCXA/wTpFYEZC7EUhwzLRWaaqGRhPH9rxFLno47GuFD2gQMO8UMthpeSidAGMpw/teCqN+viSV5NCZEe+qfO5MnLGs7z2gz66axSB2TpdgtBOhBctvkNDIIy8Yas+rK3VrE3stzZPAzA7X2No2Omda6Ejpg07ndIpFSNPdU7LdIv15jk9cq6WgJCMqNbpE7O9WWkLT2lOU1iWIQWeugZ6Qe3U43QNdIJmjdLlNIKhzPRGH45YTacVJpr0YF4l05D4bc5OI1xgsT9sqA3sc+vHGXr+TTvdw6h39KZg4MYOtmLHdYSZbftehp0ASauMBaegpA0v96WJuxPBKxtxXXcb8bHsq8vXSIfbXDPbvXU45nO57XfIfwtfeBceDn/tvf4FxFZ0qAYKAAA=";
    final static private String hd_bentUpArrow = "H4sIAAAAAAAAALVW0W7bIBT9FYT2kLZBBidp0qputD1ve9tL31iNbSQDGSGJs68fmDiuY7sqqaYIzM29OefciAN+SjU9PDJZUPnKUpQzJZjRR1B/LbjWSqNCaf5XSUPLBGa03DLYSe+ZNvz1MmlYZRDVjG4TiME6IzM3ETctIdju88c9Z4dvqnLp+tP88LhhCVSqEiX6zaT5tflqaQ4Np0p5xpm2qPECYwzezKeSczMbaooE/gAn+u/u0Upxq7kd96fnytetTmEtdd5q9tkleAE/4fOTJ/qzo4Yr6WklFVZ31qjIlBa7kiaQZxOMvmAwxVO7dDp96EYd3dxYwKiD+B4BGSYgXQIbunENQTxMEHcJbOjGNQSzSwLB5aRU+YGnppjaRcF4Xpgw0Pkl6Dqbgdt1FoOIOI04CG0xgkZAtAgGu78Ea3q9w2idLUAQ2HJc2RV9rt6VtgyT9jAiDYMoDpdGek5yHq11PYTpIj3L1EgOBwVq6nmjbfGKf5/0nHDe/HWfJA5sdMAE9vi6JVEchtPb/pP61LxrvRmK2PPAxJ2unwDs+eAMFYYz6oAxGHu5pCUDb9Zoo7bcVTQ3HexkNZU5Q0ckaMXFTiTQnyDDNVz6mnYj+YqPkLu7bBC3+gB39Vluf6H+l9aj4ZeU539qPiubvQgAAA==";
    final static private String hd_curvedRightArrow = "H4sIAAAAAAAAALWYXW/aMBSG/4qFdsFXlvgrQFWKtotNk9pebHe7i0oCkUhCQ1rofv1s54PCMdOO2VTFdRLnsc/x+9oJt8sy2t/E+TrKn+Klt4qLLK7KN2IuZ2lZFqW3Lsr0V5FX0WbeS6LNLu6d3H6Nyyp9Or9ZxYfKi8o42s17AQnIIhFcF6JHdq+rm9c03n8uDvU99dc+9baN572iOGQb7+mlfI2X39PVuvqkOtq3vRbLNEnjUnGZDIKA6CIgpt406cLZRtV63nsw3U/JvSo5UwWbtsPhtLs262qS/CQ/yCN56AatLhyvyA7WVBeJFLqQVv699Zkv5LEebFEUl8b79X0XItTFBBHE6eOmmMHITlpJ3bGkJ5c0TXL14LfmUcvg2vgdByd1bFLHZmObYlYnzzLmUD8TUpPRu9t6/p9foiot8loNeZQpTSWtOJKizF420byXpXl/U6z26bJaj1VlHWupDRTEP6H8CUrPoUaMw47mL5KAoIjsnJgm/cD7QMk4GKvqIqHEnOlDnwxwA+Z2fNDhGTFn+tAnSLw4x+v4h2raiU91ZgIUTV6gMSdaeE7ray2NlLjIwBco1OQcdZxwhgJNYYQTMgo8pWicbGYQNCVD5lOcnIFJFslMZ3xGsCTgDJ3soS6wJOAIJfugThKluCxRIP/dc1lpUyml40gWpVNOhu2C4uuc4YhA7bXGVc6oShp6IaFA77XV2XElkcSc6sOcIc1OgQ0af9LQyaDU4oapNqggHpIE7NDOy3GCcCpkFmfQiQl2glU0s3iDzmpFM+x2AdzRKJpRpKIZ8IaCMB3hlPht1nBEi0fMfDKOnVBm2QqoKwsYQ28BJvsCmXyLAVhIhhS5CzCL8JloBDFBjsmyE6j3rZEhITPFLaKX+PA40Hu3XZoQOVLzHGi+lWe9KSAzxoHw+zSY1mtvVEU56xuVjQ15MPC3KQ4PXNDS6+A5crTACY4c4ILTJCKtwIEV+o3ZlU0HWMFY/CAcdAesACeWT83ECoeJFRZ3cLOMS4Hf/AT8lKgpI0NFOlcAi5yKDvluIoBFnDYEAazQLQQ4DvCA23DgF0GbpYEf6n8fkVm3mYDrzwsnGnCBpglXGjSDWTTcaBJov09DdkXqJJC//joLXIcH5K9pzJUGNwhFo640YIIrVSeBG65RnbR9JjurTlod4aw66IgrUwdN0ay6brzwX9sidLXFOsqXm5i8q3vbYpfqFmafMj/DtUpsGpRRvoq9Ny+LDmn2kpk3xwst0rxucey/bvF3vZuf8bqX3su90//Su4ldWGM/nPQuLzS53H0zFee/pt/9BhTC2fdmFwAA";
    final static private String hd_curvedLeftArrow = "H4sIAAAAAAAAALVYW2+bMBT+K1a0B5KWYRtDSNW02h42TWr7sre9oQYSpAAtoW26Xz8fO+R23MshmiocG5vv3L7PplzOmvTlIqsWaXWfzfx5VpdZ27wyc7ssmqZu/EXdFH/rqk2X00GeLlfZ4GD6OWva4v54ss3WrZ82WbqaDjjj7DpXEppwwFbP84vnInv5Xq/tnP7rnnp9yKaDul6XS//+qXnOZjdZ3n7Tdl46o/WsyIus0bAy4pwzaDgz/c2SbTQPabuYDm6N9VCwG/gBJ2Sy7SlzVyndJOwP+83u2C3cGEOTHE7uZu2dm4+613kEONHO3KTz5Qe7s97WdU10+Oe+ARVBEx/c2vO9s7oXGdwRyRHKBNzk+hEoxsFUJKCRGuHX+xhRCI1yYoCTUWxT43x2k6Z9lzc5+DADEfgec5PRq0tLgMentC3qytKhSkvNqbxjR1435dMynQ7KovKW9fylmLWLc91ZZMV80Q41SHCA8h6oOAY1bBxt0YLrnDMSojxGLHKP+18EO+fnuqtzx8wILhgMaQ6Hbni+hZfMjOCCARFeHcND/CNdORYIyAwnoUVvoMleaPExmo5WsTPNIDYMFAlqfAy1K7gkASU4wjE7475mNI02EwyUsJEMBI3OSCTX+QQyPmFUJKQMSPYIGioSUoSmPbdJEoKWJYHov3psWhCVZjoNycF0EbJRt6EEkDMaImK75bjOmdBJI28kAvHdSl3udpKImSFcZkQUu0Ay2OhTxL0EKhxqSECgivlEJCSHri67AtFYKB3KEGMT7JjKaOnQhphYRkvqcYHUsWG0FERGS6QNDSIhwoQFXdZoiA6NmHrKkFpQ6TgKRF8sJAw4Akz2FTH5DgHImI0E8RSQDuLr1xxLiDHRJ8dJICOTqTE1U6GD9BE9vBDxfXtcmhBDIudDxHl+ZnRIDQ8x3hM8sZtu2qaV9Ay9zg32cBg8FDR4RH9uww2J4SLum3DJm2LoegEyGtJKGlJr6qC+6kENxHxcgnBsSqD6lMAhhjBhvcqgHGLQGGcGkVgKhRSxoUZC9AkpoddGrZAQtgKl4SDG93MHEd4zqR4GMRDjKzHXLtqHk75oiPfwX4Toi4bpr9F4XzTEdo/3Q4oQ1z0/UkaWPQER4T0Ry1MAEfO90xzEZ0FfJCSCU3OH5XBi7rAiTnMQa6IvkksPvZUfYT2cgBZjTXxuH1mk1WyZsb2+/1CvClhhzhD7UWtwsKBJq3nmv/plui7Kp9K8xL2xoqjsip19u+Jz1pX9uPahdfFfrIfdJ2GMvT6wHr2x5G3zm1Icf9i++geWbU+e8RYAAA==";
    final static private String hd_curvedUpArrow = "H4sIAAAAAAAAALVYW4+bOBT+K1bUh1yGBV8gpGoa7T5sVanty2pf+oYmkCAFSAkzk9lfvz42YQLH2e0hu4qwbGy+c/s+7PBhWycv79Nyn5SP6dbbpVWRNvUrM7eLvK6r2ttXdf5XVTbJYT3JksMpnfSmn9O6yR+Hk016brykTpPTehKwgG0ypaAJJ+z0vHv/nKcvv1VnO6d/l6dej+l6UlXn4uA9PtXP6fbP46/aysvFZLXNszytNagIgyBg0ATM9NslXSzHpNmvJ1+1Ucm1iS+6I1YwEtALbQ/uxuBXxL6zP9g3BusVLAuD/mQ32965mtSLAS6EnogvJjqr+IHf2TfrbVVVRIc/XZtVS2ji3q0r3y++fO/7HvZBQg6NTYXSdvuTEhqlIT53IBIm5BClzcC13TaQfw0jhDDC+C1DQ2x4PArcHkbgfiRMTj9+sBT48ZQ0eVVaQpRJoTmVXfiRVXXxdEjWkyIvp4dq95Jvm/2D7uzTfLdvZhrE76H8Eygfgho+zi+w/iYLGAlQDAHzbBp47zh7CB50d5NxZkZwwWBG81e64YMWnoP3dgyXHRJNqKEJyMFcF535Fo+EFt5AE6PQoiHaFAi10AxjM1+RoJZDqK7mgoQT4wCXbBF4mtM05qwwUMzmwuc0QiOZbLIVJHzFqEhIG5DrOTRUJCQKzfzAJolzWpY4UsDpR92ArgQjSt9BdC7ZvHuT+JA0GiRiu+W4ThrXWSO/TDjiu5W7eHubhMwM4TIjotg5koHR57tx8uQOMcQgT8U8IhJSQ1eWqwLRaCgc0uBLYLRuqVgOcfCVpbSgbhlIHi2lBSdSWiBxaBABEcbM79JGg3SoxJRUSGpNhWMv4GOxkDJgDzDpV8TsOxQgIjbnxH1AOLgvVMuIJdEnx16gD14Lg0TMlHSwPqSHJxHhL/uliVASOS8R54OF0SE1OsR4fQaK7Us3aZJSTA27Hgz2bOYfcxo8Yn9gw5XEcBH1Tbjk16J0HYCMhLSQZtSSOpivRjADER+XQC5NCdSYEji0IGM2qgwKaaEtJ3GfV/hvgzIBj/PKcTzSGAsTJ5EgCumh51lM9AzR/yJ6Ggxi/7i9SCH2j8RBxIe/EXqz9SNI1S/ElGP+azQxFg3RHdDkSLQQEX5q2D4SDdF+2rJrJB4i/p14tzeDkYCI/1PvPg+REu6qrms3GF/d/1QVoUsVcnSkWBV31SHCurgPDyvjPuZFWBo/zbx9Um4PKbvqe8fqlMOK9iC5eTt/tQvqpNyl3tkrknNePBVm3Y0VeWlXvNm3K37Setx9K75tmv8vps33a3fgrz3r4Y0lt823dRh+hf/4N8a7qgueFwAA";
    final static private String hd_curvedDownArrow = "H4sIAAAAAAAAALVY0W7aMBT9FQv1oVAyYscOoSpDm6ZNk7a+7K1vUUkgEknakBa6r5+vHaBwnbY37VQR7Ng59/rcc+yUq3kVby6TYhkXt8ncWyRlntTVEzO386yqyspbllX2tyzqeDXtpfFqnfSOhh+Tqs5uTwfrZFt7cZXE62nPZz6bpVLCJeix9ePi8jFLNl/LrR3Tf7unnu6Saa8st/nKu32oHpP5t3JTfNFxNrug5TxLs6TSsEL5vs/g4jPTbqbsV3MX18tp77cOG3ATm/3SXyKCGwJa0rbgLo90GmZ4Ym/esD/smpmHQ7goPepblBvWPubEOiTgCv+dXdvMy7KkJ/9Df8FNqeAC6cjxIYvjUdOavLLMo0cULEvxw/qORyERBYT8fAUGklWqDQYeUW1ZK2ipCYHQo8dDiBhyw/LnKyuQ+4e4zsrCyqWIc625dKeetKzyh1U87eVZcb4qF5tsXi+HurFMssWy7muQ0RHKS6D8FNSodbCDHc1Sn5EAxSlglp773hlnQ3+om5o/ZnrwgU6flm/ghvcbeA7Z2z58bJcYQp6GAA4Gum5sZPFIaKoFTXRCC0/RNKGSXWj5sf5IkqDGp1D7mgsSToQXOGYXvqc1TVPOBANFbCBGnCZoZJNZOgHCJ4yKhLwBXA/gQkVCptDK9y1JnNNY4sgB6/uqBl8JRrS+Q+g8YIP9TjIC0miQSO1W45o0rlkjbyYc6d3aXRx2E8VMFz6mRzQ7RzYw/jzrZk/uMEME9pTMIyIhN+zL8qxANBkKhzX4GBStr1Qshzn4xEpaUI8MZI9G0oITJS2QOTSIgBVGbLSnjQbpcIkpqQioNRWOs4B3xULOgDPA0C+J7DscIEI24MRzQDi0r993rCLGxJwcZ4FQhqkxlanAoXpFX16ABL87L80KA6LmA6T5vTztsUBkLEDK1+9Ckd184zouxLlR2dAg9/uju4wGj1zg22UHxDSRBU6WTRRv4HohMpbSxupTS+xwguygFGQEXIpgbEohu5QCeYOHwqBfmHoQ7SGRPfZwpsARrSDScS5oDI2lJP08lcglDcqFQaUuFXmk25EgkRl2WwENpt0LNByXB4KJln8IVH0ikoRMAGiyK5rDC428OgIi9Z8b1XdDU0j88P+U3xUNaR/QeFc0pP39NtIREB8ROj3RNT1kgndRh7zwLuqwI95JHTZFsxF1xPtoW6gPtUXoskXnHSV02eItO8oyLuarhD1re3flOoMZzQvh7PAe1Uyo4mKReFsvj7dZ/pBPe2e8ZUJW2AmH8HbGG4NHzW/FLwafpf8nupStS386iq5aprSHbypx+nv753/gJEnciBcAAA==";
    final static private String hd_leftCircularArrow = "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";
    final static private String hd_circularArrow = "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";
    final static private String hd_stripedRightArrow = "H4sIAAAAAAAAAJ2WUZObIBCA/wrD9OEuDaNoTLyb85z2udeHPvaNOVGZUUnRJKa/viBiLqKd0mQg4C7f7sKu5CUT5PJMm5I07zRDBeU17cQVDI9rJgQXqOSC/eZNR6oE5qRqKbwTn6no2Ptc2NG+Q0RQ0iYwzXcgzZ9kw6HqfAjac/F8ZvTylfcJ9MHwNSuvR5pAzvu6Qm0n2JFmP1hRdl+ktYsxzTOWMyokPPLlBwz9KJyiOZKuTOCbZCvr35TpvXFkPzgyiOTPT/CmBoebYmwUY60xSifd3aRqkHsNi2QXj4/xzgz8ccmw/jt8fdGe/jqRjvFG+92QWgaemzByLupTRRJYs+ah4sWFZV25lYOSqu14lBDvjvI3KJ5D4114iDYG66W5D5yAwRzI8gcfffLB1t/KIVbnoeeq6emjm8/hsgk8mpCbCYaZamriiN/N8WoPNpEXBk6YaBGT5iHwdNROtP2cZk7os4/SPHI7o8MCTCeP9C8AXuDuX7yK9Ny27cnethgMQR7cgsRWvQwkxUFusWGrSP43OGxVh3Jnow5QVhrGjhFahXCXFDhwxFmJP4XpxrEy37jlhrFSfuV951qY2Er/NbB0wQlsFcEaOF7jygsqqyj4MEZH3jKloa7DdCqPUShIU1B0RTXpWX2qEzi+WpaVWKOVbumvNf7F+HCPLXH7m/F0uk7mGuuWveU/Gq9/APifb1OBCAAA";
    final static private String hd_notchedRightArrow = "H4sIAAAAAAAAAJ2VzW7jIBCAXwWhPbTZIBsnbpqqrtWed3vosTcUg41kIEtI4vTpC9hOG9tZLZsIBMzkmx+YyWOhyfGByorIDS1QSZWgRp+APxZca6VRpTT/UNKQOoOM1DsKL8QHqg3fDIWGNgYRTckugznDGOTs3g6c2GkNwe5QPhw4Pb6oJoMx8N/+l6ctzaBSjaiRVGZT0eKNl5V5ttaOvWlVcMaptvA0th/g5054jmZLTJXB35btjP+yc9q5kfozvLDTqjvGy26x9rI16LxegXfwCp8eW/SfPTFcydaQJMJ6ynq7TGmxr0kGBZc3tSqPvDDV3C4q6vy/tZDogvI3KB5CsYswnvXcKGcxCCImQyJnNzH6EYN5PLfLlu/3brTb2zCnF9MmcGfCZhT4nRtuE4hfDvEuB7OcLUDUuhtES4e0PrU/Y5SzZVhy7yZg7bVb/xIQJeH+ra4ioyQIdD9O2wr4IO/CglxPghwGhYWGRyXzv7HhUZ04d2bu/myF4MASwaMauXgTth+E4Ub10OPCMKN3f87WNY5tgEVNwbc12qoddxq+HbvG1z+LTq6JLCk6IUEaLvaibzhXlLhslb7uvdX4N/spmOQ2X8bzcwMcaly3HE3/lz19AvWzZzHkBgAA";
    final static private String hd_homePlate = "H4sIAAAAAAAAAJWUW2+DIBSA/wohe+iNiL2sl9Sa7Hlb9rw3UkFJBDqkrd2vH0rtVjaXoDnJufGdcxDcZpqcN1QWRO5phnKqBDX6Alq34ForjQql+aeShpQJZKSsKLwLn6g2fO8HDa0NIpqSKoEYYJCyhZUVBNUp35w4PT+p2kXs2625HGgClapFaYsK+lYScyumMs441Ra3wPa5um+dH4gpEvjS8p5tpXlbc21l2Vq2dutZgXfwCndbt/rjSAxX0rEkEbY869BMaXEsSQIFl4NS5WeemWJilYLyvDBDC4nuKP9BYx8aN0PgUceNUoZBEHHqEzkbYPSAwQRPrJqyGLRWI40xDGt45uObBkcpm4LItR5Em/u0bu4xRimbhU2+8GGD5gOPO+QwmgbhHn9POgejOJCy/GNCd1ACQateUBBm3bfjfRR7j7KSgh86OqiKNxluS7p7cQ1qInOKaiRIzcVRNDlxTwaXLuP7zLiMWyf+72f3BbtyiMKXBAAA";
    final static private String hd_chevron = "H4sIAAAAAAAAAJ2U3W6DIBTHX4WQXbSdROx3m1qTXW97gN2RCkoi0CG1dk8/0Nqttl3CNBA+jr/zP+eAm1ST45rKnMgdTVFGlaBGn0CzLLjWSqNcaf6lpCFFDBkpSgqvtiuqDd/1Nw2tDSKakjKGCVsADBK2tC3CEJRVtq44Pb6oOoYYNG/32WlPY6hULQq0y2mlley8qZQzTrXlzbB9zssX6Xti8hi+NbRX62jauIwi262aqfPdrrlu0qx/gHe43bSgzwMxXMkWK4mwOljnhSktDgWJoeByUKjsyFOTB3aQU57lZmgh4RXlL2jUh0YuHjzquGHCMPAijvtEzgYYPWEQ4MAObcigmbnmJkM/wZM+3gkcJWwMwla6F23ap3VxP2Pk6uIFm91Km4JRFI69KPN7lP/IWdwpRMLmLusTWwy/tC8fw6Yg6LLmx1zdSX57hj1TFt1cjQvJj3NzG7rAHmHsfU8LCn6N0V6V3Fm0heuUnTc1kRlFNRKk5uIgnE30wILL1uLnQLcWFyX9/+T2G2jpq9dABQAA";
    final static private String hd_swooshArrow = "H4sIAAAAAAAAAK1W246bMBD9FQv1IckGYTsEyGqzqH1uK/W1b9bGBEuAUyC3fn3HJpAuZqudVRXh2PHkzMXnDH7a1eL8KKtcVC9y5++lLmVbX4n9uVR1rWs/17X6ratWFFsvE0UjvVfbJ1m36mW82cpL64taimbrUUJJmq2YGahHmtP+8aTk+Yu+dHvw6f91Pcitp/WlLPzmrHWTfwYf596h3qlMyRog+ZpSSlgURfFtc8jhINp8633rfFLyA7742gwrGCJ4EvIVRsbuUXEzY8aIGQMWmmHV/XVjhrhH+0m+e89PncNfR9EqXXXuK1FC5FmfSKbr8liIraeyGfM/UbJkS5jGJmy7NI9dzecAGLxC/JcDNnZQqmpW6P1Z7dp8CZNcqn3e4kD5GDSGwOiihw2gGgQFuJooA+TNyJKaMkBFiV2ZxyyQRQjH8EPeizSjJGAmfIqCXI8hTc6AtvoQWjQRoC3lA/XTbI0rZvzOIw8SFGwyhqUPaRYTH5fpZoyyDm25FixgIY7ZjnZMOItWVLODWgBnNmQOZ5FYeKRoHNWYTmDPglHcYTBHK2kW/qcoHdWYXvVg8JGHwhyB2HwhW46GmhJGaLEoGsuRhW2zH6Edc0RhezccKRLHUQHgAOtYwHE4jg7uLQmwcEFxRwlGmiwhhq8bHF+5Q/0hsCDCIU0wnzNTKobDmaA54ECGHM1OPvUm6N5ZyOQmaM5DZKkn6N0VCMclPsVtKxMeoQvk8HsoEK47c4fgEE6CvBU4vB64iMOZ4rRN6i0YuBruCkn+mvsH3ShjcWto6b393gxqUe2lf/VLcVHlsYRLkbmuvWGjqs7mLoXO4n3+7a10Cvly954Ot7SxRe+bOr5vtRjf7p//AJPMySr2CwAA";
    final static private String hd_flowChartProcess = "H4sIAAAAAAAAAJWSTWvDMAyG/4rx3aROb6HuYLt2Y+fdtESJDU7Uyc5H++vnNemgIx0UYx386nmEwLuKYSyws9CVWKkGqcXIJ3F5bh0zsbLE7kxdBG9kDT6gvIkH5OjKPyERFaH/VIPDUQV3RiO10AsYcYoKGCEYuREb8VRv082lCENT/BDPNM1JOlfmdEwOoqn1qvY0vljg+M5UYghLy+8WR4jWyNcLfxA6Vb3UD/Em97u5+6uH6Kib2Q7apK+v02ritvdgpKdmdFW0WZ647Ab8z6NXPBZdY+ODovyu6CHN9t5eK5Zs/UvsvwEGXz3NKwIAAA==";
    final static private String hd_flowChartAlternateProcess = "H4sIAAAAAAAAAKWVXW+CMBSG/0rTK/bBoCAIRjTbLnazLbveXaMFmgB1pYru168FNSJiVoGc04bTPn0PeQnTJcfVhBQpLhZkaSaE5UTwHagf55Rzxs2UcfrLCoGzCMY4KwlslTeEC7o4LwqyFSbmBJcRnMcuaGIkw4Og3CSTDSXVC9tG0Ab1fdi3W5EIMrbNMzPOWPWaYi6eM0F4gQX54mxBynK/9ih7hUUawQ+Jmcc2eJcZgWYMZTj1TNUC8A0+m82Msb79b/vVKlCd0JHZqjkquSfntKqqV+SdnN2q+iqNaz2zadPNzxoLyoqmtwLn8j3Eh9cSM56vMxzBnBZGxpKKLkX6KCcpoUkq7ixfYqwW5xoWnWMPyAfbVAK1YM4FWCPrFpp7TlOEeyd0gtBCtrq0cKOrnbp62rzrnWrS/D5plqPFGfeq0gQFvSAtTNjXl55FO9Y3kB3UBpBuV8OTnhNQx/SGNxrC6/jeQL4zBNix/kCBHe8bt5I6xh+orGP9gbzOJ/AfnnX53zf7A96txh4UBwAA";
    final static private String hd_flowChartDecision = "H4sIAAAAAAAAAJWT22oDIRBAf0V8LMhekiawxATaPrb9gL7Z3XEV3J1U3Uvy9bW5FFJiQWTmQeccxwE3jRVTBb0SfQ0NawE78PZATtudthYtU2j1EXsvDKdSGAf05ngE63X95xARKzd8slHDxJw+AqclKS+gh9kzYUE4TndyRXZyHSIPUVDixrb6oZ5w5jQnp3XlDvvgQZw7w6TB6VkJ61+g1k5jf6n5fcpeeMXpW8AL8hoiJ2XIRcgf5J1uN+fqr0H4AJ/ZXnTBL6/XSbTdYASnBttJN149LLJlILMb9D9TccekQLfKJ6vKWFNZmeRZRFtKFC2joiTNY+xdSZZVdDppU17Hp3NPlN3/PdtvmMr1hVYDAAA=";
    final static private String hd_flowChartInputOutput = "H4sIAAAAAAAAAJXTW2vDIBgG4L8iXg4khyZrF2oL29Vgh/vduUajYPJlxhzaXz+XtoOOOBBRQX0fFXFbGjYWvJGsOfCSVBxqbs0RzcO1MgYMkWDUCRrLNMWC6Y7jm+mBG6sOfyYBoOj6TzIoPpJOnTjFOcovQcsnS5jhrKN4LzYoRnuRurrGqBuq4ifzCBPFMZrLNXVsnQIw1ZoIDeOTZMY+N21v33vr2suy37u0zEqKX52QoxeUzH2MMtd+oDe8255Xf/XMKmjO2YbVbgtx3VGAqXvNKNZQjaq08i6NcpeMbqL/SYlXWgVKqVfKAqWVV3qIkjiIynxUlAY5udcJPND9AiS5qqQNPNHaCwUxG+/Flt4sWv6Mu28E6f8OpQMAAA==";
    final static private String hd_flowChartPredefinedProcess = "H4sIAAAAAAAAAJWSXWvDIBSG/4p4OQhJ2pWU0LSwwa6aUdjd7lxzjILJ6dR8tL9+xraDjmQQRD16fB/fI24KzboUasHqIxRBCViB1WfityupNepAoJYXrC1TGeVMGaAP6Ra0lcc/SURMTfMVtBK6wMgLZDQmMVm75uYbwEJvA6aBmYzu+IpEZMeHvqTEtGU6aF+wz2hEfLurzidHQ+wrFXCF3atg2h40FMBlDcVB4xGMuR3+rezErMho7kl75yEafPjxk3yQd5L71d57zEni48TFbz43pnIZut1cb/lumJVYX++sWeUM8rtfjrpqFMuowrKThRVPSbh2yvBB+h8pniKFi1mcxQhHgCyFnQlaToJmYZ6n6ppFWU2+ztgrh+MffvsDi+sQkgkDAAA=";
    final static private String hd_flowChartInternalStorage = "H4sIAAAAAAAAAJWSXWvDIBSG/4p4H9L0A0qoLXQwGCS76d3uzhqNgvF0xny0v37WLoOOZBDkKPryPudV3BUWupQbCebMi6jkWHFnryQcV8patJFEq25oHGhGBeia0ye55dap8x8REdO6+YxaxbuoVjfOaEISsvXDrz8Ax3sXgeVQM3oQa3IQG18rX0tK6rZM7+4j9owuSBiD73rxPMS+0pHQ2L1IsO7NOG4N6JNDC+WQ8fdmF3CS0TxwMp9hcc8R5g9yIu8kD7ssZMzDeRayvgZtzOUVut89unw14BSaR08DlY8nhrQCbdVoYFRj2anCyXjpffGT8T9OMsKRXJXSzQQtJ0GzMKupe82irCdfZzuLs5l+nTFQPP7f998SF7l1CAMAAA==";
    final static private String hd_flowChartDocument = "H4sIAAAAAAAAAJ2S32rDIBTGX0W8HEiMKetWkgzWXW57gN25xETBeDpj/rRPPxfTQkcy6BD16Of5ne+AaWn5sBNGclOIktQCGuHsEU3XjbIWLJFg1QmM4zrDFdetwFdyL6xTxS8RAHZt90l6JQbSqpPIMIvvKUXTOgOcGB3hVvA2wxRR9FRt/PRq29e7n8xnGIPixznnePAsgLHRpNIw7CW37gWKrhHGzW8u7Ry4kxl+mwCvoTSaLaB4mzCG9iimD5dTiFny6GO/03jL0Ad6x3kauF8ddwpMqGJ4451UZ2MV2KbTPMMaailULd3dBI1Cx3kaXTH+QsbryMnTP5BsATmo0smI3cRJVq3dCNqsGVqgRMufNP8GgRto170CAAA=";
    final static private String hd_flowChartMultidocument = "H4sIAAAAAAAAALWUXW+CMBSG/0rD5RIiLR+CEZeMxCvcze6867RIE6CuFL9+/SgtCkZMJBsEekrpc8770jLfcnyckSLFxYZszR1hORH8DJrHOeWccTNlnF5YIXAWGgnOSmL0hg+EC7q5G2SMzcrq2zxQcjRLeiGhgaBnWeDpXYMFOQkTc4LL0LDAeyIvp76gAcrDbiaZH+wkx5qznXXe11kYO+WZmWTsGKWYi1WVCbplmyonhdAvXtXusUhDY1UzkDX1EYhAgAIfINt1kAqhbyFU393A1XGse7Y3deuJTbMGKwBdG6lerGLoQ7fm1kcv9JArE0GFb3oa79l3cS+VzIGCqebGKm7Na1vo2IGkI8u/9nRex/GmvTjuFrcGX+ATrFpBvcxd9VHXlo5ZrYP/5MQfS19qra9/dVVO1C+0I6ArLe7ljO6q6VTZqT++qdIir7pvVt4Mvq6/pfx+xmKu1vdPhQVlhVrtBc7rbZG0uyRhPK8yHBoZ26WE7lLxJhkTtf8W80kP8YwIh4mNsSOQ6AHySLcifZMejwDag0CIkO+NIDrDRLkmRhDdQR8n6CWQN1TaA8rk8X9/8QufLycgEAYAAA==";
    final static private String hd_flowChartTerminator = "H4sIAAAAAAAAAKWUXW+CMBSG/0rTK2fCaMuH1Ygm28Vutl3tanedFmgCHFeqqL9+fOiMH2yD0ZxCTnuevm/TMl1qUUxkFotsIZdWJCGVRu9QnU6V1qCtGLTaQ2ZEEuBQJLnEZ8MbqY1aXAwCwCRff1gbJQsrV3sZYEZ9QlDdHwBGbo0ltBR5gOchQfOQlUHLcDDKN9Gkqn6AbYAJqtuxbrcqeQDbNLHCBIrHWGjzJnWqMmFAH2Z9m1oJEwf4BTnuyCspz4hyypqvOtUIe0evJ+m/1z41KUo4qYTzMsbnwIsZtO5ovc5s2ij8XAujIGv0ZiItXYVHkyHodJ2IACcQFWpp4iEllNvN/s2m9hnhJyBtBTLicdaDyG4QY6mi2Awd6js9iE47kXLXGfVAum22bdaJ47VK6wjyW0GdMKM2X50o/JIyoD4j1XNn+9Xrvttuj6951bnvzaNX12Dguf/hXd2CPwm0b/8eZ1+evYqVNwUAAA==";
    final static private String hd_flowChartPreparation = "H4sIAAAAAAAAAJWSyWrDMBCGX0XoWBBeEkMwUQLttS099zaNZUsge9yxvCRPX9lJCil2wYjRII3+bxa0zwj6VFUaqpPKRKGwVI7ObLouDRGS0EjmgpUDK3kOtlH8Idwpcub0J4iIadN+ic6oXjTmoiSPQhaFN6lTgxNAChrJj3nCQnbMR9tw1nRFOqqecZA8ZNO6q8615yAOpRW5xf5FA7kPUjUQOIPV7dlvNzU4LfmbJyTslcXe79hYhD/uRheP2yd754f9VfjdTpwrpoLSZ8vvyXOksrUgucWiN5nTT9sg8crgQfofKVoiBfEqTjzD0coU2q0EbRZBqzDbpb5WUZLF6cxNOZj/t4cfsTakOtACAAA=";
    final static private String hd_flowChartManualInput = "H4sIAAAAAAAAAJWS3WrDMAyFX8X43qRp65vQdNBdDdY9wO60xokNtpU5yk/79HPbdNCRDIKRBT46nyzjXRGgz5TX4E+qEJVCpyic2e3YmRAwCI3BXNAT2JyXYBvFn+ROBTKnPyIiZk37JTqjetGYi8q5ZHI0khpIQFDQ5HzFXkoZYxtjw1nTVdnVc8Dhqt3Ww3WuIwVxcFaUFvtXDYGO4Fuwb75uaSz7naUG0jk/RkLK3pmMWY77J/vg+929+rsFMujvXg8utigfHUsMrrWQc4tVbwrSyTr6kifjf5x0gqOVqTQl6WoRaT1PWnalzSxoEWY790KLKHJ+KjkBSqb/6v4Hq73o+8QCAAA=";
    final static private String hd_flowChartManualOperation = "H4sIAAAAAAAAAJWSTWvDMAyG/4rxcWCSdElhoW6hu67bfTetsWODY2WO89H++rlpO+hIBsFIB796H0nYm8JBnwurwB5FwUqBlfDuRMbrSjuHjil0+ozWg+FUgmkEfZA74bw+/hERMW/aL9Zp0bNGnwWnGcluRi8Gz8AJaDjdyTWJyU5eIuhNV+YXzx4HTmMynrvrVAcK4lAZJg32rwqcP4BtwXzUwoHXaG+lv/vU4BWnh5HzRrKQ05CTEJ/knW431+rvdjRfvRaq0Ebeu0p0VWuAU4NlrwuvntIoC87owfofKZklvURJvAi1mkNFq0Wc51nOwoHSCZASulR+4UTZLGgRZj272NSbRdOff/sDppTczxUDAAA=";
    final static private String hd_flowChartConnector = "H4sIAAAAAAAAAK2V326CMBTGX6XpFXNh/BFBjWgyL3a1PcDuGizQBHpcqaJ7+lGYRi1b1iGkpTnt+fF99DQsNoLUc8pzwhO6sTMKJZXiiNpwyYQAYecg2CdwSYoYp6SoKL6a3lMhWXI7KelB2kRQUsV4lU7QKp02LWzaDKNqn833jNbPcIixi9r7lHfc0hgDHMrCTguo1zkRcg2c00SC+F501rslMo/xa5O/SiP0jt66BQDw05qXplcjv2le240vI4HqJpcRJdmLLiPKiDdr37ZcdHo+dkQy4J06TsrGQnpylIIodwWJcQFZzTYyd/wmz7lK/I3j3XKUlFEClbVlI8uPXHU9OJ477UZGcL9HZE5ZlktDlWNdpY9GFeP3UBnc6VNOdJEBenTtZj+RESjsBSmM7RqBont9/6muKOqsjc2szXpBCmNozes7AJ03M452AE67b4bRSt06F6MTqseToT+t5K1JMISnVbnlhf4QoFbuAwVqVW/9l6SV/UBlWvUP5GmH4C88p/9fuvwCbLS6Q2QHAAA=";
    final static private String hd_flowChartOffpageConnector = "H4sIAAAAAAAAAJWSy2rDMBBFf0VoWRB2UgeCiRNotn3su5vaI0sga1xZfiRfXyVOCil2wQiB0NU5MwPaFQ76FK0Cm2MhSqQKvTux63WlnSMnFDl9JuvBZFyCaZA/xB06r/M/IRGlTfslOo29aPQZM76K2Sq+oR4HL8AhNBmPWcwOMgk7pE1XphfmhYYxCevOnOpgIRoqI6Sh/qjA+Q8payjxSNZi7snd3v4OVINXGX+7il5DfXZpgm3ZZjxv2Sd75/vdCH234DXZUWGhCuXkvbokV7UGMm6oVKhL5Z+SaBPQ6IH9T7WaUPW68CpaL/KsZ1taKHqeFS3SJHNzTVii6f+2/wGMD2VeiAIAAA==";
    final static private String hd_flowChartPunchedCard = "H4sIAAAAAAAAAJWSTWvDMAyG/4rx3aRfuYSmg/a6jZ130xIlNjhWpzgf7a+fm7SDjmQQzOuD5OcRAu9zhi5Bp8FlmKsSqULPFzGUK8NMrDSxuZLzYFNZgK1RPrVbZG+yP00iSurmS7UGO1WbK6YyFvEd9Nh7BYxQp3IlXopdyDZkI0XdlsmNOVJ/6w3nQV3OwULUV1YVlrqTBvYfjcs05ifg/P7sd5czeJ3Kt2BYi9eQlYiHjPeneJeH/Uh8N+ANuZF3UIUxxWNqQVw1FlJpqexM7nW0CVz0BP7nWU94NJpS+4WizaxokWY7t9ciy25+q3hCFE3/ssMPja7s1X4CAAA=";
    final static private String hd_flowChartPunchedTape = "H4sIAAAAAAAAAK2U32+CMBDH/5WGJ7eko0VRNKLJ9rCXbdnDnvbWSaFNgLpSRP3r16JoFFlWHeSOH7378L3LlWkkSTWhOSP5gkYwoSKjSm5A/TrjUgoJmZB8K3JF0tCJSVpQ52R5RaXii7NFIcSkKL/gitMKFnxLQ8dDwEP7VEXXChJJSRE6CMzjoTZfG3ZAsUomJutRrM1afTZZm6XmCLHOUhinonpiRKr3Ml8wGn2QZaPrUM2SKBY6r5rggRfga/8J3o76LsY913HzeKQt2N+PjTKkEboEHBxCMDbOa576xg3qT8ymOyHfJVFc5DtZOcm0+rgpJhYyK1MSOqlIGOUJU/djFyOd654k/8bC3ayB61uhvAuoikeKuZ4Vp98pyba4QTfJTpLfVZoVZdgtx67To3NQD6MAmePOHZrLg12fghYP3gYc/7NA3Br5W4Gtue9dS2qN/a3Nw60NcLW21gb4U9vcy3/02Q99tuYB6gUAAA==";
    final static private String hd_flowChartSummingJunction = "H4sIAAAAAAAAAK2W3W6jMBCFX8XiiqaigBMgqUoj7UpdadXuTe96ZyUGLAFOjfPTffq1IYlIhq3kmEQ4MNifz4zPSHlaC7J/pHVB6hVdeznlFZXiC7XhignBhVdwwf7yWpIydTJSNtS5eL2jQrLV9UtJD9IjgpImdZZZhJbZXF2xuhYOanb5447R/Q9+SJ0Atd/Tuq8NTR3OD1XpZSXf/yyIkO/bqmJ1/ntbryTj9XHqWfWGyCJ13hRlmSXoA72jP+hN3etnjF7VGM70EF1HtZwwQS8X8z/0c7cF5/x/u/w6z1eIdpj2I8f9epHjXr2ILki46OntqvR6qlMbi8+xqI11WqEG3N6E/Ug79FVhrQr3VWGNx8kx5+enrq6fW6LL3FW5JpU6kOx0PhkX1bYkqVPyfM/WsvCxWudfLPyOE15ztJjJijfuhk1cnAT6c+eHwby7M4LjAZEFZXkhDVVOoUqMJg2rx1A5G6mUERQ5Q/eBp1yFjEDxIEhjvMAIlIxV/zlUlHSpTc1SWwyCNMYwtXCoAbrczDigAU6nb4YBVnfPZvRj/fNgmB+wvBvNbHjA5W4YYxsgsLulQOB691YSsL2lMuB+Sx5oAjseBq1g6T0MesJS4EBzWHkPj9wcGDbHraSRuwLDrrDj3dQb/vC/0ud/UUF4ma4KAAA=";
    final static private String hd_flowChartOr = "H4sIAAAAAAAAAK1WXY+iMBT9Kw1PrBMWWlF0MozJbjL7Mh8P8+Zbo0WaAHVLR5399dOCGvQym9SioZRbeu65t+ckPKwl3d+zKqfViq2DDRMlU/ITNeGSSylkkAvJ/4lK0SL1MlrUzLtY3jGp+Op6UbGDCqhktE69RTZBi2ymr6m+5h6qd5v7HWf7X+KQehFq/qd9n1uWekIcyiLICrH/nVOp3uRx9Ux0S1Weei964yJL0BK9o1f0oufmmaBnPeLYDJPrqGGAE/R08f7SPLcphBDfZflzfl9DNMO4Gznm60SOuToR0wM87/CNNfZzc9cLETqlaqjiZtoyhQxIM8HdSDN0OREDS7qciOFEkmPFjw9tV/9+UMVF1fa4oqU+gex0IJmQ5UdBU68Qmz1fqzwkel94sfF/OPgax5AZrUTtb/nIJ0lkfj9CHM3amRU46SGZM77JlSXLMWRJ0Kjm1RAs44FaOYEkY3QXBVoryApo2gtkYILICigZqv8zyChpSxvblTbvBTIwlqXhPgO0tdnhAAOcTt8OBkjdP4sxnJrbT8v6gOT9SeyCB1Tu4ylxAQRydyQIVO/figRk78gMqN8RD5jADY8AKzhqjwBPOBLsMYeT9sjA5iDQHLciDewKAl3hhneTN8L+z9DHL4qkR0GfCgAA";
    final static private String hd_flowChartCollate = "H4sIAAAAAAAAAJWS22rDMAyGX8X4cmDSuIeLULew3m57gN1pjR0bnKhzlEP79PPSZdCRDIKQERb/p1/G+zxAl+nKQnXWuSg0lprClQ3XpQsBg7AY3A0rAq+4AV9r/tBudSB3/tNExKxuPkTrdCdqd9OKSyZ/hKR7EhA01IofzZYdzS7mKmbKWd0W2bfqGXvFV2yIUXe9RA5iX3phPHYnC4FO6D3Q6Ol3kwuQVfx10L8wGc80hhwqOdTv7I0f9nfVZwPksLozKijjGDNONRjKxoPiHovO5WSf1skmKpMH6X+kdIJktSssLUbJOVOJXMRZz1paCNrMghZhtrN7LXuf3fxeU6Bk+vsfvgDKaBwkFwMAAA==";
    final static private String hd_flowChartSort = "H4sIAAAAAAAAAJWTy2rDMBBFf0VoWRB+JE3ARAk0kFXbTXbdqbFkCWRPKsuP5OurPBzqYgXEMAvN1T0zGtAqN6zLeCVZdeA5KTiU3JoTupZLZQwYIsGoM1SWaYoF0zXHI7nlxqrDPxEAsrr5Jq3iHanVmVOcokfcAZb3ljDDWU3xRizQRixdxi4TjOq2yC7uN+gpjtE1Bt/p6HgAfamJ0NBtJTN2D8be9cdzjsxKij+cNUHvLmPXPHGRoi+0R59oUC7V3Z/z+KZT8Hp1I/80zCqobn0qVro5xDCWAFM2mlGsoehUbuXLLJo7ZzSyPiMlEyTJVSFtMCr1DRWlQZyZd6RA0NwLCsK8+t4VRFl4txO25aV/O1OgaPq3rX8BwxrBooYDAAA=";
    final static private String hd_flowChartExtract = "H4sIAAAAAAAAAJWSzWrDMAyAX8X4ODBpnZxC3ULHbtseYDctsWODE3WO8tM+/by0HXQkg2CEwdL3WQLtygBDrhsLTaFLUWmsNYUzm55rFwIGYTG4CzYEXnEDvtX8Id3rQK74k0TEvO0+Re/0IFp30YpLJm8g6ZEEBA2t4gcj2cGkMTYxMs7avsp/qCOOim/YdO7c+RQ9iGPthfE4PFsI9DJSgIJuJb+TnICs4m+RluyVbadbsg/2zve7a+VXB+SwuXIN1FFt7j8ZDHXnQXGP1eBKsk9pkkUyeUD/M22XTIlc5ZGLnnX9pDMeq11laWVD2aJoRpPMr9f+GxKmGJ13AgAA";
    final static private String hd_flowChartMerge = "H4sIAAAAAAAAAJWSTWrDMBBGryK0LAgndlYmSiDdNj1Ad9N4ZAlkTzqWf5LT13bqQopdMGK00Og9fQPaZwxtiqWF8oKZypEKDHwT43HhmImVJXZ3KgN4LQ34CuVTu0EO7vKnSURpVX+qxmGrKndHLWMR/4ABu6CAESotjyYWG3E0QyVSVE2eDsyJOi03YlwTdbv2FqKu8Mp4al8tcDgj51Oe3ymuEKyW55F+E4N/2+8f4l0e9o+bXzUER+WDK6HoxWZ6xxAXtQctPeWty4J9SaJdT0ZP6H+m7ZIpild54kXPujzJjMeiy21YGWi3KJrRRPNf6/AN4MacN3MCAAA=";
    final static private String hd_flowChartOnlineStorage = "H4sIAAAAAAAAAKWTXW+DIBSG/wrhalvC1FqpaWqbbBe72cfF7nbHWhQS5HRI1fbXD21d08/MFHI4BHgf3kPCZGFYNeZaMD3nC5JxyLk1a9Qu59IYMESAkRvQlqkEp0wVHB9sl9xYOT/aBIBxsfompeQVKeSGJ5giuhNaXlvCDGdFgmfpEPloljYRYlSU2bjRPEGdYB+1vVOtl44CUOeKpAqqZ8GM/dBKav5pwbCs8/VXzZJZkeA3FDjKK6LtGLj8hd73Lq+cfnHz0PmKXNCdtlsbuYhb0nSyvfVnxawEvfWgWe7Mpp33FEy+UizBCrJKLqx4iDzqlN6B9BopuETyBr04gzMcwWUmbE9QeBHUCzO8WFe/94mOOXcBHfhNu/dokx79Xjx6wiOBH98AHJ0Ao+ENuPi03n/Y885/9+kvPmIx/wcEAAA=";
    final static private String hd_flowChartDelay = "H4sIAAAAAAAAAK1UXW+CMBT9K02fmIYBVfEjosm2ZC/bfoBvjRbapHBdqaL79WtBTRA1aSLN5TbcntNz2xPmG0WrGSs4LdZs42cMcqbVEdWfc6EUKJ+DEn9QaCoTnFJZMtwq75nSYn1d1OygfaoYLRMcomU6NjEyMcGo3GezvWDVGxxsrR5n1HHLEgxwyKWfSqjeOVX6g0l6PC24KN1SzRP8XaO/DO+wznanKVqhn2Y5ADxGfJpsMcREFNkXabEs5s2uvzuqBRSNhoLmRmR61pyCyneSJlhCVomN5gExuKAFfMQTXfNYSb01lN5W9DwyDu3zEkThpJk5kZMbIjkTGdeOKgddlQT1SlE8Q+XwSUc56oocor65VeSHTkTxs45t3FUUo37oL9MBciKa3CSyNI6tTe+25ubau/Z3o+m434ticjJTbNOrW3tRx/HexZMPCIPb/8HFPzC/17MgBQAA";
    final static private String hd_flowChartMagneticTape = "H4sIAAAAAAAAAK2VT2+CMBjGv0rDCdkYf0QEI5psh13mTjvt1miBJkBZqaL79GthELXEpCKkpbR5f33etg8sdxTWC1SksNiinZkgkiNGT6DpzjGlhJopofiXFAxmkRbDrELaxfABUYa314MMHZkJKYJVpK3jGVjHAS8+L6EGqkOyOGBUv5JjpNmgubu4U4kijZBjnplxRuq3FFK2gUmB+CRfsOz4veQSsjTSNhzs8eI44IM/bF5c8SomdnzwDT7bOELIjdD389CpqLwB2FnPXFTBeU8oGnYjwhEdYdfgeKFitWzl/+whw6RokylgzpOOuzWICc33GYy0jCQ13rHUcnmcdRF4i+Ncc4Q+Y0sqvcSG7s5tcU0sxw7alhLcHRCZIpykTFHlVFbpAqPCxSNUeg9aypks0gNPtsn3EyiB/EGQwJi2Emj+qPUPZEXzNrWpWmrhIEhgFFNzJAPo3e4bkMHC1ftcn7v9nEysEqvNItmjp6pxhpzQaFLDSD7QZ97/2ffF40VxEaWjP5InWaDflDuBkhVGCpQcoTu+OwYoOWOkQMkg+p0kVzYI/4LY4BbNGv7Dr/4AxzJl3foHAAA=";
    final static private String hd_flowChartMagneticDisk = "H4sIAAAAAAAAAK2V32+CMBDH/5WmT9sSBhXBHxFNtmV7mXvZ2946LbQZcK5UUf/6FQWnVpah0lxpetyn37tcw2Aqad5nKafphE2tiEHClFyhzXYipARpcZBiDamicYBDGmcMH7gXTCoxOXICQD+bf1oLwXIrE2sWYB/tRglQbKksKhnNAuygUdjS5mlzMMoWUb+IfYBl4duMKmo10zSAZRJbYQz5I6dSjWmUMi3jSWRf5Xe7pGZU8QCPNYKgV328hz7QO3pDY70m6Hmz2vfpnd8kTlJekKvnUehr65Rx1V5XW+/ghMpDihzJ/ok7T5E5cY9IpF1MlaLhYJvV95wqAek2x5QmuhZhVZoQZDKPaYBjiDgTEVd3nu3rUPsg9i8UOYHKxVRxu9WI06qVZLuNQG49qJmidi2oEcarK1Ajin9MuSFO1ymeW9svXvdOI17nyryuwTsT1LuyMGL0+rnKiNHql0ozev5SoNH7lwKNO3B28Yxr8C9p9unfzfAHbrlm2ocGAAA=";
    final static private String hd_flowChartMagneticDrum = "H4sIAAAAAAAAAK2VXW+DIBSG/wrhalviFK32I7VNtmW7WXfTu92xFpVEpUOsbX/9wGqXltrMMAlIzuE8vOcIcbrmuJqQPMH5iqytmLCMCL4HtTmjnDNuJYzTA8sFTkMY4bQg8My9JVzQ1YWTMTYpyi9rS0llFfRAQhiAU2sAguyEhTnBRQjnkQ8cMI9U9yAotvFExT6xXQgdULc2ar+RNMZ2WWpFKaueE8zFAsc5kTJeeJk1605JbbBIQrgASELegV+PSMr4BEvwARbSEoDXeqavkPbfhG4Q3+Tck9ID2YdNdGsbyT4+2631IJUtQtruJ7+rBu+ChwZq8Bt1s+kx2+8SC8ryY+45zmSNorZkEeNZmeIQpiyu6FokD67tyUj7LPQWCXWRbLcXx73CSQiNE9ET5HWCemEGXXn1ovid1Ql6cYJLzh0KXEc993agXo9OL95Q5zkjA95I4/kDA9z4n+Uh7byb6UPaqTcVqB1/ww+MtGtgqlC7EIYl1K7GnwTa139Lsx8aJeixrwYAAA==";
    final static private String hd_flowChartDisplay = "H4sIAAAAAAAAAJWT207DMAyGXyXKFSCFnmiGqnWTAIkb4AG4C2vaRErrkmY97OlJdwA2VqYksmzF+T87ljLPNOsSXglWrXhGCg4lN3pA2+NSag2aCNByA5VhKsU5Uw3HR+mWayNXJ0kASJr1B2kl70gjNzzFFNG90PDeEKY5a1K8zGPko2U+WoRR0xbJqHmAPsU+2u6DaqgtBaAvFckVdI+CafMkm1qxYX/l+x01MyLFr1YdoRcUWD9WGSOK3tHbT48XFM82imxn1Nrsl34x39X7XDMjodpVr1hpG8wP/eagy7ViKVZQdDIz4ib2qFV6R9L/SMEUyQudOOEZjuCyEMYRFE2CnDB3U+9yosST03GbMj3lXAU09Md17dHR3fpOvNlfnn9/keed/4iLL1bdWE6hAwAA";
    final static private String hd_flowChartOfflineStorage = "H4sIAAAAAAAAAJWSTWsDIRCG/4p4LMh+9rLEBFLoqWkPufVms+MquE7quh/Jr6/ZdAsJu4UwOOqM78OruCqd6AuwStgDlKwCrMG7ExnLtXYOHVPo9BmtF4ZTKUwD9KbdgfP6cNdExKJpv1inoWeNPgOnKUnJc4gw/wI8DJ4JB6LhdCNzEpONvIyEkqariot2iwOnMRljUp2OgYY41IZJg/2LEs5/SGm0hb1HJ6rJ4N+1jsIrTncj5i0YiEkS8ifZk3eyC6s8VLOQX8f9/alQpevVlfjdCq/RXvlW1MGJnIxJdHVrBKcGq16XXj1lUR6U0Y30P1IyQ1KgK+Wj9CFQumTpQU62aOghTL5oZ+59ovk/uf4B6HIFbKwCAAA=";
    final static private String hd_irregularSeal1 = "H4sIAAAAAAAAAJ2Uy26kMBBFf6XEMhJqv21aTUfKOslmdrPzpM1DApwx7kfy9VOGdKRETaRByHdRdp1brgJ2h2DPWzc0dnhxh7x2vncxvMEU7tsQfMgbH9p3P0TblVllu9FlX7ZPLsT25dum9347Hv/kp9ad87F9d2XGqCIEJv0ARHeJuQ3OjmV2XxG4rwQuhktlMJ7qbcp+8JcyIzA917y3V+R5f+m7HGtw9bGz4ZezHf048HmfVxubMnsCSgx6yySPQIVkDHFUUClBciaBGm4ICCE1UKUJA82pxFpJocFQjlGtCCoRWs5XAMpZgapM2mWFYAhBMiopUAVhyWEiciZQC51OEvTDeMElGGGuMK3RjkrFNAitWLKjGqRSKbtIeTwxpdHANRZPqcZCCBiFeSKlTQlcY4MZ2mP5DBTHEgyXbI79hudsv5v78/doY+uHuVuD7bGd1bW7lQ89NrTMOl+f20Ns7pLBZh7cfrf5QvgJSBeB6eYrgGwROA1tBZEvE9NLsoIobhAb19ZNvEvzWEGUy8Q0/hVEtUyc3rYVSP0TEj+UFUiziPwvTLE04huUze2/4f4fw6MCXyYFAAA=";
    final static private String hd_irregularSeal2 = "H4sIAAAAAAAAAJ2US2/bMAzHv4rgYwEjph6WFMQpsPPay267aY38AGyrlZ1H++lH2smADnEOhmEdRPLHP0lJu0N0563va9e/+UNa+dD5MX6yabtrYgwxrUNsvkI/urZIStcOPvlmPvk4Nm//GUMI2+H4Jz01/pwOzZcvEg55lrFpvQJGfxlTF70biuS5BPZcKvwF/jZhw6naUvSPcCmSjE3fLe7zHXkhXLo2RQ2+OrYu/vKu5VeHf/W8u7EukhcGIHPOpJCc/WQgtSUcSMUVU1prBibLNBOgOYNcmIzlSvBZK8tzqXDXGsWszNDBcI3BwBEyOwMXgKsxRFI5RmI6SQmEotViWtCCojiQv7ICkZAD0QxardE3F6MxJ1iNNq04SQNUKS3oqx5pMkUiKAFHUaANOgghCEyEaR+liDmLsoimyibd6IFggzSpsBiRY6xRKBMrQR2aT5I0+81ek/1u7ubH0Y1N6Ofe9q7D5pe3WZQhdtj+ImlDdW4OY/1EjM085v1u843wCAiLQJK8AsgXgVPnVxDFMpHmvYIo7xBr31T1+ERTWEFUy0Sa8Api/kAjnbMVSP0ASSd/BdI87KRcg7QPkHSD1xzye9fmNh58Z9YgFy/OHczm/nO//wsujUHYBwYAAA==";
    final static private String hd_star4 = "H4sIAAAAAAAAAK2VXW+DIBSG/wohu2i7koKzX0udya63/YDdkQpKotIh/dqvH8Js1+KW0CxGc5Dj874HPLrKFN0/srqg9ZplKGeyYlodgb1dCaWkQoVU4lPWmpYJ5LRsGLyY3jGlxfp6UrODRlQx2iQw5QuQckLMZdkGEQTNLn/cCbZ/locEYmCP7snjhiVQykNVokZTFXdyMhNcMGWAJJriLv3kfUN1kcBXQzISGLyAH7Jze3fZDcnU5XR+bIYJ4u6ZCLyDN/i0cgofW6qFrJ1eTStjj3fyXKpqW9IECj7A6A6DMR6b0PjDbtiedjQcGuDkgviXALkWKGW+F5kuJlEQJ7rmmPLAKOUYTKytINhDj6mCibzQga5i39XDza6mPiwCo7VsBhsxGkRzbJd/QvDCRUHwmQ+PwagR9X/A5/+0yQvf5BzcY5TyKQgCLXtBLQaF7QnxGuTWV4V4nWB711Y3C6uO9DUDbuubBdfntcLZVRzoymuG01KFcbw+6N6m3zDmy5mVDPyI0UY2os1wO5+e6/yeV7TOGTqiih5Eta0S6Nq1P0fULue8tC7jZOf6v/P0BcR8clmQBgAA";
    final static private String hd_star5 = "H4sIAAAAAAAAAK2W227iMBRFf8WK+kCZRvg45FY1RerzzHzAvFngEEtJTJ1w69ePnQsUYiqZAMI4yWF5n8gr4m0l6f6VlRktl2zlrpkoWC2PqDldcCmFdDMh+Zcoa5onTkrzijkXl3dM1nx5fbFmh9qlktEqcRYpmSM1RHoI1eBhB1W79euOs/2HOCQORs27/+1xwxJHiEORu1VNpd8vKFY85UwqJMQ4jhBgH+YBAvXth13RqZcNrbPE+aOWA6KHAP3W6/t9EgC1pJoHpxN+W9aFJLE+1MEhbMt1cD3z+nNtWzH6h/4672/t8p9bWnNRtmFKWqhO0r6xVMhim9PE4ekEu08YveAXNfWxejWH+tMcPT8r4OyC+NMCcL1ALtZ7vqqzGbHikGuOahRNnwDNQKfCVjDPECpjfJ3Vlqnmw1SeSkXuSuU/KlUwTOXfnSocwgiaLkU12fDpBHDUbIpZN8F2uyP6GR55wRh6PKTP0bTi5SOiw0CdS/rI7PAoccBkDqBf2F2kIbJDDbw5oyJLlMEcjdIg126DwsCbHhVaowzmBG1/sWV/Bm06EmBLlFmSRYrRzLfWGcxS3EkjBgkgOhtMsE/GWEAGFlzyPTIfhTe5EZ8lHos3+fINP/ru3JBI7zJiucvIDYsaFliyDBq1RiqSpZLEIFLHwtYsg0mdlIRYtmjQqEd5dijP4FCgG1RbxbJBz6BL/9S5/QBT/0pXOUPf5u5GVFxXdHd7cSZ3BZKWa+Ye3YIeeLEtEqd9dphreNnWnJtpK055rv/kv/8HJbJgIP0LAAA=";
    final static private String hd_star6 = "H4sIAAAAAAAAAK2W247bIBRFfwWheUjSQQHiW0bjidTnth/QNxRjG8k2KSa3fn0xDkknOCMxbSIjMIfFPngfJ6+FYscX3tWs2/ICVVy2XKszsLdboZRUqJZK/JadZk0OS9b0HL6bPnClxfZ+UvOTRkxx1udwU5IImGY9NKlpKIagP1QvB8GPX+UphxjYr1t73vEcSnlqG9RrphK3oSxEKbgySJplSQYIiaPUrbomsWO6zuF3s09srgx8G7aNnYDIbGS6iRsnNuYiLL3cWLsQiu0S06GOYm/FLiiyq36CH/DtdZTxa8+0kN0oqmOtSaV0Gkup2n3DcijKGUZPGDzjZ9ONsfnY4XDZ0XxugMt3xI82IPcbNLI6ikLXSxrEofcckyJYPBGwJIMqHARb+TAKFlvZz3ZiMSOZJc4N+dILgkf/KePYFxmBLxhtyhUIAiWToAGDwo4tncis5qKqdWBq2WNQFARa+6mlQ2pZaGrEKwRriU2JwTIO9heZcv2nTopM+Z58XtiE8wkGCxIqyzP51ZwGF4Z67HMSaHTyyOkk2OrE87pD4WCU53ZDMd7qRWdfN6vkn143ZLoG7PllYedHJ4rAlhMJrifqVcBNFQ1U5ZXAtZgecczvbdFw8Fcf7WQvhojxQW5uAi/zinUVR2fUspNo920Ox+KajhHdGHM7kzHiKuf+b8vbH4edXVzPCAAA";
    final static private String hd_star7 = "H4sIAAAAAAAAAK2X247bIBCGXwVZe9FN1woMPq7WG6nXbR+gd2iDYyQfUsc59ekLJvZ248lKOE0UbDB8/KD5h/hl3Yrjs6wLUb/Jtb+RTSW79kz65kq1bdP6RdOqP03diTLzclHupPfh8UG2nXq7ftjJU+eLVopd5q1ySMkq57EpwBSpR3aHzfNByeO35pR5lPTfYex5KzOvaU5V6e860cbDhM1a5Uq2GsmDiDLCKIQx6EsIbBg8rmUruiLzfujpWKALYOS7uSRmflOw0FSpqdJBHeOkv2djQzJ24uPA1OLGxZg20xnAIlZ5YEawaGizy0/JL/LTe32xMn/vRaea2oquRaVXnA9ryJu22pci81T+hfoPlDzRJ30bUv3pq+bX1x4fNXD5gfjZBOx6grLZHNW6K5bgxIFrjl4tWTwwsmRGFXWCcURUIdWm6BxVBVNVXKuCWarC/6UqmqoKZ6uKpzAgizQOUj4Hl6C4OGHJLFyK4gLOk2QOjk38oJ1FFhHwIJ3Fm4R/zwOAEGbxEBtoXkppGs/iYU6YY0+GOEHnpa/UX+UxcUNNfPCOShxRiBMGVOqIQnxgUAbkO2464gGLSpxRSPxbVOyKAiT0I7tVjLrtFSBRHxlRjDmrQgLeosAZNYn1PlesckqWobNzAAn4YD4NiXngd6RZQCLfAGcnWsDOAX5HqoUbLjABB6FjwN2wQc+K3Fgc8cHIckxlHDGCtSc4+5Nj/4AsK3JmIVa4sEJnFmIEuOdM4pgX7jk0OeaFe051jnjhkip54BghiAsGlKMJOGKCPlVy5/gI8LOg3zZXFH4W9G66vVf6hWpdSvLPvb9tdsr0uMTq6p186dCKeiP9s1+Jk6r2VebZNIz3UbXt874Y22PUc/1++voX4ljCobgOAAA=";
    final static private String hd_star8 = "H4sIAAAAAAAAAK2W246bMBRFf8Wy+pBJB8U214yGidTnth/QNysYsAQ4Y8itX19fIOkEt5IzEQLZ5nh5H3w28FpIenxhXU27LSuCiomWDfIMzHDLpRQyqIXkv0U30CaHJW16Bj/cPjA58O3tzYGdhoBKRvscbkqcgk1JsL4gfYkg6A/Vy4Gz4zdxyiEC5pjmnncsh0Kc2iboByqzaUFR8JIzqZBhGqMp/KJ+R4c6hz+AXiID38G0LlGXSJ1rPZJNSkITh9dTPx4jrEI9hyQGNA2FYxC+zosMRzXSCzoaF7NRqZ34C/yEb69W7fueDlx0VntHW5VqOaVSCtnuG5pDXi5Q8AWBZ/SsmipXZLv6NL2nJwVcfSD+bwF8u0AjqiMvhnpFvDjklqNyBMut6Bc7vlyQFBltK4wy2/KChw8SGc1FhuArCtRWAC9Q7ARpTIC8QIkjs5rxqh48U0vnihKw7Hn3iOefPUrleq4ysxuQ+m0AnhnDkDTHcwfwzAGmcjclAitjKD+awwfJ/bRZ4SttStyahFmm9tIf6HCABoYZSe4DOpyAyWcUzhxhgfcrdDhjND0OPYtu5oMrKvJEOZxg3iAK5FnAxGEFiwq9UQ4vjP7EsV+CxGGECZV4ohwuMF5XIN8EHfVvUbE3ylH5U4KeXxPi+gqY75sfZlbpl9f0vzjq/6hoGPirHexEz3WELaPNNc/xvqRdxYJz0NITb/dtDu1rzR3DOxtzfbQ24iLn9v/y7Q+ipUk9eAoAAA==";
    final static private String hd_star10 = "H4sIAAAAAAAAAK2X226jMBCGX8VCvdhmi+IDDlCVRtrr3X2AvbMaEywBzjrktE+/tjmkDaaSSROBjG0+Zib/zJCXjWKnZ14XrH7jm3DLZcUbdQF2uhJKSRUWUol/sm5YmQU5K/c8+LB85KoRb7eLDT83IVOc7bNgnWMK1jlB+oQTM8IB2B+3z0fBTz/kOQsgsN/+3suOZ4GU56oM9w1TqF+o5EbkgivNjDAlBCBIUbTqVgcvdqwpsuCXftBKH4iCn+C9CbGZjMyUWSZQnygwZxz318mwJenvSluUnrIj0k+trk71N8YDi1i2HtDhcaS3IB6Mwr2llhW1+D/gd/D60jr298AaIevWzZpVOjp5H5NcqupQsiwQ+TcYPkDwBJ/0kEL9sZfmsFePjxq4/ED87AHo9gGl3J7EpimW2IuDbznaPbB4QGCJjFXQC0bGMAwWKUVwNQcXOXE0ieN0Do5+UchWY7Mo+A5DrRXgBYonQZEfKHGCDCb0C1E6ASK+IDRKAB3sgott0XhGG42UrhUKwSKBKcRzZIBcktdAMhs4kv1sXx2K18XGSgIhP02gkdzfsbAnyyF5w7IkX2U4VN+xkDfLIXxdIdY5BEvq/zs61G+EMROHRymgcckdwsWuTEjuEC52ZUJ6R8HGjgZggLNLNnYkRFcited+KEc+dCgMPVHTHQB7Zil29wAL8kwGPNUFtHu+qKk+oIPuiSKuLOjKEPYsQ8SVAD3Ls/cSl/ZtGcLezY64ZN+yvMsj+awFpJ4+ut542sY0xdHv6JuSg3fjcCf3wuxoRbC+WtitK1ZveXgJK3YW1aHKgrZUuveIut1zDUq7YzDn9r/O63/KsGsbBA0AAA==";
    final static private String hd_star12 = "H4sIAAAAAAAAAK2X246bMBCGX8VCvcimi+IDkLBaNlKv2z5A76zEBEuAUyCnPn2NwSEJTqUpqygWhuHz72F+G963FT+9iTLj5UZs/Z1QhWiqCzKnC1lVqvIzVck/qmx4nngpz2vh3V0+iqqRm8eLjTg3Pq8ErxNvnVKKdLNqm1A3jHioPu7ejlKcvqlz4mFkfvbey14knlLnIvfrhleE2hHVVqZSVJrJliG28Vf5e95kifdDo9ZpjL63w5G2iXUTteMG6FYLW+qGtMGUtU3bDc3NNLD9ISS0t62upMjCWWhG7E8x3EcRMszYsqjFM2qG0weRVWBOsSGM2jujK4x0/F/op/fx3s3+94E3UpVdLkpe6NylNjWpqopDzhNPpjPsf8HoFb/qQ5073HXbv+m9vGjg4o74rwHI4wC52p3ktskWFMShjxw9UTTfqHq2l/MZWWGjbUFwfwSCM4fITMhd1gBVBmOVDM1rWRqVLJqkMvykVEZjkSH6in1dNQgEWj4TNGeLAERaOSW1gnwMAsWf9STJyBmtcU2WAliWiMsCnSZwnojDBnGbqACaKDKqeWOodYrRwvgcRnMX/v/SRpWutbHB7fEkGxFH/d/S6XIafuSKe3wQTsM7rEKCYY2Zih8Z6B4/MTnU4apb/LQnS0dOu65sJISZljqMZlEREOVwmkUtgSiHzcw6qUFA/1OHxzpUBEa5NxSTdCjKYZ5+1SUrYK4cRrGoGIhymKJHUQxDMfe2YkDAXDFHtRuUnh4U9Wxb0UmHohzVbtMO3DjZqNqHzRy2bbKnr04wzKjQr4JgnKcvTs/npb9ctrlAN8f+XtWyjej8th5S31+veLkT/sUv+FkWhyLxup3YHSPLLmZ42l3EVc7jp9/HX9p7LZcTDgAA";
    final static private String hd_star16 = "H4sIAAAAAAAAAK2YW2+bMBTHvwpCe2i7ovjKpWoaac/bPsDeUAOJpQApoW26Tz9fYmcNh0qHtlEdMObnw59zsXO/7svXu6rdlu1jtU42VddUQ/8W2e5G9X3XJ9uuV3+7dih3y7gud4cqfnf5peoH9Xh5caiOQ1L2VXlYxqta0kg3zDTcNCKODi+buxdVvf7ojsuYRPbj733bV8u4647NLjkMZU9TP2O3VrWqes3kmSR+fDB/Xw7bZfxLo1Y1TaOf+oub+YQwHba3MH3mVJgL1NhFc9MnTZ+xkNomM32p6TNDCovkmT+nPIzJw30isIrAl35OQbwdMnXW+T7pxzES7k09j9EwR+bnZSzYklvbNPNsbu4fwQ2T4VYacCJMQcK03JnyJ/odP9w7VZ+ey0F1rdO4LRv9Tmoved31zfOuXMaqviLJNxLdklt9qN8Jcafm355dX2vg4h3xowno5QS7bvOq1sN2wVAcdsnRTxvdFIzn+YIauwgKx0FcRjJK5+AEiOM5S2dZJwHRtpXabAekaunYLvkJ1TIQN1u1HMTNVq34Ilejo6AwQfmdJDq2Ihxp5P2BxJEkwP9PJIEkAa6vSYaT4PSmgNdbEkeTRg5/IjE0aeTxc0OHAs6us7yVPEVKDji6R2VI1MjJz6gch2KAmxuUASFVZ4CfO1SGRkGJ3qJSNApO8quaRAuJzi4M8HY5nwZ4POM6NeckK+YkPwakegPMORXZLCDg/wYo9d88IBAFBkgLSeY9MhALTHxCQw5EhAHO1pADcWGAszXkQHQY4GwNOVwNbK2TuHzC4XJgUciEyeF6YFHIhMmBuPAoZMLkQES4KoVOmByIBYdCJ0wORIFDoROmgBc+1hWwqImKYHUvcLqLiZJgl1EEyYJqgmdRJAta9XsWcqUoAI93ZY+j10ACcPkTi6JZE6sgqzyWNbEMsh6BZUG5XxeTx+5wtVc3VyyzufBa58TcHeE2YBOV4KDaL8FP7wsEMjjkB8EhkcEhJ7cG6PcjJ2LDGoVlTcSGzSXI3Y+E9gd2k4jDjMIibDOmONuyXe+q6L/jZN8dlBnhdF6dH/R0vS/bTZW8JU15VM1zs4zdOhMeo1o35qytGxHMufxN8OEf9Q+pxiwUAAA=";
    final static private String hd_star24 = "H4sIAAAAAAAAAK2Z226cMBCGXwWhXiRpUHy2qbqN1Ou2D9A7lGV3kRZIWXLq09c2a9KEMdJAFIUsrPk89vxjzzhft13x9KVsDkVzV26zfdnWZd+9JP5xXXVd22WHtqv+tk1fHDfprjieyvTN149l11d377/sy+c+K7qyOG3S253Wib0Yd8ntxZA0OT3uvzxW5dP39nmTksT/hHdf7stN2rbP9TE79UXHROix3Va7quwsk2tJQvvR/PuiP2zSnxZ1u2Mq+WH/SGovyvVMlb1wdyuZe+ZMou7CXXPJ3TPXhLrGzJkphXsm3TN3y9wX0t0q9wXzvTiAdK8pB6DS9y11eMDo2MiML7IRlocOGA+dKhIMYSIYp2gwmMkwCMXCwIwYhhue5WM7Ft7VZOTx0IemoV8ugi2aBfu4DDbrcRxchbFpMQzWds7DBOhxUoZ2MrzrJ2/gidCHn+ShXx5sGZzBg4O8zYPT2OjIPPmd/Eq/fR38/ueh6Ku2GVTQFLVVzS6IYtd29cOx2KTV7oJkn0hyTa7tR6saMty6X393eWmBN2+Icx3Q9x0c2/1Tte0PNwzFYe85drTJ1V17urivri5y4k27ocQMn1BsPsumZhVczMKZXgWX0dkVKI6aGikTFEHPDlPIVcM0wDAPZbU/9EgV5VMrTXJ1qpqPsJJOgukNnat19EkkvaGvFBKdxNfrFOOkRKFoYjgxUSBo/hvrumin8aDBiYkCUWNX+c8ksys7csBQ+JxRHImaBMsrSiBRQLgElMKhGBAbAaWRKCAQHMqBMoJDQbuKRyk0CpK9Rwk0CtoyPIqjUROtBxRDoyZqX7oIM0DsNiHzWsiRWgDEHlCUIFmA2kcWxbE4IPeRhQxoDuh9ZCEjmgOCdyxPQgqCA4o/s9A65YDkzyyKZgGaP7MImgUs8QMrR6PgDOl2R5Ibn3fgaIDwzXIaIH2uk6s8p0LYbRYNFID+PZBxYxYBgSBwQJ1zLhcBgUhwQEWMVouAQDg4IDdMLRsyEBMOSDmRfBEQCAxu1ngZiA4PXOxlIEYccLmXgTBxwOVehiLFrPCyhCLFrPCyjKRHPpVEbq8ykh/5XBK5vcpIguRZyO1VRjIkz0Km3jKSInkWcquWMxWBQG7VMlISeBJy75GRmsCPEMuKFAV+5pEsFakKvCKwrGhZINDbvorWBRy976tImuQ1gTxkUZE0ybOQFZmKpEmehSzJVCRN8iyDZM1UBwK5fqmZ8kAi1y8VKQ88CakJHSkP/AixrEh54Gcey4qWBwJdW+toeSDQxbWOlgc2grAsKAvSH3YiqyM50Qed0+mZgyKNPbKdiQ6NXE10dFfQaA+ZaHRotHLMTPHMkSuTmURHbZ0aDg+vx+OQS+R5iJlEyojCcSZREmyLYQ5Fsz2WyX+fs/v2VLkWZwfevs7guUFXNPsye8nq4rmqH2pfeLJIk6oZmrz6bGgxmvP+P6nf/gE2M06WYh0AAA==";
    final static private String hd_star32 = "H4sIAAAAAAAAAK2a227bRhCGX4UQemGnFrzLPQdRDPS67QP0jrAoiYAkupR86tOXM9RuEmuWwJBOEMUkl9+e/n84Q/nbuqtev9bHXXV8rNfLbd0e6nP3XuDpQ9N1bbfctV3zX3s8V/vVYlPtT/Xil8svdXduHj9ePNdv52XV1dVptXjYhFA8bKQQ+Cnxs1wUp5ft15emfv2jfVstRIF/4+3vT/Vq0bZvh/3ydK46VcZO23WzaequxypnRGyfZvBUnXerxV8FdKXK4s/+P2v6D++hV/hQMBZr4ZyDc3Co4IKFQw8XSrwbDi1c8AAoYdgKrlq4w2s4V8I5uOrgDq/gHHwouOrgDg9NSjhUcMHBoccVcDhGp+KJ0qRGOt1oE8ykDlzq1KaB+Dg459KAQ5yE83FiSsTJuhAXQMm4KF6khRJ2WL94MsSGWsSbg4hALWMnQcaOdRkHE8o4QK3ioEOaiE6TCzpOWJu4CMHEhdE2Llaww+rBKE1cUjyJyzw0lOlmlYAidVLGjnErh8HIOEDc8mHQIk4EpYGTQ7nghFFCuAgoK1yYQWqh+Kf4e/H926DMf5+rc9MeB50eq0Ov602U7abtDs/7arVoNjdi+Zso7sRd/2OvazEcwj88ur3tgfe/EMc6kB872Lfb12Z93t2XLE75kdPPtvgSvHDhXsK4BAunaFypvJ+C0yTOK6ndFJwhcY/t6eap+XJTOiTe9mQ//MSCWxJu+j+TxupInPKlnbSSnsTJYMSkfQ6E/HZ1s92dmfqTV07pPTdDgPLKGANvqgIlYZAwQ4KScEjPOzXHz9CgJAwTZohQEo4JM1QoCZOEGTKUVy6ZGAYl5Q9X/C6W/VOi4KGuvPEDpXiokjBHRGkmivBFRBkminpmXFCWiaKeFxeUY6KoZ8UF5Zko6jnRowC05Am0pJ4KiHJsFPVEQJRlozJqBylwURm1g0CZKJVRO9iGi8qoHczMRV2pfeqjThFi7zNwVKgUPIkqQu2JJZksQu6JxQx+itB7YjGjnyIEn1jM8KcIxScWM/4pQvKJxQyAmtA8sJDEVKomRH9hsW2tiRh/YbF9rTO6R0VwWRndo1K5rIzu0UFcVkb36Gwui079HzaiuDf8EopQfphOI7SvXZ9fByMnZYSGMAACjQ16EpBwAQC9l6GcBCSsAEDnlJCTgIQfAGiVVpOyYEOYAoDaSS0mAQlnALAMopy2y4Q9cJe9mLYnhEW0nyNDwiUInCxDyih+hgwtZRQ/Q4aWMoqfIUNLGcXPkKGljOJnyNBSRvHTZWgzhQLWZ4GXCdhMpYAFGjM7tJlSAVnM7NCOVMaGmR3akdLYMLNDN1IbG2Z26MaKY2Z26EaqY8PMDl2mPEYSM6twmfoYZ8hlZQtkw84OXbZCNuzs0GVLZMPODl2+RmZnhy5bJBt2duizVXIfcbisTMWAWmW+f/GZigFZzBcwfqRSNsy46kcqZcuMq36kUrbMuOpHKmXLjKt+pFK2zLjqRyply4yrPlMpI4mp1ZCtlC07ToRspWzZcSJkK2XLjhMhWylbdpwI2UrZsONEyFbKhv1GNGQrZcN+JRqoMsB92jd6IVMUfNKXNWEkGwrM6CtFxh4IY4ZfKbKvTwN7j/AXQegND2zxSDHyZNDsaV5Z5NDvbPwG6S69571lf6d55ZfEYoKuzBJHl+PsquN6Xxc//bx8ak8NtLjs4sNPq3hp0VXHbb18Xx6qt+bwfMCGaXE+tmmOQ5sfOze0SAP6+LtG3/8H13ORJoQkAAA=";
    final static private String hd_ribbon2 = "H4sIAAAAAAAAAL1ZUW+bMBD+KxbqQ7KWxTY2kKpppT1smrT0ZW99ow1JkBLcEdqm+/XDNgScg6qOo6UCjH189935PjuhN4siebtO83WSP6ULf5WKbVoW70h1b7OiEIW/FkX2V+Rlspl5y2SzSz1j+DUtyuzpeLBM96WfFGmym3l3yxBhdLeMqoPEHtq9rq5fs/Ttm9jPPIzUX/PY+3M684TYbzd+kT0+ipw23sQiW2ZpUeGRMAwjxHH1qQcPATwn5XrmzZU7ytAv6TFo21N5H+purNjoNmv7g9q8askGbrrItImgaVBSY2J1DfUYbkyofvwB/Ub3aC57ieyhgAjRRB60EW2NNMXaijZWNV4nwtrTwXPYbdQsCa5pGiGoRhueGbFKgkpNk8kOn2kne4HufmijbEbqiEFgdTDzhmPQzeC8JdcQrgy+o3s92UKIT833j+oS6wRUJy5PYTf35rjyEhuVYRqo/GCjXAyDQJ2ofQ2ZKOohfigsc1AmKIjsqs1EkK1gOpgGJvEY+aAuTXPZyQKjOEwDGQ7jRxX8076ETVTZyaK2rs1R2WJTl2I38Li04WQ4SC7J86ArC3NconJuaMU0kPHw6D8I6PZGL5d/XpIyE7lePPNkW625y2YtXYpi+7JJZl62HGH/AqMrfFU1A/lRt/JQd+NxBTgxED9yQHocULmK+xcEXamWdBQduuSh7iwd0WNHG7F6yxblehJb4QRDOJfYlyVrBcaGwL5UE4UmFKvtzAaRD4ZJrXDCY5yqGJEKkdmFGPUCSRjfLrJ4MLLALrQpZBRKRrEtIwLUIXWlkhTbJYkAGdScqDUnUOcHTpa1SUClq6XnpPBAnavV6qSc9xX4Os1W67LSDD5JMwQU+wFTRUu4Zbig5o84khM49pV/l2NkyRGoAF8qFMv5oEADI7XHXB7ojS1XHgq0cJQ9Zp892rf6d7JX7bh2eH3aCNFpWH2bgOZmhwOUMeI6VeNJKC9fLXMGVDHyCY5dEIEuHBkCTYwcCQJRjEhIHQADqA43hgEQhytDoAzXWQ4GvyHZwQBZjE4lBIXhO9VdAJXhOAlQGI4MoTJORYKScKPGoCTc8HoU4VS/DCrCERAIwjFiqAw3vB59OEbcIxA3wDPvHKxn53BSMIMycSLIz6wSfm6VcKgSN4JQJI5FyKFM3OaYn10n/NwbCYc6+TTDdZIvNinqtP1nscukhf7Rftf+CKnHiyRfpf67v0322fZlO/PUG6ABmyzXNi0BbfE59+qFFuuD3rfu1XuhAZvGvXqlBCjUGTn+l8ftPyOayMMLGQAA";
    final static private String hd_ribbon = "H4sIAAAAAAAAAM1ZTW+bQBD9Kwjl4KShZr8wjuJE6qFVpSaX3nIjMbaRDJsSkjj99WV2wRgGki7rSnUE3o/hzZvZebsyuVzm0etFnG2i7CFeeutYpnGRvzlqOE3yXObeRubJb5kV0XbhrqLtU+y2pl/ivEgeupNFvCu8KI+jp4V7vQqc6xWB26y8KHWdp5f1xUsSv36Ru4XrO+qvfvLtMV64Uu7SrZcn9/cyq/3JZbJK4rxEJEEQzBzhl59qch/CY1RsFu6NgvwBblnVmENH6DFf81Ft3owz4sAMg5FQ98vWrOK9b9AGkFLVDPS0X1tRjXDn/HRunRvoKKQ5IkI0kTttRBsjTbGyorVVhfd/xNaNqw7m5oByQ3+uxiuwGpcSNTrTzR8Nma/OrV5YKeUHa/utbITaQ4kC8VF+mJT2vIBb0MpU20BxCVvpaxvAjfmGOW1BMEgIY4eJbs+DXybMKquNAI+x2WAamGI7f6cGW+Yc3HPSKsy2ATzFWadav/eVa/s5iJSLQZ4c4uCz4eXi0OLz4eUS8JQgNsslICAxvFwC/IoPlutfi+XqUm+Dv56jIpGZ3hSzKC230lW9R65knj5vo4WbrCa+d+I75/552WTwUV24VO/0tAScthDfc0B6HFDYnb0T4pyrFjia7YfgUj1DR7TraCvXr8my2ExDIxw2hPPJ92DRjMD4ENhZuTrOlPrqmDJBFINhUiOcoItT1qmjQuRmIc56gQDGM4ssHIyMmYU2x4wCYBSaMiJIHaArlaTQLEkEyaDiRI05oTrfczKsTYIqXW09o8JDda52q1E57yvwTZysN0WpGX+UZggq9g4mGYGJ6n6PqTJY7tlmeKj81f59Rgx1TVD1d2Ll5rFSpINOrHOzWGmPGsp8jcPq2/c1NzMcpIYJCXStnU4D+PpsmDSkiQnxQxtApAxbhkgWE8+SIhLFRHAbPCQKa4ZIHnYMGZKG5SozpI36GDSDQbKYjCWEhWGXMawLOzwsCzs8rIqxSEdWA8NqsNsAGBaDpbz4seXAkRwmnlUSORaGXRJ5z8FhF3LPwWHHsOfgsGOIJWLJECvFthCxVuzK5uhSEVgqVgwFVoolwaMdIeLIR4g48hEixh8hmyhbbmPnoO09yqcELPQv4evm10c1n0fZOvbevDTaJelzunDVa5UBmyTTNg0BbfF37oP9m/MW7q7xrd60DNjUvtVLGuS/Skf33wNXfwDUuuCrNxgAAA==";
    final static private String hd_ellipseRibbon2 = "H4sIAAAAAAAAAO1ZW2/aMBT+K1bUh16I8BVIVYq0h0mTRqVtb31LSwKRIGEhbel+/XyJIcQGeqI+VhXBcZzvXL9zbHo3K+O32yRfxPlzMgvnSbFKqvId6elVVpZFGS6KMvtX5FW8HAdpvNwkwcHj16Sssuf2wyrZVmFcJvFmHEzSCE1SzuSFqAsbBGjzOr99zZK3b8V2HGCk/+yr7+tkHBTFdrUMk+UyW2+S39nTU5FTK7iYZWmWlBKaCowxUheMiLqpl+wsWsfVYhxMJfwkFQL9kl+UqIvWRo8w+omMiozoBSM1FDttiX5OqFmrEbhFEAODq1eoWRbZWWqkcYXGhxaN12jMeMSKExjtvGS14UYbzg0ANpj6bWwkPaI/6AFNrSWCmqe1VR+3qR7J93f68AboI6rl4IaxtQq4YSm3lkZ7QyOPndb4vSNIy1XWgR632iDuQmCN2KG1LY4aBpNGEOs0qI161H5srK2NmPoix8hRr0/bKtWe/Y4eTG4WRfGVnp+bnj++8vNT8vP+zhTPvy9xlRW5KaV5vJLlOLWVNS3K1csyHgdZeonDC4x6uCeHRJVgc68+5vbqSkL2DzBPiSAeEbrAhxcE9fRIiRruptRH3wEF0bYgo+4NDicpRiAo1oaSjkXXpE9BKNxFwUirw2DqiDbQKt5e4p7MDgRz0cATC5knKLygqKcGPT2BzYSZxAgYh2FbyLKYv2WzanEt8xL1qY4KCHF0DBEYkMgNyMgEZAgLCHF4s9NoBANy2KFKwI2udCHMScTJf6uTtlBWChicw4EDuAiI5nDhUDkgP4nDCAm3SLL5opJJNkB9Ak8y4pCDq4QVqG9VhcE5NNAxuNbXjpAODzSY8SA0gz1cIAOt3ki6D1Z4fWww0TC6AZOFekihXAetv9RhhLVRdmGojT46NGykFGjjaUJQIFvpSULgToSgDiH07siEVAD187AhUpGIOnKBergQGd0okAr0KBUomArMoYJE0QWdDqAFnTk0OEw5Bt3U+OggrG4d8Dy7JEZ18xJgWz17JcY6+u04F4zfONBOhwct6gO5wHydQcjyxvuyB4GQHBLIzRsbKrexAboClkvm8KDltxHMTn6UCwwcU36GCxyYu9zDBZn/3XQ70xo4sDVwDxeiDqcPhwa2rMkjM7CscU8r4KKju3zng6a7BkB3HT0dGDgg27mnG8iK0clUcWZjxIEbI+HbGHXsLsJ3XGjoJoA7EOE7M5vuIlAXPN8Gqakf9Ax9vCvAcHzd4OT+ZRHns2WCGuNwXWwytcKcQCf7FlM/L+N8noTvoTznZ6uXlf0p48iiLDeL9glgVnxMfoS8uNuPCN/uhesfcjoooH+aE2fMn6TnbJcJ4Qivo9H+N8j9f/29u5IfGQAA";
    final static private String hd_ellipseRibbon = "H4sIAAAAAAAAAO1YW0/bMBT+K1bEAy2N6kvSC6JU2sOkSSvStjfeAnVaS0ncpQHKfv18SdKLXeBEe5oQqpXYJ9+5fsc2N8syebnmxTopHvkyXHGZ86p8RWY6F2Upy3AtS/FHFlWSzYI0ybY8OFp+5mUlHk8XK76rwqTkyXYWzNMpmqeUqYHogY0CtH1eXT8L/vJF7mYBRuav+fR1w2eBlLs8C3mWic2W/xQPD7Jo9MqlSAUvFTKNMcZIDxgR/VKLtA5tkmo9CxYG/4c2AuuBaEvMMEXfUW3exAhMtH2ksVRN6nVCraxBoA1CNFKgZjnSH0V2Sj1RIxhpVWzaOh1bWRuAVldEav1qrjFFieplNrYA2GKar7HVdI9+oTu0aNyI6tXapY87VD9FdG8POwC9R7We/y58i73sgQeLU8NrzW2ga4eb+CwOAnjo6Fd0ZwtRSvlZi/+qFr99FmPXYry9sW3x91NSCVnYJlkkueqzadMzU1nmT1kyC0R6icMLjAZ4oB6Jbq72Xf/sa6+nIIdHmG+pIB4VpnWHFwQNzJNWNW6n9M+8ARXRU0XW3CsczlOMQFDsFEolAvXJkIJQIhcFI2MOg5kTnwLlye4SD1S2ESxEI08u5mmMwguKBvphYCawnbCTGAHzMD5VksnVi1hW674qSTSkJisgxMk5RGBCpm5CJjYhY1hCiMOb1qIJDMhhh24BV6ZBhLAgEaf+G5uMh6pTwOAcDhzBTYFoDheOjQPykziMUHBrLlbrShXZCA0JvMiIQ45IF2yMho2pMDiHBiYHfTN2hHR4YMBsBKEV7OECGRnzJip8sMbrsMG6Cu2X1EMGa5Pa7aE2vc0GCiw46mNDW3C4U8FRz/6g7kk2nTHQPocQmqJ9PXSrNeqwwTQmEzuobT4m2LSOwGn1UICOdcOkEbRhUh8F4gbLHL1ghwYPDaht5jHUNuahAsPd/GQ+KtjatfkEnkaY53SkPOyTaKh6KAjJYYA6fDCm3VTn5B6wfTAPB2xtKDBozDzlr+qhG5an/qfw7sh83d/QSN0vgDRintJnHd2Lzp6F7FEXuDFFvsonHU1zKt9cijqxKPLdCUypqjE0Fy8Ynu9EdMBK6A4QnT8SwXCcyn9v/1gnxTLj6OA53Mit0BL2hD3fb5/1epkUKx6+huoeI/KnvLmqnREShRXaJ8xKfEy/vlG3wTmC3u31m/vmGZlGvbmqdjBBX/XbbJ8LwDx9z3t1PXOU1/k4/Q/u7V8MF1tW2hUAAA==";
    final static private String hd_leftRightRibbon = "H4sIAAAAAAAAAK1YXW+bMBT9KxbaA+3KwMZAUjWLtIdNk5I+bG99o40JlgB3hLbpfv38ARQwWetAIhx/nnt87z0GcrMr45drUqRx8UB2zp6wnFTlK5DdOS1LVjopK+lfVlRxtrKSODsQqzf8TMqKPgwHK3KsnLgk8WFlrZMlWCcQi8ITRWCBw/P++pmSl2/suLI8IL/N0tdHsrIYO+aZk5Gk+kX3KS/u71nRWGY7mlBScuzA4x+gShiGYVRPabf0GFfpytoCaTgEGyDYeKDDCfmqJoZkG/HCl4XfUEawJS/WoYWoRe3ocrBY1PxANGWfB+7Ab3ALtrVZ3tGZfwfaQT8URTRAE8Z8uS5QVDZj9DsrsCCFYa9LFr5cqrNvA8PJbFvMoMtDdGNpRXU3O/sObpXLGWPneP1Hb6tiit8j3gRi8+FQvG3mbSN9K3V4uttoA1NTXHRCptweDkDqUI0EatMJ1R34WeMYuuKdGM7kirGIjrmi64bu9rbtukjLiq83Sol/nuKKskLpsohzLu6k0XrCyvwpi1cWTWzP+YTAlXfFq774yKa4ZOviggO6PcT/GYBDA1AcEd5nz1knHjCCQuNcvZor9xCQLXGJhiFTfwifsf0L3VWpi4xw8Ekc3wwoGALxpAbScdjMceEQKKeF3bC64pWUiKPdzF3ReGAv10kA3HUSmlFcjMcWtrGNgGyJSzQMY7vUXRkCTnUBXEXbLKc11TTOlNFZmm0dahJpI8IZIuCiMxhqWuliesB1zgEdU4gCNZQI1DTC9cpzm5cIcA9CaOjCEanUeFDiIUM8TTHyvlDjGXpNE0rrNZkt0FApUJOKxLhELjTD0TQx4LUwPJ01UUgMhWV4YKHTkpB4yPTOoclBiOBSHAIuNhcCmutWgUZ0gM4749GIBJCUADbNWHQy+/mjiimWlv3ycUVF0VCVSMv8xu1mMKcT3+x5QUt4G4bqWL1wQ/HzxcxXvpb1NvQWUwC1tJ/KUEt825lIUVOAHeApeJoMJuJpWrDPRdKUMJGZpoapwdV0MTW4eG6F4LkVgudWCJ5dIXhmheDzFZLGxS4joFN3HtmBihnyHqFeha3ehDIu9sR5dfL4SPOnXM47MYMWasabfTXjY9aX7f9WPdxj13J0YsY0y/U7+Dv7li/Pxjuv4zD8X/DrP/NqS0gwFAAA";
    final static private String hd_verticalScroll = "H4sIAAAAAAAAAK2YXW+bMBSG/4qFdkG7sviLlFallXaxalLam971DjUQkAB3hLbpfv2wAcfkkGrEJIIabD/n+Ph9RcrNuoo+ruMyjcqXeO1tYlHEdfWJ1O0iqypReamosr+irKM8dJIo38bOoPs9rurs5bCzjne1F1VxtA2du4Si9rhsDkIctH3fXL9n8cdPsQsdjNS3n/j5GoeOELsi1+inl0rkeR9WrLMki6sGTKiP+3l6Da9RnYbOQxOJyWgcrfomUU2ZB8Fdg6lbQRN/1aW3TxM9I0lZqmHP6Ak9qmuujraPdX26kxF5ovtAbcx2zkoH7Y+VwXjYB9YZcyOK4sgmb+/6XdItW2Ump/NA3fVVrF/osS2PEOKLCt0bSRE5kyzNqt3rKM2lSjEYq+SAciVvY11ds4/KGlE6VvHBMHXig10Y9KslLo3cqKIFxl6NzJKJMWzM6resjUNhIkyduDlFhmbLZspvHaorxn6PBwiZGQtGy8FkRnxUgOYwLtPk1NTGoLtTxrPWxqBXJszNWplaaav0oOPv9aM1ggci4DJlH5sqP6ImX2btU1MuUpO3N61n/7xFdSbK1sFlVDTOT3pDJ6Iq3vIodLLExd43jC7wRdOUlm8v5aGuzs4a4GJA/CoAOQxQZKWbi81Htq7Ti6aRxtkmradB6SG0WSs6v0swWhAsP5NoDNIoOicLOonCj1D4JIo/Rvkut9ebtqjlERCdCro8BPWb9x17EjcJFnwJY9NgV3CJl+gUEAEu0Lo8ZZEEaH6Im5odUHtftIkKJUDoOq+pJCB2TZrGAXJ3fa4MfLZYyj8/pmmVANW7nh0QqN8yQWAA1yM4sCECF7h2QArMYLdkCtzgkiW1AQI/2K4Y+MI9lQR8YVk76I9TSdAZdpnNbAwKjWG5qdAXJ5LYzIZg0BB2vLn9wGbzA4N+sPM+g4awBEJfWBYPGsMSCJ1hJ5eRB4ZVCTn0h92KOTTIqSRoDavacegMO96IP+xKN7c/+Nz+4DM/OPjcDw4+tz/8uf3hz/wA8aFL/vtXcxqV6zxGRtt7FdtMjpDvGu/0v+pdZxWVm9j79IpolxVvReiodwpHxmRlO2YfvR2hczl8k3r7DyH+rZNiFQAA";
    final static private String hd_horizontalScroll = "H4sIAAAAAAAAAK1YXW+bMBT9KxbaA/1gAduQtCqttIdVk9q+9G1vqDEBCXBHaJvu149rMAFuUo2YRFDb1z7365yQ5mZdRh/Xokii4kWsnY2QuajKT6KW87QsZekkskz/yqKKstCKo2wrrIH5XZRV+jI2VmJXOVEpom1o3cWUNJfn1belRbbvm+v3VHz8kLvQcol664OfryK0pNzlWc/z80sps0w7lus0TkVZQ3vUd/XJLovXqEpC6xH88frGyIN23Q7dNhym/j4QmK+UCVaXXaDkN3lstwX1+Jk8qTlX197G6nFnZMoPVWhMWXl35KE70IXBehiPAzMHIE7HqzDkfLzqwy3oRadWIRO+Ij/JU1MiKeUXVbrvheMBoBf0K3ffYddLqkarQ9UcoFzBkttVuG+jgErpoaoPtqkbH3RiYIdAadCLjQISXfX6deAUBMbc3indtsaPCmSYy7iX9QRcMyDGr9YVAPrDUxAMGxWqbfxgHwTE3WYfgF8NzJoL/WJRVFLNjTaHxl3XwWE6fca05iO91izaV1LT2B/ugxT8Pqd9APMbBlO1fx8/cPL2ptHtn7eoSmXRqLiI8lr/sRZ1LMv8LYtCK41t1/nmkkv3sh6C7JspXGp2dlYDLgaIXznwxg7ytLAzuflI11VyWQ8SkW6SahooHYPWFSXnd7FLFp4Lr0loDKNRcu4t6CQUfgSFT0LxD6FcQJ+daUkFR4DoVKDlGKjr2YXrAN4ktNXXaGwa2hVOcklOAfKQDjRFT0nSQ6QfoE2NDbFdo01kqIeI3hV/KhIiuw5pGgxiu+2eLQIQ8PdpJPUQ3W2fq0+CE/EQ60+ODDHe9tyVSWiI9LYXUANAirhvO0bFo4j+hilTpADbMUREUjDjC0WCMK0hloYZHhaIYYCzKYRihZh2F0vEKFc2t0IYVsipSLNLg80sDXZAGmYfWAxrwzDlA+IwRMTqMATEIjHryoGniFGAHGvEEHA2jXCsEaPacayQU5GwNgyLNvNjg8/92OCzPTb43F+s+NyS8OeWhD+bJHwsif8OLYmKdSZIb+y8ym0KO5r/MnXarbGMio1wdk4e7dL8LQ8t9TPCkT1p0ezZe292dLGMf0K9/QdGU6ATWxUAAA==";
    final static private String hd_wave = "H4sIAAAAAAAAAJ1XbZOaMBD+KxmmH/A0YxLUO26Oc6b92vYH9FvuDJIZIBZRsb++yaL4Euh01SEGEp5nd/Nssr6tKnl4VWUmy0+1omtlClVXRwKPC11VpqKZqfQfU9YyT4JU5lsV3AzvVVXrz/vBWjU1lZWS2yRYpuKZ2CZ2zYttIhaQ7X79utfq8NU0ScAIfM/vHjcqCYxpipwe5L7jMyudalVZRC7m7DK/M38j6ywJflgGHjku8s11HffMdRz13HXmMPjdtcw2C5gnhG3cFMFt417iMQz+Ij+D97eW6fdO1tqULW8pC2tnejYjNVWxy2US6DRk9AsjEzaxXcHsB27dBXejkQWc3iD+i4D3EFDewnIyabuO6vLMXfwBKnFPlZt1pvQ6q5+WKSNTwGQoyOge0sX+ibNphIKZ9cGMGbVqIiigeS+Qg6E4xxaDsQKzBM6sZ9+sxUP+vfQCPeBf3OPfQa/qzEqBPyQF7qXKLeQcj+jlhvzYhss0JsgU84Rv08naBEkMv0g8T/UM1pIjVcE92Xd2naxD2uWp/7wCrXkzpHleDoTg4xg22REyxXlPDtiN3IEtsOLlXhqEcBScLRM4NC8X2BiihbRKDCbAGOKGhfPUD4fWQwETXgaEcBSO4ZDEBkx4+r/VGcfpTHhpcIbD2tW3+8+ckzE6YJ72WyjnX4x0zxN+IZsQxD+BFUUe4p72C12GIPxJu5o4uL6D4LoowG/bUV8eXJ+dyABGXiJ0eDic4fpnWGi2+Fzlilz16cZstZvhKttlV1SdBitZrhU9UrvGutgVSQA14cAcXbZzLvFtZ/wPt2V2lW4XnBvs5sLPh/ibC39bZHpGnAJy///h/S8tFZT9WAwAAA==";
    final static private String hd_doubleWave = "H4sIAAAAAAAAAJ1XXW+bMBT9KxbaA2mDYpuGJFVppO112+ukvbnFJJYAZ4R87dfPvgQ3icm2iypck2vOPbbP8cdLVovDs6zWonqXWbSSupRNfSLwc6nqWtfRWtfqt64aUaRBLoqtDK7Ce1k36v022MhjE4laim0aLPM4JqaY2uLJFklAtvvV817Jw2d9TANK4K/79rSRaaD1sSyiTO/eCvlD7F1WnalcydrgJnz68ZHrw0Y06zT4ZtIwm5WTL7Y6M4VNzRamsEQ4haB52DnE+TnEIE6+2tIGEoDg9su5rdjC4vEZBE0l6ULTLhRD6Cf5Hry+tPx+7USjdNWyrURpuph35HNdl7tCpIHKQxp9omRMx6bKTAfbV/vA22hkACdXiH9LwHoSRIxSC8vIuK1CKvebfeANmYrfpir0ai3Vat08LHNKJoBJUZDxLaSdlgdGJzEK5qkP5pFGRogEBTTtBbIwEa5jyd2xAlocR2vm00oG9W/eCzSgf4ue/h1U1qyNFNggKTDPKteQUzyi5w3xtg2X+YIgLeYJ39jJcAITw38knqd6CnPJkKpgnuwdrzM7JC9P/d0MtPSekPQ8D4TQx0dYf0eTBIfW4wGz/FuwBCte5tngmhlu8WGeFxyzOZYZ90wQOjDLjOPQPAPArjhozLhnghB21oHMeiwACsOy8izgJAszioXrW/8Hiox78ndYeFl44g87MHN+QQ9+zy5gTjrDeumJP4Tz0zBm8d09oF2BGG4Fij39d3BYXp74zZYJ2l9gByz2lF+KY2vyMcwpbs2OPQOUqgrBk+N2CnBwfVvA5RkPvwvH/zgKmUsDDs/zgsPD4XgucDj31WFuIFkhyUU92uitsi3sHWfpzsjnYC2qlYxOkZljVe7KNIAj/p02qmrbfIxv2+J/cptxtJcbNzhX2MeL/DB//W26/O2dwSNxHpDbm+TrH1axBUBiDgAA";
    final static private String hd_mathPlus = "H4sIAAAAAAAAAJ2VXW+DIBSG/wohu2i3kor2O7Umu96WXe+OVFASkQ6xH/v1Qx121bYJ1YgHOTzn5eSA61iRw4rmKcm3NEYJlYJqdQL1Z8GVkgqlUvEfmWuShZCRrKDwYnhPlebb7qCmR42IoqQIYcRmIGLYN82yMgIIin2y2nN6eJXHEHqgvu3M046GUMqjyJAgOv3MysJGlDFnnCrD9IOpb2e08nfGPYTvoA34Zl5zG7s2sGkWF0Yr66zPDrXGxE5vjcAGCcAX+ICbdaPkuySay7zRlRNhVsKsTCaVKDMSQs4GHnrywMgbGXMeTJZNt3rq3nBogOML4r0AuBsgk8mBxzp9rmlj36suJ6R/BZlSnqT6cWbQZQqeD6zUURvAbe2TLjRiAXiOmAcekTi9lcmx78SZ9VVNwYuHTL0AJ9D8JmjiBlpcBVUY5Jai5Q0QdgXh3r5oS8Ax27i3AYwcr0mT75Ym3Cv8M8ox47hX7w3qgZzjK1XeoPw7KHMoxhkF/2y0kwWvPKozNzov9m9UkTyh6GRO3SMXpQhhvdVv+PC88TmHbzxaMd1/yuYX/XWc6mwGAAA=";
    final static private String hd_mathMinus = "H4sIAAAAAAAAAJ2UUW+DIBDHvwohe1i7klKtbdeUmux53QfYG6mgJAIdYmv36Yda3ep0icNcAtzd739HwF1k6GXLVELVkUUoZloya66g2pbCGG1Qoo341MrSlEBO04zBO/eZGSuOXadlhUXUMJoRGPI1CPnS2cZZAEF2jrdnwS4vuiAQg+pr8q4nRqDWhUyRpDY5CJVnjaCOBBfMOKTnB16T0lZ/cvEEHkCj93pTbJVvngC8gze439XZHzm1Qquapah08rxBc21knlICBX/E6AGDGZ656QKXo1qXVi8nE4ec3zH/klh0JVIdJ0zEiZ2GHIO5V0FHIb0e5EVENpmu/eUz/g/SH6xy7o0CLbugkPvgCaOQL8AoUNALKjFoXGurodMa2dn6d0GrujNvXGebXlCJGe7M3fwoZeDHHJ10JsqI8mWF7bnfnIaqmKGre1qFkLkksL67A0FC1UHf8nVEW0z3v7H/ApZycq5QBAAA";
    final static private String hd_mathMultiply = "H4sIAAAAAAAAAKWX226jMBCGX8VCe5GQIGwTcqhKkfZ6uw+wd1ZiEkuAUyCnffodTM02mO5q0lRxDdjf/B7+Aed5V4nLkywPotzKXbCXupBNdSPmdKGqSlfBQVfqty4bkSdeJvJaeneXz7Jq1HZ4sZHXJhCVFHXipRlbEGhW0PAImoh6pD7vn85KXr7ra+JRYv7s3NtRJp7W1yIPCtEcXk95o475zcbVO5UpWQGZRzG3s/pFHGFK4r0SGzYmP9p/SyuBrVsdrG34nSwYCT1zuLDn+MaOi6idGzHL684t+nHrbu4v8tN7ee5UvZ1Eo3TZaSxFASvLrORMV8UpF4mnsgkNvlEyp3PoxmyzjM1h+zVH0ykAwzvivwKwYYBClZNc7y9q1xzm0DlItT80OCgfQmHpxE8zSkJG2w+KFg1pE0bXBuOLRpR80qucW+HTaXhUqCCLYRDm15CJo/IncPPINLQxcZmIXexW11/GLl0sZOLL2NUQW79VTe8G33ZmfcL9vjejPjLY2jXJivjGw4+4ZDOGm9EgzdYEVxFOzaVZ3Lp3Q0KOIznFlWaLx0gjFWVIHE1yqul9dXiSUzJQ5bRLOePInDt1AgxGZtBGJMAZgTnF0ekyqrAspyI6XWaNEXKNjuFtPWETP2J1eNt0opY4UXzE7GzT+mEJz2ocasTtvMv7Cpt37vi9f/Y8tErH9Pe4BRLnOL9/DCJvJR/xPewKOlUxUtWI7zmUNgvbm4lDjdge9jhGFseyRp7zkPCZIWFt4Tj/w/vngZRFjvsHvBWS55TAPQ+2kjjef8qAInFjZfBxuZ/Lgw3zLpfkQz846lq1I9o9edpv+d4vVqLcy+AGm/KrKk5F4pn3+idjVNmN+WuGbkSvZfij4+UP0iy0zI0MAAA=";
    final static private String hd_mathDivide = "H4sIAAAAAAAAAKWXW2+bMBSA/4qF+kDSMGxzTVWKNE3ay7YfsDdU7GAJcEZIQvfrZ5tACE66Ok0E+MZ3zvG5xHnOm+z4ROoiq19J7mwIr0jbvAE1XLGm4Y1T8Ib95XWblYlFs3JHrIvpA2la9jqfbEnXOllDsl1ipRQjkFLkixvGshVYYHfYPB0YOX7lXWJBoL7Du29bklicd1XpVFlbfGMHlo9Sec4oI43gYi/AEARxDAFCUTi8PlqzFe8m1k8pFUqpMfgNzr310Dvp9mPUbqLnOB+I1b96AZzz92R8lw803LBChDPJszWRvMV36PPy3Fv8Z5+1jNe9/XVWie2jw3ZQ3lT7MkssRm0EIXQeIFjJxkoMeGHkB2pEXqq3WAise8F9Twyai4GP0EkpBEYUPKfYkeev4aOwFCxc34jlzVnKrGXJN0eWt4UrGgVhm6I1ovpzasVqW3gDrFLqAbM9C266Bp9dk1IfqIEHJcMHho4J50Icf5nSALjICBPNMYNjQmDu5viK4cJqBFYnkyOgevKSHUOT13P86OqlVNXFUH7MwltLoykzFrt5B1PLmSkzuI+pZdAQ70vlsLts1zJp1NPFZiQte0Rie0BVirVZCCEteXqUBDmG9mkpIlBQokRZNmVpeaIKt7IQhYYmamkiGNGJhQxZt3Oi58WGhfpaPvR11SwksJYE6uexVwobKqUFf89SJENHYi3oJ3oZbj7Wwn7YLDOMFvI2Cvt8XrihfHwxtFELfBuj8DNALfrtwP8MT8uAjysoDmZ5ScCk7Wz5jskV8qCZnovRabbJ6g1x3sRRs2PVvjqdF26sYXW/Bk2Lab/oI/JFLMnT3FgtbqmQ0lsrBgXulO6Np+wLcDcVfXV/uv/YfvLF/J/Eyz+nPvT4YgwAAA==";
    final static private String hd_mathEqual = "H4sIAAAAAAAAAJ1V246bMBD9FcvqQ5JdCxtICKtlkSr1re0H9M1abLAEOHWcW7++tgmwG8h23SAsHI/POTOeGT8Xip6eWFvR9pUVqGSyYVpdgPu7EUpJhSqpxB/ZalpnkNN6z+C75SNTWrzeLmp21ogqRvcZzDmJgBmwHWI7EAj2x/LpKNjpqzxnEAP39HsvO5ZBKc9NjRqqq2+/D7TuSWUhuGDKwIbROsSAkGTTbxz82JldGfwBRubvA/egYtsvb8EvMNimo2k66h2QiLH9CV+eOz4jTAvZduwtbYxs3ovhUjWHmmZQ8AVGXzB4xI/mM9ok8dpN7etmy6UBDN4hfkRAbglyjsEqDIgXSniLQrD9PWAUeuFE8+6Sq7s5D4Gb2ddOPJ2Nb+FrWVZMlJVeWbeDTrUX5PojyAgEoT/kZgbyJApdrZIoTvH/QCZ3VQZ+B7SdpksCzDHnfA28gNJZIAuD/FwjkxKxNegkxX6SyEwtpFZT7K1pUg/9EXqGm0wKwnSNsPNu4+ndJPk7KAvk694k6ReuFT7YyC99XZyk++IadtMevcHmEt0F/h6M6fFFzcCbb7STe2Et7E2Sj/l1XVW0LRm6mLvkLJpDk0HXde/YiLazGePbWXyG3FAn9j75B30+NN/PkwfzF/XLX2mqmsLBBwAA";
    final static private String hd_mathNotEqual = "H4sIAAAAAAAAAJ2YbW+bMBDHv4qF9oKEouAnAlXTSJP2btsH2DvUQIIUICW0TffpZ5+BNLHT9WgV1wT357vz/c3hh02bvd3n9S6rn/JNuM2bKu/adwJfV2XbNm24a9ryb1N32X7lFdn+mHsXt1/ztiufrm92+akLszbPjitvXaRkXVChm0g30iPH1+39a5m/fW9OKy8i8Dv86/shX3lNc6r2YZV1u99N9+P5JdsP0zabsijzVoEZlywicRzpH0LpMh4Yo0cHBVh5v8how0/1h4nBHsF1s9QN002sGi4urT339BAux54eTPl499zTQ/hy6Ak9s6S6l+ieHsLHcelFRzNYMvbiYa7UdP6Q397jg/FQhaQrm9r4W2eVilkxuF80bfWyz1ZeWfhR+C0id9Gd6kodJ7jUH7iazRRwcUH8bALqmECwyHApuev7erJ+WeBr/emvkROy6wnXRUTmbEFRFH5NoWBLEIUMxRHu+LI+vmpdCVzpj75AOiuv8ftmu8vL7a6ba7cXxmoUMv4MKciC4ZFLB/Kt3HS7+ZKLNJqCTG4hF7j1Se1sSYha5XWxJLg8t5QEJM0Jca5RSzLjCiCdow4tUGrci5HuWYIwKA3C+mdpAnYqsEoirbLyH/bBQIOwVll5r1DaKCnw2UldGT9tCa1EV2YtybzLav9QztUGQmMyUzpPzF6Jg1vZf3xuO81MyBzawMwGbRDNkXzm0ARNNU6SBTBxOEsY6oGn9naKjClzyMK4mhCVg4wizXJJwwRQTHLToQ/W64NxJMslEGMbm2SbQyWjbUjxMksko218km0OqYy2YVmO50Jv26TU5Q4ljLalSJZDBto2dInjkMFgE0dqgDs0oFkgUOROzF35LyayHPmvauRpLFfuJxNZjtxXFf40liPv+dTYO/Je9vv/AjZvXPV7I+2VgSnWNOFIe877dMXaZaU+1OLqUaqKcBFBKa5qcRzTksAHJoPyXlAs0yEF2T+apyyHpYYIwicEkmMp4WP4hHq3QbppqWHkRZoosWG7+XZg3GVIdy1RXOKQz2RpiWIsDg0PWZrL2+8Lhod8VklLHD7ELABXZ8hiS1qy8OGAI4DDDTTNEoQPAQvATTTN0oMPRVsA5RGaZqnCH95GVNGAplma8OFMKIDzIDTtpiJuYXZZvdnn5EM/PDTHUo/Qx2/r82tcf7fN6m0evodVdiqrl2rlwWnRjTFlbcacHwFmxFcmhzSc9o8SDsrYfwxfj6c/Xze7j+H1sejjP+LkhbwvFQAA";

    static final public ImmutableMap<String, String> hostDataMap = ImmutableMap.<String, String> builder()
        .put("line", hd_straightConnector1)
        .put("straightConnector1", hd_straightConnector1) 
        .put("bentConnector3", hd_bentConnector3)
        .put("curvedConnector3", hd_curvedConnector3)
        .put("ellipse", hd_ellipse)
        .put("triangle", hd_triangle)
        .put("rtTriangle", hd_rtTriangle)
        .put("parallelogram", hd_parallelogram)
        .put("trapezoid", hd_trapezoid)
        .put("diamond", hd_diamond)
        .put("pentagon", hd_pentagon)
        .put("hexagon", hd_hexagon)
        .put("heptagon", hd_heptagon)
        .put("octagon", hd_octagon)
        .put("decagon", hd_decagon)
        .put("dodecagon", hd_dodecagon)
        .put("pie", hd_pie)
        .put("chord", hd_chord)
        .put("teardrop", hd_teardrop)
        .put("frame", hd_frame)
        .put("halfFrame", hd_halfFrame)
        .put("corner", hd_corner)
        .put("diagStripe", hd_diagStripe)
        .put("plus", hd_plus)
        .put("plaque", hd_plaque)
        .put("can", hd_can)
        .put("cube", hd_cube)
        .put("funnel", hd_funnel)
        .put("bevel", hd_bevel)
        .put("donut", hd_donut)
        .put("noSmoking", hd_noSmoking)
        .put("blockArc", hd_blockArc)
        .put("foldedCorner", hd_foldedCorner)
        .put("smileyFace", hd_smileyFace)
        .put("heart", hd_heart)
        .put("lightningBolt", hd_lightningBolt)
        .put("sun", hd_sun)
        .put("moon", hd_moon)
        .put("cloud", hd_cloud)
        .put("arc", hd_arc)
        .put("bracketPair", hd_bracketPair)
        .put("bracePair", hd_bracePair)
        .put("leftBracket", hd_leftBracket)
        .put("rightBracket", hd_rightBracket)
        .put("leftBrace", hd_leftBrace)
        .put("rightBrace", hd_rightBrace)
        .put("squareTabs", hd_squareTabs)
        .put("cornerTabs", hd_cornerTabs)
        .put("plaqueTabs", hd_plaqueTabs)
        .put("pieWedge", hd_pieWedge)
        .put("chartPlus", hd_chartPlus)
        .put("chartX", hd_chartX)
        .put("rect", hd_rect)
        .put("roundRect", hd_roundRect)
        .put("snip1Rect", hd_snip1Rect)
        .put("snip2SameRect", hd_snip2SameRect)
        .put("snip2DiagRect", hd_snip2DiagRect)
        .put("snipRoundRect", hd_snipRoundRect)
        .put("round1Rect", hd_round1Rect)
        .put("round2SameRect", hd_round2SameRect)
        .put("round2DiagRect", hd_round2DiagRect)
        .put("rightArrow", hd_rightArrow)
        .put("leftArrow", hd_leftArrow)
        .put("upArrow", hd_upArrow)
        .put("downArrow", hd_downArrow)
        .put("leftRightArrow", hd_leftRightArrow)
        .put("upDownArrow", hd_upDownArrow)
        .put("quadArrow", hd_quadArrow)
        .put("leftRightUpArrow", hd_leftRightUpArrow)
        .put("bentArrow", hd_bentArrow)
        .put("uturnArrow", hd_uturnArrow)
        .put("leftUpArrow", hd_leftUpArrow)
        .put("bentUpArrow", hd_bentUpArrow)
        .put("curvedRightArrow", hd_curvedRightArrow)
        .put("curvedLeftArrow", hd_curvedLeftArrow)
        .put("curvedUpArrow", hd_curvedUpArrow)
        .put("curvedDownArrow", hd_curvedDownArrow)
        .put("leftCircularArrow", hd_leftCircularArrow)
        .put("circularArrow", hd_circularArrow)
        .put("stripedRightArrow", hd_stripedRightArrow)
        .put("notchedRightArrow", hd_notchedRightArrow)
        .put("homePlate", hd_homePlate)
        .put("chevron", hd_chevron)
        .put("swooshArrow", hd_swooshArrow)
        .put("flowChartProcess", hd_flowChartProcess)
        .put("flowChartAlternateProcess", hd_flowChartAlternateProcess)
        .put("flowChartDecision", hd_flowChartDecision)
        .put("flowChartInputOutput", hd_flowChartInputOutput)
        .put("flowChartPredefinedProcess", hd_flowChartPredefinedProcess) 
        .put("flowChartInternalStorage", hd_flowChartInternalStorage)
        .put("flowChartDocument", hd_flowChartDocument)
        .put("flowChartMultidocument", hd_flowChartMultidocument)
        .put("flowChartTerminator", hd_flowChartTerminator)
        .put("flowChartPreparation", hd_flowChartPreparation)
        .put("flowChartManualInput", hd_flowChartManualInput)
        .put("flowChartManualOperation", hd_flowChartManualOperation)
        .put("flowChartConnector", hd_flowChartConnector)
        .put("flowChartOffpageConnector", hd_flowChartOffpageConnector)
        .put("flowChartPunchedCard", hd_flowChartPunchedCard)
        .put("flowChartPunchedTape", hd_flowChartPunchedTape)
        .put("flowChartSummingJunction", hd_flowChartSummingJunction)
        .put("flowChartOr", hd_flowChartOr)
        .put("flowChartCollate", hd_flowChartCollate)
        .put("flowChartSort", hd_flowChartSort)
        .put("flowChartExtract", hd_flowChartExtract)
        .put("flowChartMerge", hd_flowChartMerge)
        .put("flowChartOnlineStorage", hd_flowChartOnlineStorage)
        .put("flowChartDelay", hd_flowChartDelay)
        .put("flowChartMagneticTape", hd_flowChartMagneticTape)
        .put("flowChartMagneticDisk", hd_flowChartMagneticDisk)
        .put("flowChartMagneticDrum", hd_flowChartMagneticDrum)
        .put("flowChartDisplay", hd_flowChartDisplay)
        .put("flowChartOfflineStorage", hd_flowChartOfflineStorage)
        .put("irregularSeal1", hd_irregularSeal1)
        .put("irregularSeal2", hd_irregularSeal2)
        .put("star4", hd_star4)
        .put("star5", hd_star5)
        .put("star6", hd_star6)
        .put("star7", hd_star7)
        .put("star8", hd_star8)
        .put("star10", hd_star10)
        .put("star12", hd_star12)
        .put("star16", hd_star16)
        .put("star24", hd_star24)
        .put("star32", hd_star32)
        .put("ribbon2", hd_ribbon2)
        .put("ribbon", hd_ribbon)
        .put("ellipseRibbon2", hd_ellipseRibbon2)
        .put("ellipseRibbon", hd_ellipseRibbon)
        .put("leftRightRibbon", hd_leftRightRibbon)
        .put("verticalScroll", hd_verticalScroll)
        .put("horizontalScroll", hd_horizontalScroll)
        .put("wave", hd_wave)
        .put("doubleWave", hd_doubleWave)
        .put("mathPlus", hd_mathPlus)
        .put("mathMinus", hd_mathMinus)
        .put("mathMultiply", hd_mathMultiply)
        .put("mathDivide", hd_mathDivide)
        .put("mathEqual", hd_mathEqual)
        .put("mathNotEqual", hd_mathNotEqual)
        .build();
}
