
package com.openexchange.office.filter.core.chart;

import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ChartSeries extends AttributeSet {

    private JSONArray dataPoints = new JSONArray();
    private boolean   hiddenMarker;

    public ChartSeries() {
        getSeriesJSON().putSafe("dataPoints", dataPoints);
    }

    public void setSeriesAttributes(String type, String values, String title, int axisXIndex, int axisYIndex) {

        JSONObject series = getSeriesJSON();
        series.putSafe("type", type);
        series.putSafe("values", values);
        series.putSafe("title", title);
        series.putSafe("axisXIndex", axisXIndex);
        series.putSafe("axisYIndex", axisYIndex);
    }

    public void createInsertOperation(JSONArray start, JSONArray operationQueue, int seriesIndex) {
        JSONObject op = new JSONObject();

        op.putSafe("start", start);
        op.putSafe("series", seriesIndex);

        JSONObject attrs = getAttributes();
        if (hiddenMarker) {
            // workaround for Bug 51731
            try {
                JSONObject fillNone = new JSONObject(new JSONTokener("{fill:{type:'none'},line:{type:'solid'}}"));
                for (int i = 0; i < dataPoints.length(); i++) {
                    JSONObject dp = dataPoints.optJSONObject(i);
                    if (dp == null) {
                        dp = fillNone;
                    } else {
                        mergeAttributes(dp, fillNone);
                    }
                    dataPoints.put(i, dp);
                }
            } catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        op.putSafe("attrs", attrs);
        op.putSafe("name", "insertChartDataSeries");

        operationQueue.put(op);
    }

    public JSONArray getDataPoints() {
        return dataPoints;
    }

    public JSONObject getSeriesJSON() {
        JSONObject attrs = getAttributes();
        if (!attrs.has("series")) {
            attrs.putSafe("series", new JSONObject());
        }
        return attrs.optJSONObject("series");
    }

    public String getType() {
        return getSeriesJSON().optString("type");
    }

    public boolean isLine() {
        return StringUtils.contains(getType(), "line");
    }

    public boolean isScatter() {
        return StringUtils.contains(getType(), "scatter");
    }

    public boolean isBubble() {
        return StringUtils.contains(getType(), "bubble");
    }

    public boolean isPie() {
        return StringUtils.contains(getType(), "pie");
    }

    public boolean isDonut() {
        return StringUtils.contains(getType(), "donut");
    }

    public void setHiddenMarker(boolean hiddenMarker) {
        this.hiddenMarker = hiddenMarker;
    }

    public String getValues() {
        return getSeriesJSON().optString("values");
    }

    public void setNames(String names) {
        getSeriesJSON().putSafe("names", names);
    }

    public void setBubbles(String bubbles) {
        getSeriesJSON().putSafe("bubbles", bubbles);
    }

    public void setValues(String values) {
        getSeriesJSON().putSafe("values", values);
    }

}
