package com.openexchange.office.fields;

import java.util.HashMap;
import java.util.Map;

import org.json.JSONException;
import org.json.JSONObject;

public class FieldsParserParam
        implements
        FieldsParser
{
    private String param;

    public FieldsParserParam(
            String param)
        throws Exception
    {
        this.param = param;
    }

    @Override
    public Map<String, Object> getFields()
        throws Exception
    {
        Map<String, Object> values;
        try
        {
            JSONObject fields = new JSONObject(param);
            values = fields.asMap();
        }
        catch (JSONException e)
        {
            String[] fields = param.split(";");
            values = new HashMap<String, Object>();
            for (int i = 0; i < fields.length; i += 2)
            {
                values.put(fields[i], fields[i + 1]);
            }
        }
        return values;
    }

}
