package com.openexchange.office.fields;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.openexchange.office.tools.common.csv.CSVEntryParser;

public class FieldsParserCSV
        implements
        FieldsParser
{
    private List<String> allLines;

    public FieldsParserCSV(
            List<String> allLines)
                throws Exception
    {
        this.allLines = allLines;
    }

    @Override
    public Map<String, Object> getFields()
        throws Exception
    {

        List<String> header = null;
        List<String> first = null;
        String firstLine = allLines.get(0);
        if (firstLine.indexOf("sep=") == 0)
        {
            String[] seps = new String[] { firstLine.substring(4, 5) };
            header = CSVEntryParser.getCSVContentFromLine(allLines.get(1), seps);
            first = CSVEntryParser.getCSVContentFromLine(allLines.get(2), seps);
        }
        else
        {
            String[] seps = new String[] { ";", ",", "\t" };
            header = CSVEntryParser.getCSVContentFromLine(allLines.get(0), seps);
            first = CSVEntryParser.getCSVContentFromLine(allLines.get(1), seps);
        }

        Map<String, Object> fields = new HashMap<String, Object>();

        for (int i = 0; i < header.size(); i++)
        {
            fields.put(header.get(i), first.get(i));
        }
        return fields;
    }

}
