
package org.docx4j.dml.chartex2014;

import java.io.InputStream;
import javax.xml.bind.JAXBException;
import org.docx4j.openpackaging.contenttype.ContentTypes;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.DrawingML.JaxbDmlPart;
import org.docx4j.openpackaging.parts.relationships.Namespaces;
import org.w3c.dom.Element;

public class ChartExPart extends JaxbDmlPart<CTChartSpace> {

    public ChartExPart(PartName partName) throws InvalidFormatException {
        super(partName);
        init();
    }

    public ChartExPart() throws InvalidFormatException {
        this(new PartName("/xl/charts/chartEx1.xml"));
    }

    public void init() {

        // Used if this Part is added to [Content_Types].xml 
        setContentType(new org.docx4j.openpackaging.contenttype.ContentType(ContentTypes.DRAWINGML_CHART_EX));

        // Used when this Part is added to a rels 
        setRelationshipType(Namespaces.SPREADSHEETML_CHART_EX);

    }

    @Override
    public CTChartSpace getJaxbElement() {
        return super.getJaxbElement();
    }

    @Override
    public CTChartSpace unmarshal(InputStream is) throws JAXBException {
        return super.unmarshal(is);
    }

    @Override
    public CTChartSpace unmarshal(Element el) throws JAXBException {
        return super.unmarshal(el);
    }

}
