/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package org.docx4j;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import org.jvnet.jaxb2_commons.ppp.Child;

public class IndexedNodeList<E> implements List<E> {

	private List<IndexedNode<E>> list = new ArrayList<IndexedNode<E>>();

	public IndexedNodeList(){}

	private IndexedNodeList(List<IndexedNode<E>> _list) {
		list = _list;
	}

	public IndexedNode<E> getNode(int arg0) {
		return list.get(arg0);
	}
	
	public boolean addNode(IndexedNode<E> arg0) {
		arg0.setIndex(list.size());
		return list.add(arg0);
	}

	public void addNode(IndexedNode<E> refNode, IndexedNode<E> newNode, boolean before) {
		final int index = refNode==null?list.size():before?refNode.getIndex():refNode.getIndex()+1;
		newNode.setIndex(index);
		list.add(index, newNode);
		for(int i=index+1;i<list.size();i++) {
			list.get(i).setIndex(i);
		}
	}

	public void addNodes(IndexedNodeList<E> sourceNodeList, Object parent) {

		int destIndex = list.size();
		for(int i=0;i<sourceNodeList.size();i++) {
			final IndexedNode<E> node = sourceNodeList.getNode(i);
			final Object data = node.getData();
			if(data instanceof Child) {
				((Child)data).setParent(parent);
			}
			node.setIndex(destIndex);
			list.add(destIndex, node);
			destIndex++;
		}
		sourceNodeList.clear();
	}

	public IndexedNode<E> setNode(IndexedNode<E> oldNode, IndexedNode<E> newNode) {
		final int index = oldNode.getIndex();
		newNode.setIndex(index);
		oldNode.setIndex(-1);
		return list.set(index, newNode);
	}

	public void setNodes(IndexedNode<E> oldNode, IndexedNodeList<E> newNodes) {

		final Object newParent = oldNode.getData() instanceof Child ? ((Child)oldNode.getData()).getParent() : null;

		int destIndex = oldNode.getIndex();
		int sourceIndex = 0;

		// removing oldNode
		removeNodes(oldNode, null);

		for(int i=0;i<newNodes.size();i++) {
			final IndexedNode<E> node = newNodes.getNode(sourceIndex+i);
			final Object data = node.getData();
			if(data instanceof Child) {
				((Child)data).setParent(newParent);
			}
			node.setIndex(destIndex);
			list.add(destIndex, node);
			destIndex++;
		}
		for(;destIndex<list.size();destIndex++) {
			list.get(destIndex).setIndex(destIndex);
		}
		newNodes.clear();
	}

	public void removeNodes(IndexedNode<E> startNode, IndexedNode<E> endNode) {
		final int startIndex = startNode.getIndex();
		removeNodes(startIndex, endNode!=null?(endNode.getIndex()-startIndex)+1:1);
	}

	public void removeNodes(IndexedNode<E> startNode, int count) {
		removeNodes(startNode.getIndex(), count);
	}

	public IndexedNode<E> getPreviousNode(IndexedNode<E> refNode) {
		return refNode.getIndex()>0 ? list.get(refNode.getIndex() - 1) : null;
	}

	public IndexedNode<E> getNextNode(IndexedNode<E> refNode) {
		return refNode.getIndex() != list.size() - 1 ? list.get(refNode.getIndex() + 1) : null;
	}

	private void removeNodes(int arg0, int size) {
		for(int i=0;i<size;i++) {
			list.remove(arg0);
		}
		for(int i=arg0;i<list.size();i++) {
			list.get(i).setIndex(i);
		}
	}

	public static void moveNodes(IndexedNodeList<Object> source, IndexedNodeList<Object> dest, int sourceIndex, int destIndex, int count, Object newParent) {

		boolean sourceIndexIncreasing = false; 
		if(source==dest) {
			if(destIndex < sourceIndex) {
				sourceIndexIncreasing = true;
			}
			else {
				destIndex += count;
			}
		}
		for(int i=0;i<count;i++) {
			final IndexedNode<Object> node = source.getNode(sourceIndex+i);
			if(newParent!=null) {
				final Object data = node.getData();
				if(data instanceof Child) {
					((Child)data).setParent(newParent);
				}
			}
			node.setIndex(destIndex);
			dest.list.add(destIndex, node);
			if(sourceIndexIncreasing) {
				sourceIndex++;
			}
			destIndex++;
		}
		source.removeNodes(sourceIndex, count);
		for(;destIndex<dest.list.size();destIndex++) {
			dest.list.get(destIndex).setIndex(destIndex);
		}
	}

	@Override
	public boolean add(E arg0) {
		return list.add(new IndexedNode<E>(arg0, list.size()));
	}

	@Override
	public void add(int arg0, E arg1) {
		if(arg0==list.size()) {
			add(arg1);
			return;
		}
		list.add(arg0, new IndexedNode<E>(arg1, arg0));
		for(int i=arg0+1;i<list.size();i++) {
			list.get(i).setIndex(i);
		}
	}

	@Override
	public boolean addAll(Collection<? extends E> arg0) {
		for(E e:arg0) {
			add(e);
		}
		return !arg0.isEmpty();
	}

	@Override
	public boolean addAll(int arg0, Collection<? extends E> arg1) {
		for(E e:arg1) {
			add(arg0, e);
		}
		return !arg1.isEmpty();
	}

	@Override
	public void clear() {
		list.clear();
	}

	@Override
	public boolean contains(Object arg0) {
		for(IndexedNode<E> node:list) {
			if(node.getData().equals(arg0)) {
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean containsAll(Collection<?> arg0) {
		for(Object o:arg0) {
			for(IndexedNode<E> node:list) {
				if(!node.getData().equals(o)) {
					return false;
				}
			}
		}
		return true;
	}

	@Override
	public E get(int arg0) {
		return list.get(arg0).getData();
	}

	@Override
	public int indexOf(Object arg0) {
		for(int i=0; i<list.size();i++) {
			if(list.get(i).getData().equals(arg0)) {
				return i;
			}
		}
		return -1;
	}

	@Override
	public boolean isEmpty() {
		return list.isEmpty();
	}

	@Override
	public Iterator<E> iterator() {
		return new IndexedNodeListIterator<E>(this);
	}

	@Override
	public int lastIndexOf(Object arg0) {
		for(int i=list.size()-1;i>=0;i--) {
			if(list.get(i).getData().equals(arg0)) {
				return i;
			}
		}
		return -1;
	}

	@Override
	public ListIterator<E> listIterator() {
		return new IndexedNodeListIterator<E>(this);
	}

	@Override
	public ListIterator<E> listIterator(int arg0) {
		return new IndexedNodeListIterator<E>(arg0, this);
	}

	@Override
	public boolean remove(Object arg0) {
		for(int i=0;i<list.size();i++) {
			if(list.get(i).getData().equals(arg0)) {
				list.remove(i);
				for(;i<list.size();i++) {
					list.get(i).setIndex(i);
				}
				return true;
			}
		}
		return false;
	}

	@Override
	public E remove(int arg0) {
		final IndexedNode<E> node = list.remove(arg0);
		for(int i=arg0;i<list.size();i++) {
			list.get(i).setIndex(i);
		}
		return node.getData();
	}

	@Override
	public boolean removeAll(Collection<?> arg0) {
		boolean changed = false;
		for(Object o:arg0) {
			if(remove(o)) {
				changed = true;
			}
		}
		return changed;
	}

	@Override
	public boolean retainAll(Collection<?> arg0) {
		boolean changed = false;
		for(int i=0; i<list.size();i++) {
			final E e = list.get(i).getData();
			for(Object o:arg0) {
				if(e.equals(o)) {
					continue;
				}
			}
			changed = true;
			remove(i--);
		}
		return changed;
	}

	@Override
	public E set(int arg0, E arg1) {
		final E ret = list.get(arg0).getData();
		list.set(arg0, new IndexedNode<E>(arg1, arg0));
		return ret;
	}

	@Override
	public int size() {
		return list.size();
	}

	@Override
	public List<E> subList(int arg0, int arg1) {
		return new IndexedNodeList<E>(list.subList(arg0, arg1));
	}

	@Override
	public Object[] toArray() {
		final Object[] array = new Object[list.size()];
		for(int i=0; i<list.size();i++) {
			array[i] = list.get(i).getData();
		}
		return array;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T[] toArray(T[] arg0) {
		final int size = list.size();
		if (arg0.length < list.size()) { 
			arg0 = (T[])Array.newInstance(arg0.getClass().getComponentType(), size);
		}
		for(int i=0; i<list.size();i++) {
			arg0[i] = (T)list.get(i).getData();
		}
		return null;
	}
}
