/*
*
*    OPEN-XCHANGE legal information
*
*    All intellectual property rights in the Software are protected by
*    international copyright laws.
*
*
*    In some countries OX, OX Open-Xchange, open xchange and OXtender
*    as well as the corresponding Logos OX Open-Xchange and OX are registered
*    trademarks.
*    The use of the Logos is not covered by the GNU General Public License.
*    Instead, you are allowed to use these Logos according to the terms and
*    conditions of the Creative Commons License, Version 2.5, Attribution,
*    Non-commercial, ShareAlike, and the interpretation of the term
*    Non-commercial applicable to the aforementioned license is published
*    on the web site http://www.open-xchange.com/EN/legal/index.html.
*
*    Please make sure that third-party modules and libraries are used
*    according to their respective licenses.
*
*    Any modifications to this package must retain all copyright notices
*    of the original copyright holder(s) for the original code used.
*
*    After any such modifications, the original and derivative code shall remain
*    under the copyright of the copyright holder(s) and/or original author(s)per
*    the Attribution and Assignment Agreement that can be located at
*    http://www.open-xchange.com/EN/developer/. The contributing author shall be
*    given Attribution for the derivative code and a license granting use.
*
*     Copyright (C) 2016 OX Software GmbH
*     Mail: info@open-xchange.com
*
*
*     This program is free software; you can redistribute it and/or modify it
*     under the terms of the GNU General Public License, Version 2 as published
*     by the Free Software Foundation.
*
*     This program is distributed in the hope that it will be useful, but
*     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
*     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
*     for more details.
*
*     You should have received a copy of the GNU General Public License along
*     with this program; if not, write to the Free Software Foundation, Inc., 59
*     Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*/
package com.openexchange.office.backup.distributed;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.StringUtils;

import com.openexchange.office.tools.directory.DocRestoreID;
import com.openexchange.office.tools.directory.IStreamIDCollection;

/**
 * Wrapper class to store document dependent stream data associated
 * with a unique document restore id.
 *
 * @author Carsten Driesner
 * @since 7.8.1
 */
public class DocStreams implements Cloneable, IStreamIDCollection {
    private final DocRestoreID docRestoreID;
    private String docStreamID;
    private String opsStreamID;
    private long timeStamp;

    public DocStreams(final DocRestoreID docRestoreID) {
        this.docRestoreID = docRestoreID;
    }

    public DocStreams(final DocRestoreID docRestoreID, final String docStreamID, final String opsStreamID, long timeStamp) {
        this.docRestoreID = docRestoreID;
        this.docStreamID = docStreamID;
        this.opsStreamID = opsStreamID;
        this.timeStamp = timeStamp;
    }

    public DocRestoreID getDocRestoreID() {
        return this.docRestoreID;
    }

    public String getDocStreamID() {
        return this.docStreamID;
    }

    public String getOpsStreamID() {
        return this.opsStreamID;
    }

    public void setDocStreamID(final String docStreamID) {
        this.docStreamID = docStreamID;
    }

    public void setOpsStreamID(final String opsStreamID) {
        this.opsStreamID = opsStreamID;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void touch() {
        this.timeStamp = new Date().getTime();
    }

    @Override
    public void touch(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public boolean contains(final String streamID) {
        if (null != this.docStreamID) {
            if (this.docStreamID.equals(streamID))
                return true;
            else if ((null != this.opsStreamID) && (this.opsStreamID.equals(streamID)))
                return true;
        }

        return false;
    }

    @Override
    public DocStreams clone() {
        return new DocStreams(this.docRestoreID, this.docStreamID, this.opsStreamID, this.timeStamp);
    }

    @Override
    public Set<String> getStreamIDs() {
        final HashSet<String> streamIDs = new HashSet<String>();

        if (StringUtils.isNotEmpty(docStreamID)) { streamIDs.add(docStreamID); }
        if (StringUtils.isNotEmpty(opsStreamID)) { streamIDs.add(opsStreamID); }

        return streamIDs;
    }

    @Override
    public DocRestoreID getUniqueCollectionID() {
        return docRestoreID;
    }

}

