package com.openexchange.office.tools.logging.impl;

import java.io.IOException;
import java.util.Enumeration;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;

public class RequestLogFilter implements Filter
{
	//-------------------------------------------------------------------------
	public RequestLogFilter ()
	{}

	//-------------------------------------------------------------------------
	@Override
	public void init(FilterConfig arg0)
		throws ServletException
	{
	}

	//-------------------------------------------------------------------------
	@Override
	public void destroy()
	{
	}

	//-------------------------------------------------------------------------
	@Override
	public void doFilter(final ServletRequest  aRequest ,
						 final ServletResponse aResponse,
						 final FilterChain     aChain   )
		throws IOException
			 , ServletException
	{
		BufferedRequestWrapper  aBufferedRequest  = new BufferedRequestWrapper ((HttpServletRequest )aRequest );
		BufferedResponseWrapper aBufferedResponse = new BufferedResponseWrapper((HttpServletResponse)aResponse);

		try
		{
			System.out.println ("##### ===================================");
			System.out.println ("##### REQUEST DUMP");
			System.out.println ("##### ");
			System.out.println (impl_request2String (aBufferedRequest ));
		}
		catch (Throwable ex)
		{}

		aChain.doFilter(aBufferedRequest, aBufferedResponse);

		try
		{
			System.out.println ("##### ===================================");
			System.out.println ("##### RESPONSE DUMP");
			System.out.println ("##### ");
			System.out.println (impl_response2String(aBufferedResponse));
		}
		catch (Throwable ex)
		{}
	}

	//-------------------------------------------------------------------------
	private String impl_request2String (final BufferedRequestWrapper aRequest)
		throws Exception
	{
		final StringBuffer sString = new StringBuffer (256);

		sString.append ("remote address : '"+aRequest.getRemoteAddr()       +"'\n");
		sString.append ("method         : '"+aRequest.getMethod()           +"'\n");
		sString.append ("url            : '"+impl_request2URL(aRequest)     +"'\n");
		sString.append ("context        : '"+aRequest.getContextPath()      +"'\n");
		sString.append ("path           : '"+aRequest.getPathInfo()         +"'\n");
		sString.append ("query          : '"+aRequest.getQueryString()      +"'\n");
		sString.append ("char encoding  : '"+aRequest.getCharacterEncoding()+"'\n");
		sString.append ("content type   : '"+aRequest.getContentType()      +"'\n");
		sString.append ("content length : '"+aRequest.getContentLength()    +"'\n");
		sString.append ("locale         : '"+aRequest.getLocale()           +"'\n");

		final Enumeration< ? > lParams = aRequest.getParameterNames();
		while (lParams.hasMoreElements())
		{
			final String sName     = (String) lParams.nextElement();
			final String lValues[] = aRequest.getParameterValues(sName);

			sString.append ("parameter      : '" + sName + "' = "+lValues);
		}

		final Cookie[] lCookies = aRequest.getCookies();
		for (Cookie aCookie : lCookies)
		{
			sString.append ("cookie ["+aCookie+"]");
		}

		final String sContent = new String(aRequest.getBuffer());
		sString.append ("content        : '"+sContent+"'\n");

		return sString.toString ();
	}

	//-------------------------------------------------------------------------
	private String impl_response2String (final BufferedResponseWrapper aResponse)
		throws Exception
	{
		final StringBuffer sString = new StringBuffer (256);

		sString.append ("char encoding  : '"+aResponse.getCharacterEncoding()+"'\n");
		sString.append ("content type   : '"+aResponse.getContentType()      +"'\n");
		sString.append ("content length : '"+aResponse.getBufferSize()       +"'\n");
		sString.append ("locale         : '"+aResponse.getLocale()           +"'\n");

		final String sContent = aResponse.getBuffer();
		sString.append ("content        : '"+sContent+"'\n");

		return sString.toString ();
	}

	//-------------------------------------------------------------------------
	private String impl_request2URL (final HttpServletRequest aRequest)
	    throws Exception
	{
		final StringBuffer sString      = new StringBuffer (256);
		final String       sContextPath = aRequest.getContextPath();
		final String       sRelPath     = aRequest.getPathInfo();
		final String       sQuery       = aRequest.getQueryString();

		if ( ! StringUtils.isEmpty(sContextPath))
			sString.append (sContextPath);
		if ( ! StringUtils.isEmpty(sRelPath))
			sString.append (sRelPath);
		if ( ! StringUtils.isEmpty(sQuery))
			sString.append (sQuery);

		return sString.toString ();
	}
}
