package com.openexchange.office.tools.htmldoc;

import org.json.JSONArray;
import org.json.JSONObject;

public abstract class SubNode
        implements
        INode
{
    private final int  position;
    private final int  size;
    private JSONObject attrs;

    public SubNode(
            int position, int size)
    {
        this.position = position;
        this.size = size;
    }

    public int getParagraphPos()
    {
        return position;
    }

    @Override
    public int getTextLength()
    {
        return size;
    }

    @Override
    public JSONObject getAttribute()
    {
        return attrs;
    }

    @Override
    public boolean setAttribute(
        JSONArray start,
        JSONArray end,
        JSONObject attrs)
        throws Exception
    {
        this.attrs = attrs;
        return true;
    }

    @Override
    public void insert(
        JSONArray start,
        INode node)
        throws Exception
    {
        throw new UnsupportedOperationException("Subnode from class:" + this.getClass().getSimpleName() + " does not support insert! " + start + " " + node);

    }

    @Override
    public boolean needsEmptySpan()
    {
        throw new UnsupportedOperationException("Subnode does not support needsEmptySpan!");
    }

    public boolean hasManualPageBreak()
    {
        return false;
    }

}
