/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools;

import org.apache.commons.logging.Log;
import com.openexchange.office.tools.logging.ELogLevel;

/**
 * Helper class to log a messages depending on elapsed time.
 *
 * @author Carsten Driesner
 *
 */
public class TimeSpanLogger {
    private static final String timePlaceholder = "%t";

    /**
     * Checks the stop watch, if max time has elapsed. If yes, the message with
     * the log level is logged. The stop watch is started again.
     *
     * @param logger
     * @param logLevel
     * @param stopWatch
     * @param maxTime
     * @param message
     */
    public static void checkAndLogElapsedTime(Log logger, ELogLevel logLevel, final EasyStopWatch stopWatch, long maxTime, final String message) {
        if ((null != logger) && (null != stopWatch) && (null != message)) {
            long elapsedTime = stopWatch.stop();

            if (elapsedTime > maxTime) {
                try {
                    final int pos = message.indexOf("%t");
                    String logMessage = message;

                    if (pos >= 0) {
                        final StringBuffer strBuf = new StringBuffer(message.length() + 10);
                        strBuf.append(message.substring(0, pos));
                        strBuf.append(elapsedTime);
                        strBuf.append(message.substring(pos + timePlaceholder.length()));
                        logMessage = strBuf.toString();
                    }

                    switch (ELogLevel.toInt(logLevel)) {
                    case ELogLevel.INT_LEVEL_DEBUG: logger.debug(logMessage); break;
                    case ELogLevel.INT_LEVEL_ERROR: logger.error(logMessage); break;
                    case ELogLevel.INT_LEVEL_INFO: logger.info(logMessage); break;
                    case ELogLevel.INT_LEVEL_TRACE: logger.trace(logMessage); break;
                    case ELogLevel.INT_LEVEL_WARNING: logger.warn(logMessage); break;
                    }
                } catch (Exception e) {
                    logger.error("RT connection: Exception caught while trying to output log message", e);
                }
            }
            stopWatch.start();
        }
    }
}
