/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.office.tools.doc.DocumentFormat;
import com.openexchange.office.tools.error.ErrorCode;

/**
 * Provides data associated with the input stream retrieved from the document.
 *
 * {@link StreamInfo}
 *
 * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
 * @since v7.6.2
 */
public class StreamInfo implements Closeable {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(StreamInfo.class);

    private ErrorCode errorCode = ErrorCode.NO_ERROR;
    private InputStream documentStream = null;
    private File metaData = null;
    private boolean writeProtected = false;
    private String lockedByUser = "";
    private int lockedByUserId = -1;
    private DocumentFormat documentFormat = DocumentFormat.NONE;
    private IDBasedFileAccess fileAccess = null;

    public StreamInfo() {
    }

    /**
     * Initializes the stream info members with the provided values.
     *
     * Initializes a new {@link StreamInfo}.
     * @param errorCode
     * @param documentStream
     * @param metaData
     */
    public StreamInfo(IDBasedFileAccess fileAccess, ErrorCode errorCode, InputStream documentStream, File metaData, boolean writeProtected) {
        this.fileAccess = fileAccess;
        this.metaData = metaData;
        this.errorCode = errorCode;
        this.documentStream = documentStream;
        this.writeProtected = writeProtected;
    }

    public ErrorCode getErrorCode() {
        return errorCode;
    }

    public InputStream getDocumentStream() {
        return documentStream;
    }

    public File getMetaData() {
        return metaData;
    }

    public boolean isWriteProtected() {
        return writeProtected;
    }

    public String getLockedByUser() {
        return this.lockedByUser;
    }

    public int getLockedByUserId() {
        return this.lockedByUserId;
    }

    public DocumentFormat getDocumentFormat() {
        return this.documentFormat;
    }

    public void setErrorCode(final ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public void setWriteProtected(boolean writeProtected) {
        this.writeProtected = writeProtected;
    }

    public void setMetaData(final File metaData) {
        this.metaData = metaData;
    }

    public void setDocumentStream(final InputStream documentStream) {
        this.documentStream = documentStream;
    }

    public void setLockedByUser(final String lockedByUser) {
        this.lockedByUser = lockedByUser;
    }

    public void setLockedByUserId(final int lockedByUserId) {
        this.lockedByUserId = lockedByUserId;
    }

    public void setDocumentFormat(final DocumentFormat documentFormat) {
        this.documentFormat = documentFormat;
    }

    public void setFileAccess(final IDBasedFileAccess fileAccess) {
        this.fileAccess = fileAccess;
    }

    @Override
    public void close() throws IOException
    {
        if (null != this.fileAccess) {
            try {
                this.fileAccess.finish();
            } catch (OXException e) {
                LOG.warn("Exception caught while trying to close IDBasedFileAccess instance.", e);
                throw new IOException(e);
            }
        }
    }
}
