/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.xlsx.tools;

import java.util.Iterator;

import org.json.JSONException;
import org.json.JSONObject;
import org.xlsx4j.sml.Col;
import org.xlsx4j.sml.Worksheet;

import com.openexchange.office.FilterException;
import com.openexchange.office.ooxml.xlsx.XlsxOperationDocument;

public class ColumnUtils {

    public enum ColRow {
    	Column, Row;
    }

    public static void applyColumnProperties(XlsxOperationDocument operationDocument, JSONObject columnProperties, String style, Col col, Worksheet worksheet)
        throws FilterException, JSONException {

        // Column properties
        final JSONObject jsonColumnProperties = (columnProperties == null) ? null : columnProperties.optJSONObject("column");
        if(jsonColumnProperties!=null) {
            Iterator<String> keys = jsonColumnProperties.keys();
            while(keys.hasNext()) {
                String attr = keys.next();
                Object value = jsonColumnProperties.get(attr);
                if(attr.equals("width")) {
                	col.setWidth((value instanceof Number) ? ((Number)value).doubleValue() : null);
                	// mac excel is ignoring the width if customWidth is false
                	col.setCustomWidth(true);
                }
                else if(attr.equals("visible")) {
                    Boolean hidden = null;
                    if(value instanceof Boolean) {
                        hidden = !(Boolean)value;
                    }
                    col.setHidden(hidden);
                }
/*
                else if(attr.equals("customWidth")) {
                    Boolean customWidth = null;
                    if(value instanceof Boolean) {
                        customWidth = (Boolean)value;
                    }
                    col.setCustomWidth(customWidth);
                }
*/
            }
        }

        // grouping attributes
        JSONObject jsonGroupAttrs = (columnProperties == null) ? null : columnProperties.optJSONObject("group");
        if (jsonGroupAttrs!=null) {
        	final int level = jsonGroupAttrs.optInt("level", 0);
        	if (level>=1 && level<=7) {
        		col.setOutlineLevel((short)level);
        	} else {
        		col.setOutlineLevel(null);
        	}
        	col.setCollapsed(jsonGroupAttrs.optBoolean("collapsed") ? true : null);
        }

        // set new auto-style, or delete the 'style' attribute for the default auto-style
        if (style != null) {
        	Long index = Utils.parseAutoStyleId(style);
        	if (index != null) {
        		col.setStyle(index.longValue() == 0 ? null : index);
        	}
        }

        // Excel 2013 is having problems with empty columns
        if(col.getWidth()==null) {
            col.setWidth(8.7d);
        }
    }

    public static JSONObject createColumnProperties(XlsxOperationDocument operationDocument, Col col)
        throws JSONException {

        final JSONObject columnProperties = new JSONObject();

        final Double columnWidth = col.getWidth();
        if(columnWidth!=null) {
            columnProperties.put("width", columnWidth);
        }
        if(col.isHidden()) {
            columnProperties.put("visible", false);
        }
        if(col.isCustomWidth()) {
            columnProperties.put("customWidth", true);
        }

        // grouping
        final JSONObject groupProperties = new JSONObject();
        final short level = col.getOutlineLevel();
        if (level >= 1 && level <= 7) {
        	groupProperties.put("level", level);
        }
        if (col.isCollapsed()) {
        	groupProperties.put("collapse", true);
        }

        // create the resulting attribute set
        JSONObject attrs = new JSONObject();
        if (columnProperties.length()>0) {
        	attrs.put("column", columnProperties);
        }
        if (groupProperties.length()>0) {
        	attrs.put("group", groupProperties);
        }

        return (attrs.length()>0) ? attrs : null;
    }
}
