/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odt.dom;

import org.xml.sax.Attributes;

public class TextListItem {

    final TextList parentTextList;
	boolean listHeader;

	final String startValue;
	final String styleOverride;
	String textNumber;

	// each TextListItem must have a valid parentTextList ... null is not allowed

	public TextListItem(TextList parentTextList, boolean listHeader, Attributes attributes) {
		this.parentTextList = parentTextList;
		this.listHeader = listHeader;
		this.textNumber = null;

		startValue = listHeader ? null : attributes.getValue("text:start-value");
		styleOverride = listHeader ? null : attributes.getValue("text:style-override");
	}

	public TextListItem(TextList parentTextList) {
		this.parentTextList = parentTextList;
		this.listHeader = false;
		startValue = null;
		styleOverride = null;
	}

	public TextList getParentTextList() {
		return parentTextList;
	}

	public int getListLevel() {
		return parentTextList.getListLevel();
	}

	public TextListItem getParentTextListItem(int level) {
		if(getListLevel()<level) {
			return null;
		}
		TextListItem ret = this;
		while(ret.getListLevel()>level) {
			ret = ret.getParentTextList().getParentTextListItem();
		}
		return ret;
	}

	public boolean isHeader() {
		return listHeader;
	}

	public void setIsHeader(boolean isHeader) {
	    this.listHeader = isHeader;
	}

	public TextList createChildList(Attributes attributes) {
		return new TextList(this, attributes);
	}

	public void setTextNumber(String textNumber) {
		this.textNumber = textNumber;
	}
}
