/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odt.dom;

import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.xml.sax.SAXException;

import com.openexchange.office.odf.Namespaces;
import com.openexchange.office.odf.SaxContextHandler;
import com.openexchange.office.tools.string.UnicodeValidator;

public class Text implements IElementWriter {

	private String text = "";
	private final boolean modified;

	public Text(String text, boolean modified) {
		this.text = text;
		this.modified = modified;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	@Override
	public void writeObject(SerializationHandler output) throws SAXException {
		
		int index = 0;
		while(index<text.length()) {

			if(text.charAt(index) == ' ') {
				int count = countSpaces(text, index);
				if(index!=0&&count==1) {
					output.characters(" ");
				}
				else {
					output.startElement(Namespaces.TEXT, "s", "text:s");
					if(count>1) {
						SaxContextHandler.addAttribute(output, Namespaces.TEXT, "c", "text:c", Integer.toString(count));
					}
					output.endElement(Namespaces.TEXT, "s", "text:s");
				}
				index += count;
			}
			else {
				int count = countNonSpaces(text, index);
				final String s = text.substring(index, index + count);
				output.characters(modified ? UnicodeValidator.replaceInvalidCharacters(s, (char)0x26a1):s);
				index += count;
			}
		}
	}

	public static int countSpaces(String text, int index) {
		int count = 0;
		while(index + count < text.length()) {
			if(text.charAt(index + count) != ' ') {
				break;
			}
			count++;
		}
		return count;
	}

	public static int countNonSpaces(String text, int index) {
		int count = 0;
		while(index + count < text.length()) {
			if(text.charAt(index + count) == ' ') {
				break;
			}
			count++;
		}
		return count;
	}
}
