/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odf.styles;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import com.openexchange.office.odf.AttributeImpl;
import com.openexchange.office.odf.AttributesImpl;
import com.openexchange.office.odf.ElementNSWriter;
import com.openexchange.office.odf.SaxContextHandler;
import com.openexchange.office.odf.UnknownContentHandler;

public class StylesHandler extends SaxContextHandler {

    private final StyleManager styleManager;

    public StylesHandler(SaxContextHandler parentContext, StyleManager styleManager)
    	throws SAXException {

    	super(parentContext);
    	this.styleManager = styleManager;
    }

    public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName)
    	throws SAXException {

    	final AttributesImpl attributesImpl = new AttributesImpl(attributes);
    	String name = removeNameFromAttributes(attributesImpl);
    	if(name==null) {
    		// default styles does not have a name, we will check this...
    		if(qName.equals("style:default-style")) {
    			name = "_default";
    		}
    	}
    	if(name!=null) {
	    	switch(qName) {
	    		case "style:default-style" : {
	    			final SaxContextHandler styleHandler = StylesHandler.getStyleHandler(this, name, styleManager, attributesImpl, true, false, false);
	    			if(styleHandler!=null) {
	    				return styleHandler;
	    			}
	    			break;
	    		}
	    		case "style:style" : {
	    			final SaxContextHandler styleHandler = StylesHandler.getStyleHandler(this, name, styleManager, attributesImpl, false, false, false);
	    			if(styleHandler!=null) {
	    				return styleHandler;
	    			}
	    			break;
	    		}
	    		case "number:number-style": {
		    		return new NumberNumberStyleHandler(this, new NumberNumberStyle(name, attributesImpl, false, false), styleManager);
	    		}
	    		case "number:boolean-style": {
		    		return new NumberBooleanStyleHandler(this, new NumberBooleanStyle(name, attributesImpl, false, false), styleManager);
	    		}
	    		case "number:currency-style" : {
		    		return new NumberCurrencyStyleHandler(this, new NumberCurrencyStyle(name, attributesImpl, false, false), styleManager);
	    		}
	    		case "number:date-style" : {
		    		return new NumberDateStyleHandler(this, new NumberDateStyle(name, attributesImpl, false, false), styleManager);
	    		}
	    		case "number:percentage-style" : {
		    		return new NumberPercentageStyleHandler(this, new NumberPercentageStyle(name, attributesImpl, false, false), styleManager);
	    		}
	    		case "number:text-style" : {
		    		return new NumberTextStyleHandler(this, new NumberTextStyle(name, attributesImpl, false, false), styleManager);
	    		}
	    		case "number:time-style" : {
		    		return new NumberTimeStyleHandler(this, new NumberTimeStyle(name, attributesImpl, false, false), styleManager);
	    		}
	    		case "text:list-style" : {
		    		return new TextListStyleHandler(this, new TextListStyle(name, attributesImpl, false, false), styleManager);
	    		}
	    		case "draw:stroke-dash" : {
	    			return new StrokeDashStyleHandler(this, new StrokeDashStyle(name, attributesImpl, false, false), styleManager);
	    		}
	    	}
    	}
    	final ElementNSWriter element = new ElementNSWriter(getFileDom(), attributes, uri, qName);
    	styleManager.getStyles().getContent().add(element);
		return new UnknownContentHandler(this, element);
    }

    public static String removeNameFromAttributes(AttributesImpl attributesImpl) {
    	AttributeImpl attributeImpl = attributesImpl.remove("style:name");
		if(attributeImpl==null) {
			// WTF is the style name for the "draw:stroke-dash" a "draw:name" and not a "style:name" as each other style is using
			attributeImpl = attributesImpl.remove("draw:name");
		}
		if(attributeImpl!=null) {
			final String name = attributeImpl.getValue();
			if(name!=null&&!name.isEmpty()) {
				return name;
			}
		}
		return null;
    }

    public static SaxContextHandler getStyleHandler(SaxContextHandler context, String name, StyleManager styleManager, AttributesImpl attributesImpl, boolean defaultStyle, boolean automaticStyle, boolean contentStyle) {
    	final String family = attributesImpl.getValue("style:family");
		if(family==null) {
			return null;
		}
		switch(family) {
			case "text" : {
				return new StyleTextHandler(context, new StyleText(name, attributesImpl, defaultStyle, automaticStyle, contentStyle), styleManager);
			}
			case "paragraph" : {
				return new StyleParagraphHandler(context, new StyleParagraph(name, attributesImpl, defaultStyle, automaticStyle, contentStyle), styleManager);
			}
			case "section" : {
				return new StyleSectionHandler(context, new StyleSection(name, attributesImpl, defaultStyle, automaticStyle, contentStyle), styleManager);
			}
			case "ruby" : {
				return new StyleRubyHandler(context, new StyleRuby(name, attributesImpl, defaultStyle, automaticStyle, contentStyle), styleManager);
			}
			case "table" : {
				return new StyleTableHandler(context, new StyleTable(name, attributesImpl, defaultStyle, automaticStyle, contentStyle), styleManager);
			}
			case "table-column" : {
				return new StyleTableColumnHandler(context, new StyleTableColumn(name, attributesImpl, defaultStyle, automaticStyle, contentStyle), styleManager);
			}
			case "table-row" : {
				return new StyleTableRowHandler(context, new StyleTableRow(name, attributesImpl, defaultStyle, automaticStyle, contentStyle), styleManager);
			}
			case "table-cell" : {
				return new StyleTableCellHandler(context, new StyleTableCell(name, attributesImpl, defaultStyle, automaticStyle, contentStyle), styleManager);
			}
			case "graphic" : {
				return new StyleGraphicHandler(context, new StyleGraphic(name, attributesImpl, defaultStyle, automaticStyle, contentStyle), styleManager);
			}
			case "presentation" : {
				return new StylePresentationHandler(context, new StylePresentation(name, attributesImpl, defaultStyle, automaticStyle, contentStyle), styleManager);
			}
			case "drawing-page" : {
				return new StyleDrawingPageHandler(context, new StyleDrawingPage(name, attributesImpl, defaultStyle, automaticStyle, contentStyle), styleManager);
			}
			case "chart" : {
				new StyleChartHandler(context, new StyleChart(name, attributesImpl, defaultStyle, automaticStyle, contentStyle), styleManager);
			}
		}
    	return null;
    }
}
