/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.odf.styles;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.element.office.OfficeBodyElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentStylesElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@SuppressWarnings("serial")
public class DocumentStyles extends OdfFileDom {

	public DocumentStyles(OdfSchemaDocument odfDocument, String packagePath) throws SAXException {
		super(odfDocument, packagePath);
	}

    /**
     * Might be used to initialize specific XML Namespace prefixes/URIs for this
     * XML file
     */
    @Override
    protected void initialize() throws SAXException {
        for (NamespaceName name : OdfDocumentNamespace.values()) {
            mUriByPrefix.put(name.getPrefix(), name.getUri());
            mPrefixByUri.put(name.getUri(), name.getPrefix());
        }
        final StyleManager styleManager = getStyleManager();
        styleManager.setStyles(new Styles(this));
        styleManager.setMasterStyles(new MasterStyles(this));
        styleManager.setAutomaticStyles(new AutomaticStyles(this), false);
        styleManager.setFontFaceDecls(new FontFaceDecls(this), false);

        final XMLReader xmlReader = mPackage.getXMLReader();
        super.initialize(new DocumentStylesHandler(this, xmlReader), xmlReader, this);

        final Node root = getRootElement();
        root.appendChild(styleManager.getFontFaceDecls(false));
        root.appendChild(styleManager.getStyles());
        root.appendChild(styleManager.getAutomaticStyles(false));
        root.appendChild(styleManager.getMasterStyles());
    }

    public Styles getStyles() {
    	return getStyleManager().getStyles();
    }

    /**
     * Retrieves the Odf Document
     *
     * @return The <code>OdfDocument</code>
     */
    @Override
    public OdfSchemaDocument getDocument() {
        return (OdfSchemaDocument) mPackageDocument;
    }

    /**
     * * @return The root element <office:document-styles> of the styles.xml
     * file as <code>OfficeDocumentStylesElement</code>.
     */
    @Override
    public OfficeDocumentStylesElement getRootElement() {
        return (OfficeDocumentStylesElement) getDocumentElement();
    }

    /**
     * Creates an JDK <code>XPath</code> instance. Initialized with ODF
     * namespaces from <code>OdfDocumentNamespace</code>. Updated with all
     * namespace of the XML file.
     *
     * @return an XPath instance with namespace context set to include the
     * standard ODFDOM prefixes.
     */
    @Override
    public XPath getXPath() {
        if (mXPath == null) {
            mXPath = XPathFactory.newInstance().newXPath();
            mXPath.setNamespaceContext(this);
            for (NamespaceName name : OdfDocumentNamespace.values()) {
                mUriByPrefix.put(name.getPrefix(), name.getUri());
                mPrefixByUri.put(name.getUri(), name.getPrefix());
            }
        }
        return mXPath;
    }

    public OdfOfficeAutomaticStyles getOrCreateAutomaticStyles() {

        OdfOfficeAutomaticStyles automaticStyles = getAutomaticStyles_DEPRECATED();
        if (automaticStyles == null) {
            automaticStyles = newOdfElement(OdfOfficeAutomaticStyles.class);

            Node parent = getFirstChild();

            // try to insert before body or before master-styles element
            OdfElement sibling = OdfElement.findFirstChildNode(OfficeBodyElement.class, parent);
            if (sibling == null) {
                sibling = OdfElement.findFirstChildNode(OdfOfficeMasterStyles.class, parent);
            }
            if (sibling == null) {
                parent.appendChild(automaticStyles);
            } else {
                parent.insertBefore(automaticStyles, sibling);
            }
        }
        return automaticStyles;
    }
	


	// ToDo bug 72 - STYLE REFACTORING - THE FOLLOWING METHODS WILL BE RE/MOVED
    // As Package layer should not refer to DOM/DOC layer and DOM files should not
    // handle automatic styles the upcoming DOM Document should capsulate this.
    /**
     * @return the style:office-styles element of this dom. May return null if
     * there is not yet such element in this dom.
     *
     * @see #getOrCreateAutomaticStyles()
     *
     */
    public OdfOfficeStyles getOfficeStyles() {
        return OdfElement.findFirstChildNode(OdfOfficeStyles.class, getFirstChild());
    }

    /**
     * Retrieve the ODF AutomaticStyles
     *
     * @return the {
     * @odf.element office:automatic-styles} element of this dom. May return
     * null if there is not yet such element in this dom.
     *
     * @see #getOrCreateAutomaticStyles()
     *
     */
    public OdfOfficeAutomaticStyles getAutomaticStyles_DEPRECATED() {
        return OdfElement.findFirstChildNode(OdfOfficeAutomaticStyles.class, getFirstChild());
    }

    /**
     * Retrieve the ODF MasterStyles
     *
     * @return the {
     * @odf.element office:master-styles} element of this dom. May return null
     * if there is not yet such element in this dom.
     *
     */
    public OdfOfficeMasterStyles getMasterStyles_DEPRECATED() {
        return OdfElement.findFirstChildNode(OdfOfficeMasterStyles.class, getFirstChild());
    }
    
    /**
     * Retrieve the ODF MasterStyles
     *
     * @return the {
     * @odf.element office:master-styles} element of this dom or creates a new one.
     *
     */
    public OdfOfficeMasterStyles getOrCreateMasterStyles() {
        OdfOfficeMasterStyles masterStyles = getMasterStyles_DEPRECATED();
        if (masterStyles == null) {
            masterStyles = newOdfElement(OdfOfficeMasterStyles.class);
            Node parent = getFirstChild();            
            parent.appendChild(masterStyles);
        }
        return masterStyles;                
    }    

    public static OdfStyleFamily getFamily(String styleId) {
        OdfStyleFamily family = null;
        if (styleId.equals("paragraph")) {
            family = OdfStyleFamily.Paragraph;
        } else if (styleId.equals("character")) {
            family = OdfStyleFamily.Text;
        } else if (styleId.equals("table")) {
            family = OdfStyleFamily.Table;
        } else if (styleId.equals("row")) {
            family = OdfStyleFamily.TableRow;
        } else if (styleId.equals("cell")) {
            family = OdfStyleFamily.TableCell;
        } else if (styleId.equals("column")) {
            family = OdfStyleFamily.TableColumn;
        } else if (styleId.equals("drawing")) {
            family = OdfStyleFamily.Graphic;
        }
        return family;
    }
}
