package com.openexchange.office.odf.properties;

import java.util.Iterator;

import org.apache.xml.serializer.SerializationHandler;
import org.json.JSONObject;
import org.odftoolkit.odfdom.IElementWriter;
import org.xml.sax.SAXException;

import com.openexchange.office.odf.AttributesImpl;
import com.openexchange.office.odf.DLList;
import com.openexchange.office.odf.OpAttrs;
import com.openexchange.office.odf.SaxContextHandler;
import com.openexchange.office.odf.styles.StyleManager;

public abstract class StyleNumberPropertiesBase extends StylePropertiesBase {

	public StyleNumberPropertiesBase(AttributesImpl attributesImpl) {
		super(attributesImpl);
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		SaxContextHandler.startElement(output, getNamespace(), getLocalName(), getQName());
		attributes.write(output);
		if(!text.isEmpty()) {
			output.characters(text);
		}
		final DLList<IElementWriter> content = getContent();
		if(content!=null) {
			final Iterator<IElementWriter> childIter = content.iterator();
			while(childIter.hasNext()) {
				childIter.next().writeObject(output);
			}
		}
		SaxContextHandler.endElement(output, getNamespace(), getLocalName(), getQName());

	}

	@Override
	public final void applyAttrs(StyleManager styleManager, JSONObject attrs) {}

	@Override
	public final void createAttrs(StyleManager styleManager, boolean contentAutoStyle, OpAttrs attrs) {}
}
