/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odf.properties;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

import org.json.JSONObject;

import com.openexchange.office.odf.AttributeImpl;
import com.openexchange.office.odf.AttributesImpl;
import com.openexchange.office.odf.Namespaces;
import com.openexchange.office.odf.OpAttrs;
import com.openexchange.office.odf.styles.StyleManager;

final public class PageLayoutProperties extends StylePropertiesBase {

	public PageLayoutProperties(AttributesImpl attributesImpl) {
		super(attributesImpl);
	}

	@Override
	public String getQName() {
		return "style:page-layout-properties";
	}

	@Override
	public String getLocalName() {
		return "page-layout-properties";
	}

	@Override
	public String getNamespace() {
		return Namespaces.STYLE;
	}

	@Override
	public void applyAttrs(StyleManager styleManager, JSONObject attrs) {
		final JSONObject pageAttributes = attrs.optJSONObject("page");
		if(pageAttributes!=null) {
			final Iterator<Entry<String, Object>> paragraphIter = pageAttributes.entrySet().iterator();
			while(paragraphIter.hasNext()) {
				final Entry<String, Object> paragraphEntry = paragraphIter.next();
				final Object value = paragraphEntry.getValue();
				switch(paragraphEntry.getKey()) {
					case "marginBottom": {
		                if(value==JSONObject.NULL) {
		                	attributes.remove("fo:margin-bottom");
		                }
		                else {
		                    attributes.setValue(Namespaces.FO, "margin-bottom", "fo:margin-bottom", (((Number)value).intValue() / 100) + "mm");
		                }
		                break;
					}
					case "marginLeft": {
		                if(value==JSONObject.NULL) {
		                	attributes.remove("fo:margin-left");
		                }
		                else {
		                    attributes.setValue(Namespaces.FO, "margin-left", "fo:margin-left", (((Number)value).intValue() / 100) + "mm");
		                }
		                break;
					}
					case "marginRight": { 
		                if(value==JSONObject.NULL) {
		                	attributes.remove("fo:margin-right");
		                }
		                else {
		                    attributes.setValue(Namespaces.FO, "margin-right", "fo:margin-right", (((Number)value).intValue() / 100) + "mm");
		                }
		                break;
					}
					case "marginTop": {
		                if(value==JSONObject.NULL) {
		                	attributes.remove("fo:margin-top");
		                }
		                else {
		                    attributes.setValue(Namespaces.FO, "margin-top", "fo:margin-top", (((Number)value).intValue() / 100) + "mm");
		                }
		                break;
					}
					case "width": {
		                if(value==JSONObject.NULL) {
		                	attributes.remove("fo:page-width");
		                }
		                else {
		                    attributes.setValue(Namespaces.FO, "page-width", "fo:page-width", (((Number)value).intValue() / 100) + "mm");
		                }
		                break;
					}
					case "height": {
		                if(value==JSONObject.NULL) {
		                	attributes.remove("fo:page-height");
		                }
		                else {
		                    attributes.setValue(Namespaces.FO, "page-height", "fo:page-height", (((Number)value).intValue() / 100) + "mm");
		                }
		                break;
					}
				}
			}
		}
	}

	@Override
	public void createAttrs(StyleManager styleManager, boolean contentAutoStyle, OpAttrs attrs) {
		final HashMap<String, Object> pageAttrs = attrs.getMap("page", true);
		final Iterator<Entry<String, AttributeImpl>> propIter = attributes.getUnmodifiableMap().entrySet().iterator();
        while(propIter.hasNext()) {
        	final Entry<String, AttributeImpl> propEntry = propIter.next();
        	final String propName = propEntry.getKey();
        	final String propValue = propEntry.getValue().getValue();
        	switch(propName) {
	    		case "fo:margin-left": {
	    			final Integer margin = AttributesImpl.normalizeLength(propValue, true);
	                if(margin!=null) {
	                	pageAttrs.put("marginLeft", margin);
	                }
	    			break;
	    		}
	    		case "fo:margin-top": {
	    			final Integer margin = AttributesImpl.normalizeLength(propValue, true);
	                if(margin!=null) {
	                	pageAttrs.put("marginTop", margin);
	                }
	    			break;
	    		}
	    		case "fo:margin-right": {
	    			final Integer margin = AttributesImpl.normalizeLength(propValue, true);
	    			if(margin!=null) {
	    				pageAttrs.put("marginRight", margin);
	    			}
	    			break;
	    		}
	    		case "fo:margin-bottom": {
	    			final Integer margin = AttributesImpl.normalizeLength(propValue, true);
	    			if(margin!=null) {
	    				pageAttrs.put("marginBottom", margin);
	    			}
	    			break;
	    		}
        		case "fo:page-width": {
        			final Integer pageWidth = AttributesImpl.normalizeLength(propValue, true);
        			if(pageWidth!=null) {
        				pageAttrs.put("width", pageWidth);
        			}
        			break;
	            }
        		case "fo:page-height": {
        			final Integer pageHeight = AttributesImpl.normalizeLength(propValue, true);
        			if(pageHeight!=null) {
        				pageAttrs.put("height", pageHeight);
        			}
        			break;
	            }
        	}
        }
        if(pageAttrs.isEmpty()) {
        	attrs.remove("page");
        }
	}

	@Override
	public PageLayoutProperties clone() {
		return (PageLayoutProperties)_clone();
	}
}
