/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odf.properties;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import org.json.JSONObject;
import org.odftoolkit.odfdom.IElementWriter;

import com.openexchange.office.odf.AttributeImpl;
import com.openexchange.office.odf.AttributesImpl;
import com.openexchange.office.odf.Border;
import com.openexchange.office.odf.DLList;
import com.openexchange.office.odf.Namespaces;
import com.openexchange.office.odf.OpAttrs;
import com.openexchange.office.odf.styles.StyleManager;

final public class DrawingPageProperties extends StylePropertiesBase {

	private DLList<IElementWriter> content;

	public DrawingPageProperties(AttributesImpl attributesImpl) {
		super(attributesImpl);
	}

	@Override
	public DLList<IElementWriter> getContent() {
		if(content==null) {
			content = new DLList<IElementWriter>();
		}
		return content;
	}

	@Override
	public String getQName() {
		return "style:drawing-page-properties";
	}

	@Override
	public String getLocalName() {
		return "drawing-page-properties";
	}

	@Override
	public String getNamespace() {
		return Namespaces.STYLE;
	}

	@Override
	public void applyAttrs(StyleManager styleManager, JSONObject attrs) {
		
	}

	@Override
	public void createAttrs(StyleManager styleManager, boolean contentAutoStyle, OpAttrs attrs) {
		final HashMap<String, Object> pageAttrs = attrs.getMap("page", true);
		PropertyHelper.createDefaultMarginAttrs(pageAttrs, attributes);
        final Integer defaultPadding = PropertyHelper.createDefaultPaddingAttrs(pageAttrs, attributes);
        Border.createDefaultBorderMapAttrs(pageAttrs, defaultPadding, attributes);
        final Iterator<Entry<String, AttributeImpl>> propIter = attributes.getUnmodifiableMap().entrySet().iterator();
        while(propIter.hasNext()) {
        	final Entry<String, AttributeImpl> propEntry = propIter.next();
        	final String propName = propEntry.getKey();
        	final String propValue = propEntry.getValue().getValue();
        	switch(propName) {
	    		case "fo:margin-left": {
	    			final Integer margin = AttributesImpl.normalizeLength(propValue, true);
	                if(margin!=null) {
	                	pageAttrs.put("marginLeft", margin);
	                	pageAttrs.put("indentLeft", margin);
	                }
	    			break;
	    		}
	    		case "fo:margin-top": {
	    			final Integer margin = AttributesImpl.normalizeLength(propValue, true);
	                if(margin!=null) {
	                	pageAttrs.put("marginTop", margin);
	                }
	    			break;
	    		}
	    		case "fo:margin-right": {
	    			final Integer margin = AttributesImpl.normalizeLength(propValue, true);
	    			if(margin!=null) {
	    				pageAttrs.put("marginRight", margin);
	    				pageAttrs.put("indentRight", margin);
	    			}
	    			break;
	    		}
	    		case "fo:margin-bottom": {
	    			final Integer margin = AttributesImpl.normalizeLength(propValue, true);
	    			if(margin!=null) {
	    				pageAttrs.put("marginBottom", margin);
	    			}
	    			break;
	    		}
	    		case "fo:padding-left": {
	    			final Integer padding = AttributesImpl.normalizeLength(propValue, true);
	    			if(padding!=null) {
	    				pageAttrs.put("paddingLeft", padding);
	    			}
	    			break;
	    		}
	    		case "fo:padding-top": {
	    			final Integer padding = AttributesImpl.normalizeLength(propValue, true);
	    			if(padding!=null) {
	    				pageAttrs.put("paddingTop", padding);
	    			}
	    			break;
	    		}
	    		case "fo:padding-right": {
	    			final Integer padding = AttributesImpl.normalizeLength(propValue, true);
	    			if(padding!=null) {
	    				pageAttrs.put("paddingRight", padding);
	    			}
	    			break;
	    		}
	    		case "fo:padding-bottom": {
	    			final Integer padding = AttributesImpl.normalizeLength(propValue, true);
	    			if(padding!=null) {
	    				pageAttrs.put("paddingBottom", padding);
	    			}
	    			break;
	    		}
	    		case "fo:border-left": {
	    			final Map<String, Object> border = Border.createBorderMap(propValue, defaultPadding);
	                if(border!=null) {
	                	pageAttrs.put("borderLeft", border);
	                }
	    			break;
	    		}
	    		case "fo:border-top": {
	    			final Map<String, Object> border = Border.createBorderMap(propValue, defaultPadding);
	                if(border!=null) {
	                	pageAttrs.put("borderTop", border);
	                }
	    			break;
	    		}
	    		case "fo:border-right": {
	    			final Map<String, Object> border = Border.createBorderMap(propValue, defaultPadding);
	                if(border!=null) {
	                	pageAttrs.put("borderRight", border);
	                }
	    			break;
	    		}
	    		case "fo:border-bottom": {
	    			final Map<String, Object> border = Border.createBorderMap(propValue, defaultPadding);
	                if(border!=null) {
	                	pageAttrs.put("borderBottom", border);
	                }
	    			break;
	    		}
	    		case "fo:background-color": {
	    			pageAttrs.put("fillColor", PropertyHelper.createColorMap(propValue));
	    			break;
	    		}
	    		case "fo:page-width": {
	    			final Integer width = AttributesImpl.normalizeLength(propValue);
	    			if(width!=null) {
	    				pageAttrs.put("width", width);
	    			}
	    			break;
	    		}
	    		case "fo:page-height": {
	    			final Integer height = AttributesImpl.normalizeLength(propValue);
	    			if(height!=null) {
	    				pageAttrs.put("height", height);
	    			}
	    			break;
	    		}    
	    		case "style:print-orientation": {
	    			pageAttrs.put("printOrientation", propValue);
	       			break;
	       	  	}
	    		case "style:num-format": {
	                pageAttrs.put("numberFormat", propValue);
	                break;
	            }
	    	}
        }
	}

	@Override
	public DrawingPageProperties clone() {
		return (DrawingPageProperties)_clone();
	}
}

/*        	
        } else if (propName.equals("style:num-format")) {
            propValue = odfProps.get("style:num-format");
            pageAttrs.put("numberFormat", propValue);
        }
*/