/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.json.tools.fields;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.office.DocumentProperties;
import com.openexchange.office.IExporter;
import com.openexchange.office.IImporter;
import com.openexchange.office.doc.imexport.ImExportHelper;
import com.openexchange.office.tools.doc.DocumentFormat;
import com.openexchange.office.tools.files.DocFileHelper;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;

public class DynamicFields
{

	public static InputStream insertOptionalFields(
        InputStream inputStm,
        String extensionType,
        AJAXRequestData request,
        JSONObject result,
        ServerSession session,
        ServiceLookup services)
            throws Exception
    {
		try {

	        final String sfs = request.getParameter("sourcefields");
	        final String fs = request.getParameter("fields");

	        final DocumentFormat format = DocFileHelper.getDocumentFormat("." + extensionType);
	        final IImporter importer = ImExportHelper.getImporterService(services, format);
	        final IExporter exporter = ImExportHelper.getExporterService(services, format);

	        final DocumentProperties documentProperties = new DocumentProperties();
	        documentProperties.put(DocumentProperties.PROP_SAVE_TEMPLATE_DOCUMENT, false);

	        FieldsParser parser = null;
	        if (StringUtils.isNotBlank(sfs))
	        {
	            parser = new FieldsParserJSONSheets(sfs, session, services, format);
	        }
	        else if (StringUtils.isNotBlank(fs))
	        {
	            if (format == DocumentFormat.XLSX || format == DocumentFormat.ODS)
	            {
	                parser = new FieldsParserSheets(fs);
	            }
	            else
	            {
	                parser = new FieldsParserParam(fs);
	            }
	        }
	        else
	        {
	            return inputStm;
	        }

	        FieldsHandler handler = null;
	        if (format == DocumentFormat.XLSX || format == DocumentFormat.ODS)
	        {
	            handler = new FieldsHandlerSheet();
	        }
	        else
	        {
	            handler = new FieldsHandlerText();
	        }

	        Map<String, Object> fields = parser.getFields();

	        boolean resetable = false;//inputStm.markSupported();
	        // TODO: 10.20.70.123/appsuite/#debug-js=true&autologin=1&app=io.ox/office/text&folder=369&convert=1&id=415&destfolderid=371&fields=BSStrasse;Coole%20strasse%2047;BSPLZ;777
	        JSONObject doc = null;

			if (resetable) {
				doc = importer.createOperations(session, inputStm, documentProperties);
				inputStm.reset();
			} else {
				List<InputStream> inputStreams = copyStream(inputStm);
			    inputStm = inputStreams.get(0);
			    InputStream newInputStm = inputStreams.get(1);
			    doc = importer.createOperations(session, newInputStm, documentProperties);
			}


	        JSONArray ops = doc.getJSONArray("operations");

	        JSONArray newOps = handler.getMergeOperations(ops, fields);

	        if (newOps.length() > 0)
	        {
	            final String mergeOperations = newOps.toString();

	            inputStm = exporter.createDocument(session, inputStm, mergeOperations, null, documentProperties, true);

	            result.put("fieldChanges", newOps.length());
	        }
	        else
	        {
	            result.put("fieldChanges", "none");
	        }

        } catch (Throwable e) {
			e.printStackTrace();
			throw new Exception(e);
		}
        return inputStm;
    }

    private static List<InputStream> copyStream(
        InputStream input)
            throws Exception
    {

        ByteArrayOutputStream baos = new ByteArrayOutputStream();

        // Fake code simulating the copy
        // You can generally do better with nio if you need...
        // And please, unlike me, do something about the Exceptions :D
        byte[] buffer = new byte[1024];
        int len;
        while ((len = input.read(buffer)) > -1)
        {
            baos.write(buffer, 0, len);
        }
        baos.flush();

        List<InputStream> res = new ArrayList<InputStream>();

        // Open new InputStreams using the recorded bytes
        // Can be repeated as many times as you wish
        res.add((new ByteArrayInputStream(baos.toByteArray())));
        res.add((new ByteArrayInputStream(baos.toByteArray())));

        return res;
    }

}
