/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.json.actions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.office.json.tools.EmptyDocumentCache;
import com.openexchange.office.json.tools.TemplateFilesScanner;
import com.openexchange.office.tools.files.LocalFileMappingManager;
import com.openexchange.office.tools.resource.ResourceManager;
import com.openexchange.server.ServiceLookup;

/**
 * {@link DocumentFilterActionFactory}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class DocumentFilterActionFactory implements AJAXActionServiceFactory {

    private final Map<String, AJAXActionService> actions = new HashMap<String, AJAXActionService>();
    private ResourceManager resourceManager = null;
    private TemplateFilesScanner templateFilesScanner = null;
    private LocalFileMappingManager localFileMapper = null;
    private EmptyDocumentCache emptyDocCache = null;

    /**
     * Initializes a new {@link DocumentFilterActionFactory}.
     */
    public DocumentFilterActionFactory(final ServiceLookup services) {
        super();

        resourceManager = new ResourceManager(services);
        localFileMapper = new LocalFileMappingManager();
        templateFilesScanner = new TemplateFilesScanner(services, localFileMapper, TemplateFilesScanner.TemplateFilterType.ALL_DOCUMENTS);
        emptyDocCache = new EmptyDocumentCache();

        actions.put("addfile", new AddFileAction(services, resourceManager));
        actions.put("createdefaultdocument", new CreateDefaultDocumentAction(services, emptyDocCache));
        actions.put("getdocument", new GetDocumentAction(services));
        actions.put("getfeatures", new GetFeaturesAction(services));
        actions.put("getfile", new GetFileAction(services, resourceManager));
        actions.put("renamedocument", new RenameDocumentAction(services));
        actions.put("updateview", new UpdateViewAction(services));
        actions.put("replaceAll", new ReplaceAllAction(services));
        actions.put("query", new QueryAction(services));
        actions.put("copy", new CopyAction(services));
        actions.put("paste", new PasteAction(services));
        actions.put("gethtmlcode", new GetHtmlCodeAction(services));
        actions.put("copydocument", new CopyDocumentAction(services));
        actions.put("gettemplatelist", new GetTemplateListAction(services, templateFilesScanner));
        actions.put("createfromtemplate", new CreateFromTemplateAction(services, localFileMapper));
        actions.put("templatepreview", new TemplatePreviewAction(services, localFileMapper));
        actions.put("gettemplateandrecentlist", new GetTemplateAndRecentListAction(services, templateFilesScanner));
        actions.put("deletefilefromrecentlist", new DeleteFileFromRecentListAction(services));
        actions.put("clearrecentlist", new ClearRecentListAction(services));
        actions.put("prefetchofficeparts", new PrefetchOfficePartsAction(services, emptyDocCache));
        actions.put("getuserinfo", new GetUserInfoAction(services));
        actions.put("sort", new SortAction(services));
        actions.put("getcontexttemplatefolders", new GetContextTemplateFoldersAction(services));
        actions.put("saveaswithbackup", new SaveAsWithBackupAction(services));
    }

    @Override
    public AJAXActionService createActionService(final String action) {
        return (actions.get(action));
    }

    @Override
    public Collection<? extends AJAXActionService> getSupportedServices() {
        return java.util.Collections.unmodifiableCollection(actions.values());
    }
}
