package com.openexchange.office.tools.htmldoc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GenDocHelper
{
    private final static String EMPTYSPAN = "<span nonjquerydata=\"{&quot;isempty&quot;:true}\" style=\"font-family: Arial, Helvetica, sans-serif; font-weight: normal; font-style: normal; text-decoration: none; color: rgb(0, 0, 0); font-size: 11pt; vertical-align: baseline; line-height: 20px; background-color: transparent;\"></span>";
    private final static String EMPTYSPAN_NOSTYLE = "<span nonjquerydata=\"{&quot;isempty&quot;:true}\"></span>";

    static JSONArray shiftedCopy(
        JSONArray input)
    {
        final List<Object> list = input.asList();
        list.remove(0);
        return new JSONArray(list);
    }

    public static void appendAttributes(
        JSONObject attrs,
        StringBuilder document)
            throws JSONException
    {

        appendAttributes(attrs, document, false);

    }

    public static JSONObject getJQueryData(
        JSONObject attrs)
            throws JSONException
    {
        return getJQueryData(attrs, false);
    }

    public static void appendAttributes(
        JSONObject attrs,
        StringBuilder document,
        boolean implicit)
            throws JSONException
    {
        final JSONObject adapter = getJQueryData(attrs, implicit);
        appendJQueryData(document, adapter);
    }

    public static void appendJQueryData(
        StringBuilder document,
        JSONObject jquerydata)
            throws JSONException
    {

        if (jquerydata.length() > 0)
        {
            document.append(" jquerydata='");
            String str = StringEscapeUtils.escapeHtml(jquerydata.toString());
            str = str.replace("'", "&#39;"); // escaping all single quotes (49847)
            document.append(str);
            document.append("' ");
        }
    }

    public static JSONObject getJQueryData(
        JSONObject attrs,
        boolean implicit)
            throws JSONException
    {
        final JSONObject adapter = new JSONObject();
        if (attrs != null)
        {
            adapter.put("attributes", attrs);
        }
        if (implicit)
        {
            adapter.put("implicit", true);
        }
        return adapter;
    }

    public static boolean addEmptySpanForNecessaryNode(
        StringBuilder doc,
        INode node,
        boolean emptySpanNeeded)
    {
        boolean nodeTypeNeedsEmptySpan = node.needsEmptySpan();

        if (nodeTypeNeedsEmptySpan && emptySpanNeeded)
        {
            doc.append(EMPTYSPAN);
        }

        return nodeTypeNeedsEmptySpan;
    }

    public static void addEmptySpan(
        StringBuilder doc, boolean style)
    {
        if (style) {
            doc.append(EMPTYSPAN);
        } else {
            doc.append(EMPTYSPAN_NOSTYLE);
        }
    }

    public static final String escapeSingleQuote(
        final String text)
    {
        return text.replaceAll("'", "&#39");
    }

    private static final Map<String, Float> FACTORS;

    static
    {
        FACTORS = new HashMap<String, Float>();
        FACTORS.put("px", 1F);
        FACTORS.put("pc", 1F / 9F);
        FACTORS.put("pt", 4F / 3F);
        FACTORS.put("in", 96F);
        FACTORS.put("cm", 96F / 2.54F);
        FACTORS.put("mm", 96F / 25.4F);
    }

    public static float convertLength(
        float value,
        String fromUnit,
        String toUnit)
    {
        value *= FACTORS.get(fromUnit) / FACTORS.get(toUnit);
        return value;
    }

    public static float convertHmmToLength(
        float value,
        String toUnit)
    {
        return convertLength(value / 100, "mm", toUnit);
    };

    public static float convertHmmToPx(
        float value)
    {
        return convertHmmToLength(value, "px");
    };

}
