/*
*
*    OPEN-XCHANGE legal information
*
*    All intellectual property rights in the Software are protected by
*    international copyright laws.
*
*
*    In some countries OX, OX Open-Xchange, open xchange and OXtender
*    as well as the corresponding Logos OX Open-Xchange and OX are registered
*    trademarks.
*    The use of the Logos is not covered by the GNU General Public License.
*    Instead, you are allowed to use these Logos according to the terms and
*    conditions of the Creative Commons License, Version 2.5, Attribution,
*    Non-commercial, ShareAlike, and the interpretation of the term
*    Non-commercial applicable to the aforementioned license is published
*    on the web site http://www.open-xchange.com/EN/legal/index.html.
*
*    Please make sure that third-party modules and libraries are used
*    according to their respective licenses.
*
*    Any modifications to this package must retain all copyright notices
*    of the original copyright holder(s) for the original code used.
*
*    After any such modifications, the original and derivative code shall remain
*    under the copyright of the copyright holder(s) and/or original author(s)per
*    the Attribution and Assignment Agreement that can be located at
*    http://www.open-xchange.com/EN/developer/. The contributing author shall be
*    given Attribution for the derivative code and a license granting use.
*
*     Copyright (C) 2016 OX Software GmbH
*     Mail: info@open-xchange.com
*
*
*     This program is free software; you can redistribute it and/or modify it
*     under the terms of the GNU General Public License, Version 2 as published
*     by the Free Software Foundation.
*
*     This program is distributed in the hope that it will be useful, but
*     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
*     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
*     for more details.
*
*     You should have received a copy of the GNU General Public License along
*     with this program; if not, write to the Free Software Foundation, Inc., 59
*     Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*/

package com.openexchange.office.tools.doc;

import org.apache.commons.lang.StringUtils;

import com.openexchange.office.tools.user.UserData;
import com.openexchange.realtime.packet.ID;



public class DocContextLogger {

    public static String getContextString(final String user, final String folderId, final String fileId) {
        final StringBuffer buf = new StringBuffer(128);

        buf.append(StringUtils.isEmpty(user) ? "unknown": user);
        buf.append(", ");
        buf.append(StringUtils.isEmpty(folderId) ? "???" : folderId);
        buf.append(".");
        buf.append(StringUtils.isEmpty(fileId) ? "???" : fileId);
        return buf.toString();
    }

    public static String getContextStringWithDoc(boolean debugInfo, final ID id, final UserData userData, final OXDocument oxDoc) {
        final String idString = (null != id) ? id.toString() : null;
        final String folderId = ((null != userData) ? StringUtils.isEmpty(userData.getFolderId()) ? "???" : userData.getFolderId() : "???");
        final String fileId = ((null != userData) ? StringUtils.isEmpty(userData.getFileId()) ? "???" : userData.getFileId() : "???");
        final String fileName = oxDoc.getDocumentMetaData().getFileName();

        return getContextStringWithDoc(debugInfo, idString, folderId, fileId, fileName);
    }

    public static String getContextStringWithDoc(boolean debugInfo, final ID id, final String folder_id, final String file_id, final OXDocument oxDoc) {
        final String idString = (null != id) ? id.toString() : null;
        final String folderId = StringUtils.isEmpty(folder_id) ? "???" : folder_id;
        final String fileId = StringUtils.isEmpty(file_id) ? "???" : file_id;
        final String fileName = oxDoc.getDocumentMetaData().getFileName();

        return getContextStringWithDoc(debugInfo, idString, folderId, fileId, fileName);
    }

    public static String getContextStringWithDoc(boolean debugInfo, final String id, final String folderId, final String fileId, final String fileName) {
        final StringBuffer buf = new StringBuffer(128);

        buf.append(StringUtils.isEmpty(id) ? "unknown": id);
        buf.append(", ");
        buf.append(StringUtils.isEmpty(folderId) ? "???" : folderId);
        buf.append(".");
        buf.append(StringUtils.isEmpty(fileId) ? "???" : fileId);
        if (debugInfo) {
            buf.append(", ");
            buf.append(StringUtils.isEmpty(fileName) ? "unknown doc name" : fileName);
        }
        return buf.toString();
    }

}
