package com.openexchange.office.ooxml.pptx.components;

import java.text.ParseException;

import javax.xml.bind.JAXBException;

import org.docx4j.IndexedNode;
import org.docx4j.dml.CTTextField;
import org.docx4j.dml.CTTextListStyle;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.json.JSONException;
import org.json.JSONObject;
import org.pptx4j.pml.CTPlaceholder;
import org.pptx4j.pml.STPlaceholderType;
import org.pptx4j.pml.Shape;
import org.pptx4j.pml.SldMaster;

import com.openexchange.office.FilterException;
import com.openexchange.office.ooxml.OperationDocument;
import com.openexchange.office.ooxml.components.Component;
import com.openexchange.office.ooxml.components.ComponentContext;
import com.openexchange.office.ooxml.drawingml.DMLHelper;
import com.openexchange.office.ooxml.operations.CreateOperationHelper;
import com.openexchange.office.ooxml.pptx.tools.PMLShapeHelper;

public class TextFieldComponent extends PptxComponent {

	TextFieldComponent(ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);
    }

	@Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
		return null;
	}

	@Override
	public void applyAttrsFromJSON(OperationDocument operationDocument, JSONObject attrs)
			throws JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

		if(attrs!=null) {
			if(attrs.hasAndNotNull("character")) {
				final IShapeComponent iShapeComponent = getParagraphComponent().getShapeComponent();
				if(iShapeComponent.isPresentationObject()) {
					final ShapeComponent shapeComponent = (ShapeComponent)iShapeComponent;
					final SlideComponent slideComponent = PMLShapeHelper.getSlideComponent(shapeComponent);
					final Part slidePart = (Part)slideComponent.getObject();
					if(slidePart instanceof SlideMasterPart) {
						final Shape shape = (Shape)shapeComponent.getObject();
						final CTPlaceholder placeholder = shape.getNvSpPr().getNvPr().getPh();
						if(placeholder.getType()==STPlaceholderType.TITLE) {
							final SldMaster sldMaster = ((SlideMasterPart)slidePart).getJaxbElement();
							applyStyleFormatting(operationDocument, sldMaster.getTxStyles().getTitleStyle(), attrs);
						}
						else if(placeholder.getType()==STPlaceholderType.BODY) {
							final SldMaster sldMaster = ((SlideMasterPart)slidePart).getJaxbElement();
							applyStyleFormatting(operationDocument, sldMaster.getTxStyles().getBodyStyle(), attrs);
						}
						else {
							// presentation object on master slide
							applyObjectStyleFormatting(operationDocument, shapeComponent, attrs);
						}
					}
					else if(slidePart instanceof SlideLayoutPart) {
						// presentation object on layout slide -> the object style is attributed
						applyObjectStyleFormatting(operationDocument, shapeComponent, attrs);
					}
					else {
						// presentation object on normal slide -> the object is hard formatted
						applyHardFormatting(operationDocument, attrs);
					}
				}
				else {
					applyHardFormatting(operationDocument, attrs);
				}
			}
		}
	}

	@Override
	public JSONObject createJSONAttrs(CreateOperationHelper createOperationHelper, JSONObject attrs)
			throws JSONException, ParseException, FilterException {

		DMLHelper.createJsonFromTextCharacterProperties(attrs, ((CTTextField)getObject()).getRPr(false), createOperationHelper.getOperationDocument().getContextPart());
		return attrs;
	}

	public ParagraphComponent getParagraphComponent() {
		return (ParagraphComponent)getParentComponent();
	}

	private void applyStyleFormatting(OperationDocument operationDocument, CTTextListStyle textListStyle, JSONObject attrs)
		throws InvalidFormatException, PartUnrecognisedException, JSONException {

		DMLHelper.applyTextCharacterPropertiesFromJson(textListStyle.getPPr(getParagraphComponent().getLevel(), true).getDefRPr(true), attrs, operationDocument.getContextPart());
	}

	private void applyObjectStyleFormatting(OperationDocument operationDocument, ShapeComponent shapeComponent, JSONObject attrs)
		throws JSONException {

		DMLHelper.applyTextCharacterPropertiesFromJson(shapeComponent.getTextBody(true), getParagraphComponent().getLevel(), attrs, operationDocument.getContextPart());
	}

	private void applyHardFormatting(OperationDocument operationDocument, JSONObject attrs)
		throws JSONException {

		DMLHelper.applyTextCharacterPropertiesFromJson(((CTTextField)getObject()).getRPr(true), attrs, operationDocument.getContextPart());
	}
}
