/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 *
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odt.dom.components;

import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.component.OdfOperationDocument;
import org.xml.sax.SAXException;

import com.openexchange.office.odf.DLList;
import com.openexchange.office.odf.DLNode;
import com.openexchange.office.odt.dom.Text;
import com.openexchange.office.odt.dom.TextSpan;

public class TextComponent extends TextSpan_Base {

	public TextComponent(ComponentContext parentContext, DLNode<Object> textNode, int componentNumber) {
		super(parentContext, textNode, componentNumber);
	}

	@Override
    public int getNextComponentNumber() {
        int textLength = ((Text)getObject()).getText().length();
        if (textLength==0) {
            System.out.println("Error: empty text string is no component... this results in problems with the component iterator");
            textLength++;       // increasing.. preventing an endless loop
        }
        return componentNumber + textLength;
    }

    @Override
    public void splitStart(int componentPosition) {
    	final int splitPosition = componentPosition-componentNumber;
    	if(splitPosition>0) {
    		splitText(splitPosition, true);
    		componentNumber+=splitPosition;
    	}
    	splitTextSpan(true);
    }

    @Override
    public void splitEnd(int componentPosition) {
    	if(getNextComponentNumber()>++componentPosition) {
    		splitText(componentPosition-componentNumber, false);
    	}
    	splitTextSpan(false);
    }

	@Override
	public JSONObject createJSONAttrs(OdfOperationDocument operationDocument, JSONObject attrs)
		throws JSONException, SAXException {

		return super.createJSONAttrs(operationDocument, attrs);
	}

    private void splitText(int textSplitPosition, boolean splitStart) {
    	final Text text = (Text)getNode().getObject();
        if(textSplitPosition>0&&textSplitPosition<text.getText().length()) {
        	final DLNode<Object> textSpanNode = getParentContext().getNode();
        	final TextSpan textSpan = (TextSpan)textSpanNode.getObject();
        	final DLList<Object> textSpanContent = textSpan.getContent();
            final StringBuffer s = new StringBuffer(text.getText());
            if(splitStart) {
            	final Text newText = new Text(s.substring(0, textSplitPosition));
                textSpanContent.addNode(getNode(), new DLNode<Object>(newText), true);
                text.setText(s.substring(textSplitPosition));
            }
            else {
            	final Text newText = new Text(s.substring(textSplitPosition));
            	textSpanContent.addNode(getNode(), new DLNode<Object>(newText), false);
                text.setText(s.substring(0, textSplitPosition));
            }
        }
    }
}
