/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odt.dom;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import com.openexchange.office.odf.ElementNSWriter;
import com.openexchange.office.odf.SaxContextHandler;
import com.openexchange.office.odf.UnknownContentHandler;

public class StyleMasterPageHandler extends SaxContextHandler {

	final StyleMasterPage styleMasterPage;

	public StyleMasterPageHandler(SaxContextHandler parentContext, StyleMasterPage styleMasterPage) {
		super(parentContext);

		this.styleMasterPage = styleMasterPage;
	}

	@Override
    public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName)
    	throws SAXException {

		if(qName.equals("style:header")) {
			final String id = getHeaderFooterId();
			final StyleHeader styleHeader = new StyleHeader(id, false, attributes);
			styleMasterPage.getStyleHeaders().add(styleHeader);
			getFileDom().getTargetNodes().put(id, styleHeader);
			return new StyleHeaderHandler(this, styleHeader);
		}
		else if(qName.equals("style:header-left")) {
			final String id = getHeaderFooterId();
			final StyleHeader styleHeader = new StyleHeader(id, true, attributes);
			styleMasterPage.getStyleHeaders().add(styleHeader);
			getFileDom().getTargetNodes().put(id, styleHeader);
			return new StyleHeaderHandler(this, styleHeader);
		}
		else if(qName.equals("style:footer")) {
			final String id = getHeaderFooterId();
			final StyleFooter styleFooter = new StyleFooter(id, false, attributes);
			styleMasterPage.getStyleFooters().add(styleFooter);
			getFileDom().getTargetNodes().put(id, styleFooter);
			return new StyleFooterHandler(this, styleFooter);
		}
		else if(qName.equals("style:footer-left")) {
			final String id = getHeaderFooterId();
			final StyleFooter styleFooter = new StyleFooter(id, true, attributes);
			styleMasterPage.getStyleFooters().add(styleFooter);
			getFileDom().getTargetNodes().put(id, styleFooter);
			return new StyleFooterHandler(this, styleFooter);
		}
    	final ElementNSWriter element = new ElementNSWriter(getFileDom(), attributes, uri, qName);
    	styleMasterPage.getContent().add(element);
		return new UnknownContentHandler(this, element);
    }

	private String getHeaderFooterId() {
		return "hf" + styleMasterPage.getName() + styleMasterPage.getPageLayoutName() + getFileDom().getNextMarkupId();
	}
}
