/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ods.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import com.openexchange.office.odf.OfficeStyles;

public class Sheets extends ArrayList<Sheet> {

	final private OfficeStyles officeStyles;

	public Sheets(OfficeStyles officeStyles) {
		this.officeStyles = officeStyles;
	}

	@Override
	public boolean add(Sheet e) {
		incStyleUsage(e);
		return super.add(e);
	}

	@Override
	public boolean addAll(Collection<? extends Sheet> c) {
		final Iterator<? extends Sheet> iter = c.iterator();
		while(iter.hasNext()) {
			incStyleUsage(iter.next());
		}
		return super.addAll(c);
	}

	@Override
	public void clear() {
		final Iterator<Sheet> iter = iterator();
		while(iter.hasNext()) {
			decStyleUsage(iter.next());
		}
		super.clear();
	}

	@Override
	public boolean remove(Object o) {
		decStyleUsage((Sheet)o);
		return super.remove(o);
	}

	@Override
	public boolean removeAll(Collection<?> c) {
		final Iterator<?> iter = c.iterator();
		while(iter.hasNext()) {
			decStyleUsage((Sheet)iter.next());
		}
		return super.removeAll(c);
	}

	private void incStyleUsage(Sheet e) {
		if(e.getStyleName()!=null) {
			officeStyles.incStyleUsage(e.getStyleFamily(), e.getStyleName());
		}
	}

	private void decStyleUsage(Sheet e) {
		if(e.getStyleName()!=null) {
			officeStyles.decStyleUsage(e.getStyleFamily(), e.getStyleName());
		}
	}
}
