/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ods.dom;

import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.dom.attribute.table.TableBaseCellAddressAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableCellRangeAddressAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableExpressionAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableRangeUsableAsAttribute;
import org.odftoolkit.odfdom.dom.element.table.TableNamedExpressionElement;
import org.odftoolkit.odfdom.dom.element.table.TableNamedRangeElement;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.xml.sax.Attributes;

import com.openexchange.office.odf.SaxContextHandler;

public class NamedExpression {

	private String 	name;
	private String 	baseCellAddress;
	private String	expression;
	private String	cellRangeAddress;
	private String	rangeUsableAs;

	public NamedExpression(String name) {
		this.name = name;
	}

	public NamedExpression(Attributes attributes) {
		name = attributes.getValue(TableNameAttribute.ATTRIBUTE_NAME.getQName());
		baseCellAddress = attributes.getValue(TableBaseCellAddressAttribute.ATTRIBUTE_NAME.getQName());
		expression = attributes.getValue(TableExpressionAttribute.ATTRIBUTE_NAME.getQName());
		cellRangeAddress = attributes.getValue(TableCellRangeAddressAttribute.ATTRIBUTE_NAME.getQName());
		rangeUsableAs = attributes.getValue(TableRangeUsableAsAttribute.ATTRIBUTE_NAME.getQName());
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getBaseCellAddress() {
		return baseCellAddress;
	}

	public void setBaseCellAddress(String baseCellAddress) {
		this.baseCellAddress = baseCellAddress;
	}

	public String getCellRangeAddress() {
		return cellRangeAddress;
	}

	public void setCellRangeAddress(String cellRangeAddress) {
		this.cellRangeAddress = cellRangeAddress;
		expression = null;
	}

	public String getExpression() {
		return expression;
	}

	public void setExpression(String expression) {
		this.expression = expression;
		cellRangeAddress = null;
		rangeUsableAs = null;
	}

	public void writeObject(SerializationHandler output) {

		final boolean namedExpression = expression!=null;
		final OdfName elementName = namedExpression ? TableNamedExpressionElement.ELEMENT_NAME : TableNamedRangeElement.ELEMENT_NAME;
    	SaxContextHandler.startElement(output, elementName);
    	SaxContextHandler.addOdfAttribute(output, TableNameAttribute.ATTRIBUTE_NAME, null, name);
    	SaxContextHandler.addOdfAttribute(output, TableBaseCellAddressAttribute.ATTRIBUTE_NAME, null, baseCellAddress==null?"":baseCellAddress);
    	if(namedExpression) {
        	SaxContextHandler.addOdfAttribute(output, TableExpressionAttribute.ATTRIBUTE_NAME, null, expression);
    	}
    	else {
        	SaxContextHandler.addOdfAttribute(output, TableCellRangeAddressAttribute.ATTRIBUTE_NAME, null, cellRangeAddress==null?"":cellRangeAddress);
        	if(rangeUsableAs!=null) {
        		SaxContextHandler.addOdfAttribute(output, TableRangeUsableAsAttribute.ATTRIBUTE_NAME, null, rangeUsableAs);
        	}
    	}
    	SaxContextHandler.endElement(output, elementName);
	}
}
