/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ods.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.dom.element.table.TableShapesElement;

import com.openexchange.office.odf.SaxContextHandler;

public class Drawings {

	// each drawing of a page
	private final List<Drawing> indexedDrawings;
	// each drawing that is anchored to a cell (top left anchor position is hashed)
	private final HashMap<DrawingAnchor, List<Drawing>> anchoredDrawings;

	public Drawings() {
		indexedDrawings = new ArrayList<Drawing>();
		anchoredDrawings = new HashMap<DrawingAnchor, List<Drawing>>();
    }

	public void writeSheetDrawings(SerializationHandler output) {
		for(Drawing drawing:indexedDrawings) {
			// only writing drawings without anchor...
			if(drawing.getAnchor()==null) {
				SaxContextHandler.startElement(output, TableShapesElement.ELEMENT_NAME);
				drawing.writeDrawing(output);
				SaxContextHandler.endElement(output, TableShapesElement.ELEMENT_NAME);
			}
		}
	}

	public int getCount() {
		return indexedDrawings.size();
	}

	public Drawing getDrawing(int index) {
		return indexedDrawings.get(index);
	}

	public void addDrawing(Drawing drawing) {
		addDrawing(drawing, indexedDrawings.size());
	}

	public void addDrawing(Drawing drawing, int index) {
		indexedDrawings.add(index, drawing);
		final DrawingAnchor anchor = drawing.getAnchor();
		if(anchor!=null) {
			List<Drawing> anchoredDrawingsList = anchoredDrawings.get(anchor);
			if(anchoredDrawingsList==null) {
				anchoredDrawingsList = new ArrayList<Drawing>();
				anchoredDrawings.put(anchor, anchoredDrawingsList);
			}
			anchoredDrawingsList.add(drawing);
		}
	}

	public void setDrawingAnchor(DrawingAnchor newAnchor, int index) {

		final Drawing drawing = indexedDrawings.get(index);

		// first removing the old anchor if any
		if(drawing.getAnchor()!=null) {
			final List<Drawing> anchoredDrawingList = anchoredDrawings.get(drawing.getAnchor());
			anchoredDrawingList.remove(drawing);
			if(anchoredDrawingList.isEmpty()) {
				anchoredDrawings.remove(drawing.getAnchor());
			}
 		}
		// adding our new drawingAnchor
		drawing.setDrawingAnchor(newAnchor);
		if(newAnchor!=null) {
			List<Drawing> anchoredDrawingsList = anchoredDrawings.get(newAnchor);
			if(anchoredDrawingsList==null) {
				anchoredDrawingsList = new ArrayList<Drawing>();
				anchoredDrawings.put(newAnchor, anchoredDrawingsList);
			}
			anchoredDrawingsList.add(drawing);
		}
	}

	public List<Drawing> getAnchoredDrawings(DrawingAnchor drawingAnchor) {
		return anchoredDrawings.get(drawingAnchor);
	}

	public void deleteDrawing(int index) {
		final Drawing drawing = indexedDrawings.remove(index);
		if(drawing.getAnchor()!=null) {
			final List<Drawing> anchoredDrawingList = anchoredDrawings.get(drawing.getAnchor());
			anchoredDrawingList.remove(drawing);
			if(anchoredDrawingList.isEmpty()) {
				anchoredDrawings.remove(drawing.getAnchor());
			}
		}
	}
}
